/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.netbeans.modules.autoupdate.IdeDescription;
import org.netbeans.modules.autoupdate.L10NUpdate;
import org.netbeans.modules.autoupdate.ModuleUpdate;
import org.netbeans.modules.autoupdate.Updates;
import org.netbeans.modules.autoupdate.Wizard;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.modules.Dependency;
import org.openide.modules.ModuleInfo;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;

class DependencyChecker {
    private static final ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.modules.autoupdate");

    DependencyChecker() {
    }

    Collection modulesToAdd(ModuleUpdate moduleUpdate, Enumeration enumeration, List list, StringBuffer stringBuffer) {
        err.log("DO modulesToAdd: " + moduleUpdate.getCodeNameBase() + "[L10N? " + (moduleUpdate instanceof L10NUpdate) + "], group: " + list + ", dontAddModuleName: " + stringBuffer);
        ArrayList arrayList = new ArrayList();
        this.checkDependencies(moduleUpdate.getRemoteModule(), arrayList, enumeration, list, stringBuffer, moduleUpdate.getLocalModule() != null);
        if (err.isLoggable(1)) {
            String string = "";
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                ModuleUpdate moduleUpdate2 = (ModuleUpdate)iterator.next();
                string = string + moduleUpdate2.getCodeNameBase() + "[L10N? " + (moduleUpdate2 instanceof L10NUpdate) + "], ";
                err.log("modulesToAdd: " + moduleUpdate.getCodeNameBase() + ", RETURNS: " + string);
            }
        }
        err.log("Do find localization for " + moduleUpdate.getCodeNameBase() + " on locale " + Locale.getDefault());
        DependencyChecker.checkFreeLocalizationDependency(moduleUpdate, Locale.getDefault().toString(), arrayList, enumeration, list);
        return arrayList;
    }

    Collection modulesToRemove(ModuleUpdate moduleUpdate, ModuleUpdate moduleUpdate2) {
        ArrayList arrayList = new ArrayList();
        this.checkReverseDependencies(moduleUpdate.getRemoteModule(), arrayList, moduleUpdate2);
        return arrayList;
    }

    private boolean checkDependencies(ModuleInfo moduleInfo, Collection collection, Enumeration enumeration, List list, StringBuffer stringBuffer, boolean bl) {
        Object object;
        Set set = moduleInfo.getDependencies();
        Dependency[] dependencyArray = set.toArray(new Dependency[set.size()]);
        boolean[] blArray = new boolean[dependencyArray.length];
        ModuleInfo[] moduleInfoArray = Updates.getInstalledModules();
        ModuleInfo[] moduleInfoArray2 = Updates.getInstalledPatches();
        for (int i = 0; i < dependencyArray.length; ++i) {
            if (dependencyArray[i].getType() == 1 || dependencyArray[i].getType() == 5) {
                int n;
                boolean bl2 = false;
                for (n = 0; n < moduleInfoArray.length && !(bl2 = DependencyChecker.checkModuleDependency(dependencyArray[i], moduleInfoArray[n])); ++n) {
                }
                if (!bl2) {
                    for (n = 0; n < moduleInfoArray2.length && !(bl2 = DependencyChecker.checkModuleDependency(dependencyArray[i], moduleInfoArray2[n])); ++n) {
                    }
                }
                if (!bl2 && enumeration != null) {
                    while (enumeration.hasMoreElements()) {
                        ModuleUpdate moduleUpdate = (ModuleUpdate)enumeration.nextElement();
                        if (moduleUpdate instanceof L10NUpdate || !(bl2 = DependencyChecker.checkModuleDependency(dependencyArray[i], moduleUpdate.getRemoteModule()))) continue;
                        if (collection.contains(moduleUpdate)) break;
                        err.log("  ADDED[SELECTED]: " + moduleUpdate.getCodeNameBase() + "[L10N? " + (moduleUpdate instanceof L10NUpdate) + "]: DEP: " + dependencyArray[i]);
                        collection.add(moduleUpdate);
                        break;
                    }
                }
                if (!bl2 && list != null) {
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        object = (ModuleUpdate)iterator.next();
                        if (object instanceof L10NUpdate || !(bl2 = DependencyChecker.checkModuleDependency(dependencyArray[i], ((ModuleUpdate)object).getRemoteModule()))) continue;
                        if (collection.contains(object)) break;
                        err.log("  ADDED[GROUP]: " + ((ModuleUpdate)object).getCodeNameBase() + "[L10N? " + (object instanceof L10NUpdate) + "]: DEP: " + dependencyArray[i]);
                        collection.add(object);
                        break;
                    }
                }
                if (!bl2) {
                    Iterator iterator = Wizard.getAllModules().iterator();
                    while (iterator.hasNext()) {
                        object = (ModuleUpdate)iterator.next();
                        if (object instanceof L10NUpdate || !(bl2 = DependencyChecker.checkModuleDependency(dependencyArray[i], ((ModuleUpdate)object).getRemoteModule()))) continue;
                        if (collection.contains(object)) break;
                        err.log("  ADDED[ALL]: " + ((ModuleUpdate)object).getCodeNameBase() + "[L10N? " + (object instanceof L10NUpdate) + "]: DEP: " + dependencyArray[i]);
                        collection.add(object);
                        break;
                    }
                }
                if (!bl2) {
                    blArray[i] = false;
                    continue;
                }
                blArray[i] = true;
                continue;
            }
            if (dependencyArray[i].getType() == 4) {
                if (this.checkIdeDependency(dependencyArray[i], IdeDescription.getIdeDescription())) {
                    blArray[i] = true;
                    continue;
                }
                Iterator iterator = Wizard.getAllModules().iterator();
                boolean bl3 = false;
                while (iterator.hasNext()) {
                    object = (ModuleUpdate)iterator.next();
                    if (object instanceof L10NUpdate || !(bl3 = DependencyChecker.checkModuleDependency(dependencyArray[i], ((ModuleUpdate)object).getRemoteModule()))) continue;
                    if (collection.contains(object)) break;
                    err.log("  ADDED[GROUP]: " + ((ModuleUpdate)object).getCodeNameBase() + "[L10N? " + (object instanceof L10NUpdate) + "]: DEP: " + dependencyArray[i]);
                    collection.add(object);
                    break;
                }
                blArray[i] = bl3;
                continue;
            }
            blArray[i] = true;
        }
        StringBuffer stringBuffer2 = new StringBuffer(280);
        stringBuffer2.append(this.getBundle("MSG_NotSatisfied") + this.getBundle("TXT_DependencyChecker_Module") + moduleInfo.getCodeName() + " ");
        int n = 0;
        for (int i = 0; i < dependencyArray.length; ++i) {
            if (blArray[i]) continue;
            stringBuffer2.append(dependencyArray[i]);
            ++n;
        }
        StringBuffer stringBuffer3 = null;
        if (bl && (object = this.checkBrokenImplDependency(moduleInfo, collection)).size() > 0) {
            stringBuffer3 = new StringBuffer(280);
            stringBuffer3.append("MODULE :" + moduleInfo.getCodeName());
            stringBuffer3.append(this.getBundle("MSG_BadsList"));
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                stringBuffer3.append("\n" + ((ModuleInfo)iterator.next()).getCodeName());
            }
            stringBuffer3.append(this.getBundle("MSG_IncludeBadsAnyway"));
        }
        if (n == 0 && stringBuffer3 == null) {
            return true;
        }
        if (n > 0) {
            stringBuffer2.append(this.getBundle("MSG_IncludeAnyway"));
            object = new NotifyDescriptor.Confirmation((Object)stringBuffer2.toString(), 0, 0);
            if (!DialogDisplayer.getDefault().notify((NotifyDescriptor)object).equals(NotifyDescriptor.YES_OPTION)) {
                stringBuffer.append(moduleInfo.getDisplayName());
                return false;
            }
        }
        if (stringBuffer3 != null) {
            object = new NotifyDescriptor.Confirmation((Object)stringBuffer3.toString(), 0, 0);
            if (!DialogDisplayer.getDefault().notify((NotifyDescriptor)object).equals(NotifyDescriptor.YES_OPTION)) {
                stringBuffer.append(moduleInfo.getDisplayName());
            }
        }
        return false;
    }

    boolean checkReverseDependencies(ModuleInfo moduleInfo, Collection collection, ModuleUpdate moduleUpdate) {
        ModuleInfo[] moduleInfoArray = Updates.getInstalledModules();
        ModuleInfo[] moduleInfoArray2 = Updates.getInstalledPatches();
        Iterator iterator = Wizard.getAllModules().iterator();
        while (iterator.hasNext()) {
            ModuleUpdate moduleUpdate2 = (ModuleUpdate)iterator.next();
            ModuleInfo moduleInfo2 = moduleUpdate2.getRemoteModule();
            Set set = moduleInfo2.getDependencies();
            Dependency[] dependencyArray = set.toArray(new Dependency[set.size()]);
            boolean bl = true;
            for (int i = 0; i < dependencyArray.length; ++i) {
                if (dependencyArray[i].getType() == 1 && (dependencyArray[i].getName() + "/").startsWith(moduleInfo.getCodeNameBase() + "/") || dependencyArray[i].getType() == 5 && Arrays.asList(moduleInfo.getProvides()).contains(dependencyArray[i].getName())) {
                    int n;
                    boolean bl2 = false;
                    for (n = 0; n < moduleInfoArray.length && !(bl2 = DependencyChecker.checkModuleDependency(dependencyArray[i], moduleInfoArray[n])); ++n) {
                    }
                    if (!bl2 && moduleUpdate != null) {
                        bl2 = DependencyChecker.checkModuleDependency(dependencyArray[i], moduleUpdate.getRemoteModule());
                    }
                    if (!bl2) {
                        for (n = 0; n < moduleInfoArray2.length && !(bl2 = DependencyChecker.checkModuleDependency(dependencyArray[i], moduleInfoArray2[n])); ++n) {
                        }
                    }
                    if (bl2) continue;
                    bl = false;
                    break;
                }
                if (dependencyArray[i].getType() != 4 || !dependencyArray[i].getName().equals(moduleInfo.getCodeName()) || DependencyChecker.checkModuleDependency(dependencyArray[i], IdeDescription.getIdeDescription())) continue;
                bl = false;
                break;
            }
            if (bl || collection.contains(moduleUpdate2)) continue;
            collection.add(moduleUpdate2);
        }
        return collection.size() == 0;
    }

    static boolean checkModuleDependency(Dependency dependency, ModuleInfo moduleInfo) {
        if (dependency.getType() == 5) {
            return Arrays.asList(moduleInfo.getProvides()).contains(dependency.getName());
        }
        String string = dependency.getName();
        if (string.equals(moduleInfo.getCodeName())) {
            if (dependency.getComparison() == 3) {
                return true;
            }
            if (dependency.getComparison() == 1) {
                if (moduleInfo.getSpecificationVersion() == null) {
                    return false;
                }
                return new SpecificationVersion(dependency.getVersion()).compareTo((Object)moduleInfo.getSpecificationVersion()) <= 0;
            }
            if (moduleInfo.getImplementationVersion() == null) {
                return false;
            }
            return moduleInfo.getImplementationVersion().equals(dependency.getVersion());
        }
        int n = string.indexOf(45);
        if (n != -1) {
            int n2 = string.indexOf(47);
            String string2 = string.substring(0, n2);
            int n3 = Integer.parseInt(string.substring(n2 + 1, n));
            int n4 = Integer.parseInt(string.substring(n + 1));
            if (string2.equals(moduleInfo.getCodeNameBase()) && n3 <= moduleInfo.getCodeNameRelease() && n4 >= moduleInfo.getCodeNameRelease()) {
                if (dependency.getComparison() == 3) {
                    return true;
                }
                if (moduleInfo.getCodeNameRelease() > n3) {
                    return true;
                }
                if (moduleInfo.getSpecificationVersion() == null) {
                    return false;
                }
                return new SpecificationVersion(dependency.getVersion()).compareTo((Object)moduleInfo.getSpecificationVersion()) <= 0;
            }
        }
        return false;
    }

    boolean checkIdeDependency(Dependency dependency, ModuleInfo moduleInfo) {
        String string = moduleInfo.getCodeName();
        SpecificationVersion specificationVersion = moduleInfo.getSpecificationVersion();
        String string2 = moduleInfo.getImplementationVersion();
        if (!string.equals(dependency.getName())) {
            return false;
        }
        if (dependency.getComparison() == 1) {
            return new SpecificationVersion(dependency.getVersion()).compareTo((Object)specificationVersion) <= 0;
        }
        if (dependency.getComparison() == 2) {
            return dependency.getVersion().equals(string2);
        }
        throw new IllegalStateException("Cannot have COMPARE_ANY on IDE dependency");
    }

    private List checkBrokenImplDependency(ModuleInfo moduleInfo, Collection collection) {
        ModuleInfo[] moduleInfoArray = Updates.getInstalledModules();
        ArrayList<ModuleInfo> arrayList = new ArrayList<ModuleInfo>();
        block0: for (int i = 0; i < moduleInfoArray.length; ++i) {
            Iterator iterator = moduleInfoArray[i].getDependencies().iterator();
            while (iterator.hasNext()) {
                Dependency dependency = (Dependency)iterator.next();
                if (!dependency.getName().equals(moduleInfo.getCodeName()) || dependency.getComparison() != 2) continue;
                if (dependency.getVersion().equals(moduleInfo.getImplementationVersion())) continue block0;
                Iterator iterator2 = Wizard.getAllModules().iterator();
                boolean bl = false;
                while (iterator2.hasNext()) {
                    ModuleUpdate moduleUpdate = (ModuleUpdate)iterator2.next();
                    if (!moduleUpdate.getRemoteModule().getCodeName().equals(moduleInfoArray[i].getCodeName()) || moduleUpdate.getRemoteModule().getSpecificationVersion().compareTo((Object)moduleInfoArray[i].getSpecificationVersion()) <= 0) continue;
                    boolean bl2 = true;
                    Iterator iterator3 = moduleUpdate.getRemoteModule().getDependencies().iterator();
                    while (iterator3.hasNext()) {
                        Dependency dependency2 = (Dependency)iterator3.next();
                        if (!dependency2.getName().equals(moduleInfo.getCodeName()) || dependency2.getComparison() != 2 || dependency2.getVersion().equals(moduleInfo.getImplementationVersion())) continue;
                        bl2 = false;
                        break;
                    }
                    if (!bl2) continue;
                    if (!collection.contains(moduleUpdate)) {
                        collection.add(moduleUpdate);
                    }
                    bl = true;
                    break;
                }
                if (bl) continue block0;
                arrayList.add(moduleInfoArray[i]);
                continue block0;
            }
        }
        return arrayList;
    }

    static boolean checkPlatformDependency(ModuleInfo moduleInfo) {
        Set set = moduleInfo.getDependencies();
        Iterator iterator = set.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            Dependency dependency = (Dependency)iterator.next();
            if (5 != dependency.getType() || !dependency.getName().startsWith("org.openide.modules.os")) continue;
            bl = false;
            ModuleInfo[] moduleInfoArray = Updates.getInstalledModules();
            for (int i = 0; !bl && i < moduleInfoArray.length; ++i) {
                bl = DependencyChecker.checkModuleDependency(dependency, moduleInfoArray[i]);
            }
            err.log("checkPlatformDependency on module " + moduleInfo.getCodeNameBase() + " which requires " + dependency + " returns " + bl);
        }
        return bl;
    }

    private static boolean checkFreeLocalizationDependency(ModuleUpdate moduleUpdate, String string, Collection collection, Enumeration enumeration, List list) {
        L10NUpdate l10NUpdate;
        ModuleUpdate moduleUpdate2;
        Object object;
        boolean bl = false;
        if (moduleUpdate instanceof L10NUpdate) {
            return false;
        }
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                object = (ModuleUpdate)enumeration.nextElement();
                if (!(object instanceof L10NUpdate) || !(bl = string.equals(((L10NUpdate)(moduleUpdate2 = (L10NUpdate)object)).getLangcode()) && moduleUpdate2.getCodeNameBase().equals(moduleUpdate.getCodeNameBase()))) continue;
                if (collection.contains(moduleUpdate2)) break;
                err.log("  ADDED[SELECTED]: " + moduleUpdate2.getCodeNameBase() + "[" + ((L10NUpdate)moduleUpdate2).getLangcode() + "]");
                collection.add(moduleUpdate2);
                break;
            }
        }
        if (!bl && list != null) {
            object = list.iterator();
            while (object.hasNext()) {
                moduleUpdate2 = (ModuleUpdate)object.next();
                if (!(moduleUpdate2 instanceof L10NUpdate) || !(bl = string.equals((l10NUpdate = (L10NUpdate)moduleUpdate2).getLangcode()) && l10NUpdate.getCodeNameBase().equals(moduleUpdate.getCodeNameBase()))) continue;
                if (collection.contains(l10NUpdate)) break;
                err.log("  ADDED[GROUP]: " + l10NUpdate.getCodeNameBase() + "[" + l10NUpdate.getLangcode() + "]");
                collection.add(l10NUpdate);
                break;
            }
        }
        if (!bl) {
            object = Wizard.getAllModules().iterator();
            while (object.hasNext()) {
                moduleUpdate2 = (ModuleUpdate)object.next();
                if (!(moduleUpdate2 instanceof L10NUpdate) || !(bl = string.equals((l10NUpdate = (L10NUpdate)moduleUpdate2).getLangcode()) && l10NUpdate.getCodeNameBase().equals(moduleUpdate.getCodeNameBase()))) continue;
                if (collection.contains(l10NUpdate)) break;
                err.log("  ADDED[ALL]: " + l10NUpdate.getCodeNameBase() + "[" + l10NUpdate.getLangcode() + "]");
                collection.add(l10NUpdate);
                break;
            }
        }
        return bl;
    }

    private String getBundle(String string) {
        return NbBundle.getMessage((Class)DependencyChecker.class, (String)string);
    }

    static Comparator getModuleDependencyComparator() {
        return new ModuleDependencyComparator();
    }

    static class ModuleDependencyComparator
    implements Comparator {
        ModuleDependencyComparator() {
        }

        public int compare(Object object, Object object2) {
            ModuleInfo moduleInfo;
            if (!(object instanceof ModuleUpdate) || !(object2 instanceof ModuleUpdate)) {
                return 0;
            }
            ModuleInfo moduleInfo2 = ((ModuleUpdate)object).getRemoteModule();
            if (this.moduleDependsOnModule(moduleInfo2, moduleInfo = ((ModuleUpdate)object2).getRemoteModule())) {
                return 1;
            }
            if (this.moduleDependsOnModule(moduleInfo, moduleInfo2)) {
                return -1;
            }
            return 0;
        }

        private boolean moduleDependsOnModule(ModuleInfo moduleInfo, ModuleInfo moduleInfo2) {
            Set set = moduleInfo.getDependencies();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Dependency dependency = (Dependency)iterator.next();
                if (dependency.getType() != 1 && dependency.getType() != 5 || !DependencyChecker.checkModuleDependency(dependency, moduleInfo2)) continue;
                return true;
            }
            return false;
        }
    }
}

