/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate;

import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import org.netbeans.updater.UpdateTracking;
import org.openide.ErrorManager;
import org.openide.LifecycleManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.modules.InstalledFileLocator;
import org.openide.modules.ModuleInfo;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.SharedClassObject;
import org.openide.windows.WindowManager;

class Autoupdater {
    private static boolean isRunning = false;
    private static WindowListener l;
    private static Object settingsInstance;
    private static Method mGetProxyType;
    private static Method mSetProxyType;
    private static Method mGetProxyHost;
    private static Method mSetProxyHost;
    private static Method mGetProxyPort;
    private static Method mSetProxyPort;
    private static boolean reflectionAlreadyTried;
    private static final String PROXY_HOST = "http.proxyHost";
    private static final String PROXY_PORT = "http.proxyPort";
    static /* synthetic */ Class class$org$openide$modules$ModuleInfo;
    static /* synthetic */ Class class$org$netbeans$modules$autoupdate$Autoupdater;

    Autoupdater() {
    }

    static boolean isRunning() {
        return isRunning;
    }

    static void setRunning(boolean bl) {
        isRunning = bl;
    }

    static void restart() {
        LifecycleManager.getDefault().exit();
    }

    static void installUpdateChecker(final Runnable runnable) {
        if (!Boolean.getBoolean("netbeans.full.hack") && !Boolean.getBoolean("netbeans.close")) {
            l = new WindowListener(){

                public void windowOpened(WindowEvent windowEvent) {
                    Autoupdater.doInstallUpdateChecker(runnable);
                }

                public void windowClosing(WindowEvent windowEvent) {
                }

                public void windowClosed(WindowEvent windowEvent) {
                }

                public void windowIconified(WindowEvent windowEvent) {
                }

                public void windowDeiconified(WindowEvent windowEvent) {
                }

                public void windowActivated(WindowEvent windowEvent) {
                }

                public void windowDeactivated(WindowEvent windowEvent) {
                }
            };
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    WindowManager.getDefault().getMainWindow().addWindowListener(l);
                }
            });
        }
    }

    private static void doInstallUpdateChecker(Runnable runnable) {
        RequestProcessor.getDefault().post(runnable, 5000);
        WindowManager.getDefault().getMainWindow().removeWindowListener(l);
    }

    private static boolean useReflection() {
        Autoupdater.initProxyMethodsMaybe();
        return mSetProxyPort != null;
    }

    private static synchronized void initProxyMethodsMaybe() {
        if (reflectionAlreadyTried) {
            return;
        }
        reflectionAlreadyTried = true;
        try {
            ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            Class<?> clazz = classLoader.loadClass("org.netbeans.core.IDESettings");
            settingsInstance = SharedClassObject.findObject(clazz, (boolean)true);
            mGetProxyType = clazz.getMethod("getProxyType", null);
            mSetProxyType = clazz.getMethod("setProxyType", Integer.TYPE);
            mGetProxyHost = clazz.getMethod("getUserProxyHost", null);
            mSetProxyHost = clazz.getMethod("setUserProxyHost", String.class);
            mGetProxyPort = clazz.getMethod("getUserProxyPort", null);
            mSetProxyPort = clazz.getMethod("setUserProxyPort", String.class);
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, (Throwable)exception);
        }
    }

    static int getProxyType() {
        if (Autoupdater.useReflection()) {
            try {
                return (Integer)mGetProxyType.invoke(settingsInstance, new Object[0]);
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(1, (Throwable)exception);
                return 1;
            }
        }
        return 1;
    }

    static String getUserProxyHost() {
        if (Autoupdater.useReflection()) {
            try {
                return (String)mGetProxyHost.invoke(settingsInstance, new Object[0]);
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(1, (Throwable)exception);
                return null;
            }
        }
        return System.getProperty(PROXY_HOST);
    }

    static String getUserProxyPort() {
        if (Autoupdater.useReflection()) {
            try {
                return (String)mGetProxyPort.invoke(settingsInstance, new Object[0]);
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(1, (Throwable)exception);
                return null;
            }
        }
        return System.getProperty(PROXY_PORT);
    }

    static void setProxyConfiguration(int n, String string, String string2) {
        if (Autoupdater.useReflection()) {
            try {
                mSetProxyType.invoke(settingsInstance, new Integer(n));
                mSetProxyHost.invoke(settingsInstance, string);
                mSetProxyPort.invoke(settingsInstance, string2);
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(1, (Throwable)exception);
            }
        } else if (n == 0) {
            System.setProperty(PROXY_HOST, "");
            System.setProperty(PROXY_PORT, "");
        } else {
            System.setProperty(PROXY_HOST, string);
            System.setProperty(PROXY_PORT, string2);
        }
    }

    static {
        reflectionAlreadyTried = false;
    }

    static class Support {
        private static final String FILE_SEPARATOR;
        private static final String UPDATE_DIR = "update";
        private static final String DOWNLOAD_DIR;
        private static final String PATCH_DIR;
        private static final String KS_FILE;
        public static final String LOG_FILE_NAME = "update.log";
        public static final String LATER_FILE_NAME = "install_later.xml";
        private static final String UPDATE_TEMP = "autoupdateTemp";
        private static FileObject tempDir;
        static final /* synthetic */ boolean $assertionsDisabled;

        private Support() {
        }

        public static ModuleInfo[] getModuleDescriptions() {
            Collection collection = Lookup.getDefault().lookup(new Lookup.Template(class$org$openide$modules$ModuleInfo == null ? (class$org$openide$modules$ModuleInfo = Autoupdater.class$("org.openide.modules.ModuleInfo")) : class$org$openide$modules$ModuleInfo)).allInstances();
            return collection.toArray(new ModuleInfo[collection.size()]);
        }

        public static File getDownloadDirectory(File file) {
            File file2;
            if (file == null) {
                file = new File(System.getProperty("netbeans.user"));
            }
            if (!(file2 = new File(file, DOWNLOAD_DIR)).isDirectory()) {
                file2.mkdirs();
            }
            return file2;
        }

        public static List getPatchDirectories() {
            ArrayList<File> arrayList = new ArrayList<File>();
            List list = UpdateTracking.clusters(true);
            if (!$assertionsDisabled && list == null) {
                throw new AssertionError((Object)"Clusters cannot be empty.");
            }
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                File file = (File)iterator.next();
                if (!$assertionsDisabled && !file.isDirectory()) {
                    throw new AssertionError((Object)("Cluster " + file + " is directory."));
                }
                arrayList.add(new File(file.getPath() + FILE_SEPARATOR + PATCH_DIR));
            }
            return arrayList;
        }

        static File getKSFile() {
            File file = InstalledFileLocator.getDefault().locate(KS_FILE, null, true);
            return file;
        }

        static File getInstall_Later(File file) {
            File file2 = new File(file.getPath() + FILE_SEPARATOR + DOWNLOAD_DIR + FILE_SEPARATOR + LATER_FILE_NAME);
            return file2;
        }

        static File getTempCopyFile(FileObject fileObject) {
            FileSystem fileSystem;
            File file = null;
            if (tempDir == null) {
                fileSystem = Repository.getDefault().getDefaultFileSystem();
                tempDir = fileSystem.getRoot().getFileObject(UPDATE_TEMP);
                try {
                    if (tempDir == null) {
                        tempDir = fileSystem.getRoot().createFolder(UPDATE_TEMP);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (tempDir != null) {
                try {
                    fileSystem = tempDir.getFileObject(fileObject.getName(), "nbm");
                    if (fileSystem == null) {
                        fileSystem = FileUtil.copyFile((FileObject)fileObject, (FileObject)tempDir, (String)fileObject.getName());
                    }
                    file = FileUtil.toFile((FileObject)fileSystem);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return file;
        }

        static void deleteTempDir() {
            if (tempDir == null) {
                FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
                tempDir = fileSystem.getRoot().getFileObject(UPDATE_TEMP);
            }
            if (tempDir != null) {
                try {
                    tempDir.delete();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$autoupdate$Autoupdater == null ? (class$org$netbeans$modules$autoupdate$Autoupdater = Autoupdater.class$("org.netbeans.modules.autoupdate.Autoupdater")) : class$org$netbeans$modules$autoupdate$Autoupdater).desiredAssertionStatus();
            FILE_SEPARATOR = System.getProperty("file.separator");
            DOWNLOAD_DIR = UPDATE_DIR + FILE_SEPARATOR + "download";
            PATCH_DIR = "lib" + FILE_SEPARATOR + "patches";
            KS_FILE = "core" + FILE_SEPARATOR + "ide.ks";
            tempDir = null;
        }
    }
}

