/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.netbeans.modules.masterfs.filebasedfs.FileBasedFileSystem;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.BaseFileObj;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;

public final class FileBasedURLMapper
extends URLMapper {
    public final URL getURL(FileObject fileObject, int n) {
        URL uRL = null;
        try {
            if (fileObject instanceof BaseFileObj) {
                BaseFileObj baseFileObj = (BaseFileObj)fileObject;
                uRL = FileBasedURLMapper.fileToURL(baseFileObj.getFileName().getFile(), fileObject);
            }
        }
        catch (MalformedURLException malformedURLException) {
            uRL = null;
        }
        return uRL;
    }

    public final FileObject[] getFileObjects(URL uRL) {
        File file;
        Object object;
        FileObject fileObject;
        block4: {
            if (!"file".equals(uRL.getProtocol())) {
                return null;
            }
            fileObject = null;
            try {
                object = uRL.getHost();
                String string = uRL.getFile();
                file = object != null && ((String)object).trim().length() != 0 ? new File("////" + (String)object + string) : (string.startsWith("//") ? new File(string) : FileUtil.normalizeFile((File)new File(URI.create(uRL.toExternalForm()))));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                file = new File(uRL.getFile());
                if (file.exists()) break block4;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(illegalArgumentException.getLocalizedMessage()).append(" [").append(uRL.toExternalForm()).append(']');
                ErrorManager.getDefault().notify((Throwable)new IllegalArgumentException(stringBuffer.toString()));
                return null;
            }
        }
        object = FileBasedFileSystem.getInstance(file);
        if (object != null) {
            fileObject = ((FileBasedFileSystem)((Object)object)).findFileObject(file);
        }
        return new FileObject[]{fileObject};
    }

    private static URL fileToURL(File file, FileObject fileObject) throws MalformedURLException {
        String string;
        URL uRL = null;
        if (fileObject.isFolder() && (!fileObject.isValid() || fileObject.isVirtual()) && !(string = file.toURI().toURL().toExternalForm()).endsWith("/")) {
            uRL = new URL(string + "/");
        }
        uRL = uRL == null ? file.toURI().toURL() : uRL;
        return uRL;
    }
}

