/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.extbrowser;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Iterator;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Lookup;

public class URLUtil {
    private static Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(URLMapper.class));

    public static URL createExternalURL(URL uRL, boolean bl) {
        if (uRL == null) {
            return null;
        }
        if (URLUtil.isAcceptableProtocol(uRL, bl)) {
            return uRL;
        }
        String string = uRL.getRef();
        String string2 = uRL.toString();
        int n = string2.indexOf(35);
        if (n >= 0) {
            string2 = string2.substring(0, n);
        }
        try {
            URL uRL2;
            FileObject fileObject = URLMapper.findFileObject((URL)new URL(string2));
            if (fileObject != null && (uRL2 = URLUtil.getURLOfAppropriateType(fileObject, bl)) != null) {
                string2 = uRL2.toString();
                if (n >= 0) {
                    string2 = string2 + "#" + string;
                }
                return new URL(string2);
            }
        }
        catch (MalformedURLException malformedURLException) {
            ErrorManager.getDefault().notify(1, (Throwable)malformedURLException);
        }
        return uRL;
    }

    private static URL getURLOfAppropriateType(FileObject fileObject, boolean bl) {
        URL uRL = null;
        Iterator iterator = result.allInstances().iterator();
        while (iterator.hasNext()) {
            URLMapper uRLMapper = (URLMapper)iterator.next();
            URL uRL2 = uRLMapper.getURL(fileObject, 1);
            if (uRL2 == null || !URLUtil.isAcceptableProtocol(uRL2, bl)) continue;
            String string = uRL2.getProtocol().toLowerCase();
            if ("file".equals(string) || "jar".equals(string)) {
                return uRL2;
            }
            uRL = uRL2;
        }
        if (uRL != null) {
            return uRL;
        }
        return URLUtil.makeURLLocal(URLMapper.findURL((FileObject)fileObject, (int)2));
    }

    private static URL makeURLLocal(URL uRL) {
        String string = uRL.getHost();
        try {
            if (string.equals(InetAddress.getLocalHost().getHostName())) {
                string = "127.0.0.1";
                return new URL(uRL.getProtocol(), string, uRL.getPort(), uRL.getFile());
            }
            return uRL;
        }
        catch (UnknownHostException unknownHostException) {
            return uRL;
        }
        catch (MalformedURLException malformedURLException) {
            return uRL;
        }
    }

    private static boolean isAcceptableProtocol(URL uRL, boolean bl) {
        String string;
        String string2 = uRL.getProtocol().toLowerCase();
        if ("http".equals(string2) || "ftp".equals(string2) || "file".equals(string2)) {
            return true;
        }
        return bl && "jar".equals(string2) && !(string = uRL.toString()).toLowerCase().startsWith("jar:nbinst:");
    }

    public static boolean browserHandlesJarURLs(String string) {
        return "MOZILLA".equals(string) || "FIREFOX".equals(string);
    }
}

