/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.settings;

import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.settings.ContextProvider;
import org.netbeans.spi.settings.Convertor;
import org.netbeans.spi.settings.ConvertorResolver;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.xml.EntityCatalog;
import org.openide.xml.XMLUtil;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class DOMConvertor
extends Convertor {
    private static final String ATTR_PUBLIC_ID = "dtd_public_id";
    private static final String ATTR_ID = "id";
    private static final String ATTR_IDREF = "idref";
    private static final String ELM_DELEGATE = "domconvertor";
    private static final Map refsCache = new HashMap();
    private static final Map ctxCache = new HashMap();
    private String publicID;
    private String systemID;
    private String rootElement;

    protected DOMConvertor(String string, String string2, String string3) {
        this.publicID = string;
        this.systemID = string2;
        this.rootElement = string3;
        if (string == null) {
            throw new NullPointerException("publicID");
        }
        if (string2 == null) {
            throw new NullPointerException("systemID");
        }
        if (string3 == null) {
            throw new NullPointerException("rootElement");
        }
    }

    public final Object read(Reader reader) throws IOException, ClassNotFoundException {
        Object object;
        block6: {
            Document document = null;
            try {
                InputSource inputSource = new InputSource(reader);
                document = XMLUtil.parse((InputSource)inputSource, (boolean)false, (boolean)false, null, (EntityResolver)EntityCatalog.getDefault());
                DOMConvertor.setDocumentContext(document, DOMConvertor.findContext(reader));
                object = this.readElement(document.getDocumentElement());
                if (document == null) break block6;
            }
            catch (SAXException sAXException) {
                try {
                    IOException iOException = new IOException(sAXException.getLocalizedMessage());
                    ErrorManager errorManager = ErrorManager.getDefault();
                    errorManager.annotate((Throwable)iOException, (Throwable)sAXException);
                    if (sAXException.getException() != null) {
                        errorManager.annotate((Throwable)iOException, (Throwable)sAXException.getException());
                    }
                    throw iOException;
                }
                catch (Throwable throwable) {
                    if (document != null) {
                        DOMConvertor.clearCashesForDocument(document);
                    }
                    throw throwable;
                }
            }
            DOMConvertor.clearCashesForDocument(document);
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void write(Writer writer, Object object) throws IOException {
        Document document = null;
        try {
            document = XMLUtil.createDocument((String)this.rootElement, null, (String)this.publicID, (String)this.systemID);
            DOMConvertor.setDocumentContext(document, DOMConvertor.findContext(writer));
            this.writeElement(document, document.getDocumentElement(), object);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
            XMLUtil.write((Document)document, (OutputStream)byteArrayOutputStream, (String)"UTF-8");
            writer.write(byteArrayOutputStream.toString("UTF-8"));
            if (document == null) return;
        }
        catch (DOMException dOMException) {
            try {
                throw (IOException)ErrorManager.getDefault().annotate((Throwable)new IOException(dOMException.getLocalizedMessage()), (Throwable)dOMException);
            }
            catch (Throwable throwable) {
                if (document == null) throw throwable;
                DOMConvertor.clearCashesForDocument(document);
                throw throwable;
            }
        }
        DOMConvertor.clearCashesForDocument(document);
        return;
    }

    protected abstract Object readElement(Element var1) throws IOException, ClassNotFoundException;

    protected abstract void writeElement(Document var1, Element var2, Object var3) throws IOException, DOMException;

    protected static final Object delegateRead(Element element) throws IOException, ClassNotFoundException {
        Object object;
        Object object2;
        String string = element.getAttribute(ATTR_IDREF);
        if (string.length() != 0) {
            Object object3 = DOMConvertor.getCache(element.getOwnerDocument(), string.intern());
            if (object3 != null) {
                return object3;
            }
            throw new IOException("broken reference: " + element + ", idref=" + string);
        }
        String string2 = element.getAttribute(ATTR_PUBLIC_ID);
        Convertor convertor = ConvertorResolver.getDefault().getConvertor(string2);
        if (convertor == null) {
            throw new IOException("Convertor not found. publicId: " + string2);
        }
        if (element.getTagName().equals(ELM_DELEGATE)) {
            object2 = element.getChildNodes();
            String string3 = null;
            int n = object2.getLength();
            for (int i = 0; i < n; ++i) {
                String string4;
                Node node = object2.item(i);
                if (node.getNodeType() == 4) {
                    string3 = node.getNodeValue();
                    break;
                }
                if (node.getNodeType() != 3 || (string4 = node.getNodeValue().trim()).length() <= 0) continue;
                string3 = string4;
                break;
            }
            if (string3 == null) {
                throw new IOException("Expected CDATA block under: " + element.getTagName());
            }
            object = DOMConvertor.readFromString(convertor, string3, DOMConvertor.findContext(element.getOwnerDocument()));
        } else if (convertor instanceof DOMConvertor) {
            object2 = (DOMConvertor)convertor;
            object = ((DOMConvertor)object2).readElement(element);
        } else {
            throw new IOException("Missing DOMConvertor for publicId: " + string2);
        }
        object2 = element.getAttribute(ATTR_ID);
        if (((String)object2).length() != 0) {
            DOMConvertor.setCache(element.getOwnerDocument(), object2, object);
        }
        return object;
    }

    protected static final Element delegateWrite(Document document, Object object) throws IOException, DOMException {
        Element element;
        Class<?> clazz;
        CacheRec cacheRec = DOMConvertor.setCache(document, object);
        if (cacheRec.used) {
            return DOMConvertor.writeReference(document, cacheRec);
        }
        ConvertorResolver convertorResolver = ConvertorResolver.getDefault();
        Convertor convertor = convertorResolver.getConvertor(clazz = object.getClass());
        if (convertor == null) {
            throw new IOException("Convertor not found for object: " + object);
        }
        if (convertor instanceof DOMConvertor) {
            DOMConvertor dOMConvertor = (DOMConvertor)convertor;
            element = document.createElement(dOMConvertor.rootElement);
            dOMConvertor.writeElement(document, element, object);
            if (element.getAttribute(ATTR_PUBLIC_ID).length() == 0) {
                element.setAttribute(ATTR_PUBLIC_ID, convertorResolver.getPublicID(clazz));
            }
        } else {
            element = document.createElement(ELM_DELEGATE);
            element.setAttribute(ATTR_PUBLIC_ID, convertorResolver.getPublicID(clazz));
            element.appendChild(document.createCDATASection(DOMConvertor.writeToString(convertor, object, DOMConvertor.findContext(document))));
        }
        cacheRec.elm = element;
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Lookup findContext(Document document) {
        Map map = ctxCache;
        synchronized (map) {
            Lookup lookup = (Lookup)ctxCache.get(document);
            return lookup == null ? Lookup.EMPTY : lookup;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setDocumentContext(Document document, Lookup lookup) {
        Map map = ctxCache;
        synchronized (map) {
            ctxCache.put(document, lookup);
        }
    }

    private static String writeToString(Convertor convertor, Object object, Lookup lookup) throws IOException {
        CharArrayWriter charArrayWriter = new CharArrayWriter(1024);
        Writer writer = charArrayWriter;
        FileObject fileObject = (FileObject)lookup.lookup(FileObject.class);
        if (fileObject != null) {
            writer = ContextProvider.createWriterContextProvider(charArrayWriter, fileObject);
        }
        convertor.write(writer, object);
        writer.close();
        return ((Object)charArrayWriter).toString();
    }

    private static Object readFromString(Convertor convertor, String string, Lookup lookup) throws IOException, ClassNotFoundException {
        Reader reader = new StringReader(string);
        FileObject fileObject = (FileObject)lookup.lookup(FileObject.class);
        if (fileObject != null) {
            reader = ContextProvider.createReaderContextProvider(reader, fileObject);
        }
        return convertor.read(reader);
    }

    private static Element writeReference(Document document, CacheRec cacheRec) throws DOMException {
        Element element = document.createElement(cacheRec.elm.getTagName());
        element.setAttribute(ATTR_IDREF, (String)cacheRec.value);
        cacheRec.elm.setAttribute(ATTR_ID, (String)cacheRec.value);
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CacheRec setCache(Document document, Object object) {
        Map map = refsCache;
        synchronized (map) {
            CacheRec cacheRec;
            HashMap<Object, CacheRec> hashMap = (HashMap<Object, CacheRec>)refsCache.get(document);
            if (hashMap == null) {
                hashMap = new HashMap<Object, CacheRec>();
                refsCache.put(document, hashMap);
            }
            if ((cacheRec = (CacheRec)hashMap.get(object)) == null) {
                cacheRec = new CacheRec();
                cacheRec.key = object;
                cacheRec.value = "ID_" + String.valueOf(hashMap.size());
                hashMap.put(object, cacheRec);
            }
            cacheRec.used = cacheRec.elm != null;
            return cacheRec;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CacheRec setCache(Document document, Object object, Object object2) {
        Map map = refsCache;
        synchronized (map) {
            CacheRec cacheRec;
            HashMap<Object, CacheRec> hashMap = (HashMap<Object, CacheRec>)refsCache.get(document);
            if (hashMap == null) {
                hashMap = new HashMap<Object, CacheRec>();
                refsCache.put(document, hashMap);
            }
            if ((cacheRec = (CacheRec)hashMap.get(object)) == null) {
                cacheRec = new CacheRec();
                cacheRec.key = object;
                cacheRec.value = object2;
                hashMap.put(object, cacheRec);
            }
            return cacheRec;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getCache(Document document, Object object) {
        Map map = refsCache;
        synchronized (map) {
            Map map2 = (Map)refsCache.get(document);
            if (map2 == null) {
                return null;
            }
            CacheRec cacheRec = (CacheRec)map2.get(object);
            return cacheRec.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearCashesForDocument(Document document) {
        Map map = refsCache;
        synchronized (map) {
            refsCache.remove(document);
        }
        map = ctxCache;
        synchronized (map) {
            ctxCache.remove(document);
        }
    }

    private static class CacheRec {
        Object key;
        Element elm;
        Object value;
        boolean used;

        CacheRec() {
        }
    }
}

