/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.settings.convertors;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import org.netbeans.modules.settings.Env;
import org.netbeans.modules.settings.convertors.XMLSettingsSupport;
import org.netbeans.spi.settings.Convertor;
import org.netbeans.spi.settings.Saver;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public final class XMLPropertiesConvertor
extends Convertor
implements PropertyChangeListener {
    public static final String EA_PREVENT_STORING = "xmlproperties.preventStoring";
    public static final String EA_IGNORE_CHANGES = "xmlproperties.ignoreChanges";
    private FileObject providerFO;
    private Set ignoreProperites;
    private Saver saver;
    private static final String INDENT = "    ";
    private String instanceClass = null;

    public static Convertor create(FileObject fileObject) {
        return new XMLPropertiesConvertor(fileObject);
    }

    public XMLPropertiesConvertor(FileObject fileObject) {
        this.providerFO = fileObject;
    }

    public Object read(java.io.Reader reader) throws IOException, ClassNotFoundException {
        Object object = this.defaultInstanceCreate();
        this.readSetting(reader, object);
        return object;
    }

    public void write(Writer writer, Object object) throws IOException {
        Object object2;
        writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>" + XMLSettingsSupport.LINE_SEPARATOR);
        writer.write("<!DOCTYPE properties PUBLIC \"");
        FileObject fileObject = Env.findEntityRegistration(this.providerFO);
        if (fileObject == null) {
            fileObject = this.providerFO;
        }
        if ((object2 = fileObject.getAttribute("hint.originalPublicID")) == null || !(object2 instanceof String)) {
            throw new IOException("missing or invalid attribute: hint.originalPublicID, provider: " + fileObject);
        }
        writer.write((String)object2);
        writer.write("\" \"http://www.netbeans.org/dtds/properties-1_0.dtd\">" + XMLSettingsSupport.LINE_SEPARATOR);
        writer.write("<properties>" + XMLSettingsSupport.LINE_SEPARATOR);
        Properties properties = XMLPropertiesConvertor.getProperties(object);
        if (properties != null && !properties.isEmpty()) {
            XMLPropertiesConvertor.writeProperties(writer, properties);
        }
        writer.write("</properties>" + XMLSettingsSupport.LINE_SEPARATOR);
    }

    public void registerSaver(Object object, Saver saver) {
        if (this.saver != null) {
            ErrorManager.getDefault().log(4096, "[Warning] Saver already registered");
            return;
        }
        try {
            Method method = object.getClass().getMethod("addPropertyChangeListener", PropertyChangeListener.class);
            method.invoke(object, this);
            this.saver = saver;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            ErrorManager.getDefault().log(1, "ObjectChangesNotifier: NoSuchMethodException: " + object.getClass().getName() + ".addPropertyChangeListener");
        }
        catch (IllegalAccessException illegalAccessException) {
            ErrorManager.getDefault().notify((Throwable)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            ErrorManager.getDefault().notify((Throwable)invocationTargetException);
        }
    }

    public void unregisterSaver(Object object, Saver saver) {
        if (this.saver == null) {
            return;
        }
        if (this.saver != saver) {
            ErrorManager.getDefault().log(4096, "[Warning] trying unregistered unknown Saver");
            return;
        }
        try {
            Method method = object.getClass().getMethod("removePropertyChangeListener", PropertyChangeListener.class);
            method.invoke(object, this);
            this.saver = null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            ErrorManager.getDefault().log(1, "ObjectChangesNotifier: NoSuchMethodException: " + object.getClass().getName() + ".removePropertyChangeListener");
        }
        catch (IllegalAccessException illegalAccessException) {
            ErrorManager.getDefault().notify((Throwable)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            ErrorManager.getDefault().notify((Throwable)invocationTargetException);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.saver == null || this.ignoreChange(propertyChangeEvent)) {
            return;
        }
        if (this.acceptSave()) {
            try {
                this.saver.requestSave();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(4096, (Throwable)iOException);
            }
        } else {
            this.saver.markDirty();
        }
    }

    private boolean ignoreChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent == null || propertyChangeEvent.getPropertyName() == null) {
            return true;
        }
        if (this.ignoreProperites == null) {
            this.ignoreProperites = Env.parseAttribute(this.providerFO.getAttribute(EA_IGNORE_CHANGES));
        }
        if (this.ignoreProperites.contains(propertyChangeEvent.getPropertyName())) {
            return true;
        }
        return this.ignoreProperites.contains("all");
    }

    private boolean acceptSave() {
        Object object = this.providerFO.getAttribute(EA_PREVENT_STORING);
        if (object == null) {
            return true;
        }
        if (object instanceof Boolean) {
            return (Boolean)object == false;
        }
        if (object instanceof String) {
            return Boolean.valueOf((String)object) == false;
        }
        return true;
    }

    private Object defaultInstanceCreate() throws IOException, ClassNotFoundException {
        Object object = this.providerFO.getAttribute("settings.instanceCreate");
        if (object != null) {
            return object;
        }
        Class clazz = this.getInstanceClass();
        try {
            return clazz.newInstance();
        }
        catch (Exception exception) {
            throw (IOException)ErrorManager.getDefault().annotate((Throwable)new IOException("Cannot create instance of " + clazz.getName()), (Throwable)exception);
        }
    }

    private Class getInstanceClass() throws IOException, ClassNotFoundException {
        if (this.instanceClass == null) {
            Object object = this.providerFO.getAttribute("settings.instanceClass");
            if (object == null || !(object instanceof String)) {
                throw new IllegalStateException("missing or invalid ea attribute: settings.instanceClass");
            }
            this.instanceClass = (String)object;
        }
        return ((ClassLoader)Lookup.getDefault().lookup(ClassLoader.class)).loadClass(this.instanceClass);
    }

    private void readSetting(java.io.Reader reader, Object object) throws IOException {
        try {
            Method method = object.getClass().getDeclaredMethod("readProperties", Properties.class);
            method.setAccessible(true);
            Reader reader2 = new Reader();
            reader2.parse(reader);
            method.setAccessible(true);
            method.invoke(object, reader2.getProperties());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw (IOException)ErrorManager.getDefault().annotate((Throwable)new IOException(noSuchMethodException.getLocalizedMessage()), (Throwable)noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw (IOException)ErrorManager.getDefault().annotate((Throwable)new IOException(illegalAccessException.getLocalizedMessage()), (Throwable)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            throw (IOException)ErrorManager.getDefault().annotate((Throwable)new IOException(throwable.getLocalizedMessage()), throwable);
        }
    }

    private static void writeProperties(Writer writer, Properties properties) throws IOException {
        Iterator<Object> iterator = properties.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            writer.write(INDENT);
            writer.write("<property name=\"");
            writer.write(string);
            writer.write("\" value=\"");
            writer.write(properties.getProperty(string));
            writer.write("\"/>" + XMLSettingsSupport.LINE_SEPARATOR);
        }
    }

    private static Properties getProperties(Object object) throws IOException {
        try {
            Method method = object.getClass().getDeclaredMethod("writeProperties", Properties.class);
            method.setAccessible(true);
            Properties properties = new Properties();
            method.invoke(object, properties);
            return properties;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw (IOException)ErrorManager.getDefault().annotate((Throwable)new IOException(noSuchMethodException.getLocalizedMessage()), (Throwable)noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw (IOException)ErrorManager.getDefault().annotate((Throwable)new IOException(illegalAccessException.getLocalizedMessage()), (Throwable)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            throw (IOException)ErrorManager.getDefault().annotate((Throwable)new IOException(throwable.getLocalizedMessage()), throwable);
        }
    }

    private static class Reader
    extends DefaultHandler
    implements LexicalHandler {
        private static final String ELM_PROPERTY = "property";
        private static final String ATR_PROPERTY_NAME = "name";
        private static final String ATR_PROPERTY_VALUE = "value";
        private Properties props = new Properties();
        private String publicId;

        Reader() {
        }

        public InputSource resolveEntity(String string, String string2) throws SAXException {
            if (this.publicId != null && this.publicId.equals(string)) {
                return new InputSource(new ByteArrayInputStream(new byte[0]));
            }
            return null;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (ELM_PROPERTY.equals(string3)) {
                String string4 = attributes.getValue(ATR_PROPERTY_NAME);
                String string5 = attributes.getValue(ATR_PROPERTY_VALUE);
                this.props.setProperty(string4, string5);
            }
        }

        public void parse(java.io.Reader reader) throws IOException {
            try {
                XMLReader xMLReader = XMLUtil.createXMLReader((boolean)false, (boolean)false);
                xMLReader.setContentHandler(this);
                xMLReader.setEntityResolver(this);
                InputSource inputSource = new InputSource(reader);
                try {
                    xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", this);
                }
                catch (SAXException sAXException) {
                    ErrorManager.getDefault().log(4096, "Warning: XML parser does not support lexical-handler feature.");
                }
                xMLReader.parse(inputSource);
            }
            catch (SAXException sAXException) {
                IOException iOException = new IOException();
                ErrorManager errorManager = ErrorManager.getDefault();
                errorManager.annotate((Throwable)iOException, (Throwable)sAXException);
                if (sAXException.getException() != null) {
                    errorManager.annotate((Throwable)iOException, (Throwable)sAXException.getException());
                }
                throw iOException;
            }
        }

        public Properties getProperties() {
            return this.props;
        }

        public String getPublicID() {
            return this.publicId;
        }

        public void startDTD(String string, String string2, String string3) throws SAXException {
            this.publicId = string2;
        }

        public void endDTD() throws SAXException {
        }

        public void startEntity(String string) throws SAXException {
        }

        public void endEntity(String string) throws SAXException {
        }

        public void comment(char[] cArray, int n, int n2) throws SAXException {
        }

        public void startCDATA() throws SAXException {
        }

        public void endCDATA() throws SAXException {
        }
    }
}

