/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.settings;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import org.netbeans.modules.settings.ContextProvider;
import org.netbeans.modules.settings.Env;
import org.netbeans.modules.settings.InstanceProvider;
import org.netbeans.spi.settings.Convertor;
import org.netbeans.spi.settings.Saver;
import org.openide.ErrorManager;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;

final class SaveSupport {
    public static final String PROP_SAVE = "savecookie";
    public static final String PROP_FILE_CHANGED = "fileChanged";
    static final String EA_NAME = "name";
    private PropertyChangeSupport changeSupport;
    private Convertor convertor;
    private final SaveCookieImpl instToSave = new SaveCookieImpl();
    private boolean isChanged = false;
    private final FileObject file;
    private final SoftReference instance;
    private final InstanceProvider ip;
    private Boolean knownToBeTemplate = null;

    public SaveSupport(InstanceProvider instanceProvider, Object object) {
        this.ip = instanceProvider;
        this.instance = new SoftReference<Object>(object);
        this.file = instanceProvider.getFile();
    }

    private Convertor getConvertor() {
        return this.convertor;
    }

    private Convertor initConvertor() {
        Object t = this.instance.get();
        if (t == null) {
            throw new IllegalStateException("setting object cannot be null: " + this.ip);
        }
        try {
            FileObject fileObject = Env.findProvider(t.getClass());
            if (fileObject != null) {
                if (this.getPublicID(fileObject).equals(this.getPublicID(this.ip.getProvider()))) {
                    this.convertor = this.ip.getConvertor();
                    return this.convertor;
                }
                Object object = fileObject.getAttribute("settings.convertor");
                if (object == null || !(object instanceof Convertor)) {
                    throw new IOException("cannot create convertor: " + object + ", provider: " + fileObject);
                }
                this.convertor = (Convertor)object;
                return this.convertor;
            }
            this.convertor = this.ip.getConvertor();
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
        return this.convertor;
    }

    private String getPublicID(FileObject fileObject) throws IOException {
        Object object;
        FileObject fileObject2 = Env.findEntityRegistration(fileObject);
        if (fileObject2 == null) {
            fileObject2 = fileObject;
        }
        if ((object = fileObject2.getAttribute("hint.originalPublicID")) == null || !(object instanceof String)) {
            throw new IOException("missing or invalid attribute: hint.originalPublicID, provider: " + fileObject2);
        }
        return (String)object;
    }

    public final SaveCookie getSaveCookie() {
        return this.instToSave;
    }

    public final boolean isChanged() {
        return this.isChanged;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
            Object t = this.instance.get();
            if (t == null) {
                return;
            }
            Convertor convertor = this.initConvertor();
            if (convertor != null) {
                convertor.registerSaver(t, this.instToSave);
            }
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(propertyChangeListener);
            Object t = this.instance.get();
            if (t == null) {
                return;
            }
            Convertor convertor = this.getConvertor();
            if (convertor != null) {
                convertor.unregisterSaver(t, this.instToSave);
            }
        }
    }

    private void firePropertyChange(String string) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(string, null, null);
        }
    }

    public void writeDown() throws IOException {
        this.instToSave.writeDown();
    }

    private class SaveCookieImpl
    implements FileSystem.AtomicAction,
    SaveCookie,
    Saver {
        private ByteArrayOutputStream buf;

        private SaveCookieImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() throws IOException {
            if (!SaveSupport.this.ip.getDataObject().isValid()) {
                ErrorManager errorManager = ErrorManager.getDefault();
                if (errorManager.isLoggable(1)) {
                    errorManager.log("invalid data object cannot be used for storing " + SaveSupport.this.ip.getDataObject());
                }
                return;
            }
            FileLock fileLock = null;
            Object object = ((SaveSupport)SaveSupport.this).ip.READWRITE_LOCK;
            synchronized (object) {
                fileLock = SaveSupport.this.ip.getScheduledRequest().getFileLock();
                if (fileLock == null) {
                    return;
                }
                OutputStream outputStream = SaveSupport.this.file.getOutputStream(fileLock);
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream, 1024);
                try {
                    this.buf.writeTo(bufferedOutputStream);
                }
                finally {
                    ((OutputStream)bufferedOutputStream).close();
                }
            }
        }

        public void save() throws IOException {
            if (!SaveSupport.this.isChanged) {
                return;
            }
            SaveSupport.this.ip.getScheduledRequest().runAndWait();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeDown() throws IOException {
            Object t = SaveSupport.this.instance.get();
            if (t == null) {
                return;
            }
            Convertor convertor = SaveSupport.this.getConvertor();
            if (convertor == null) {
                return;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
            Writer writer = ContextProvider.createWriterContextProvider(new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8"), SaveSupport.this.file);
            SaveSupport.this.isChanged = false;
            try {
                convertor.write(writer, t);
            }
            finally {
                writer.close();
            }
            this.buf = byteArrayOutputStream;
            SaveSupport.this.file.getFileSystem().runAtomicAction((FileSystem.AtomicAction)this);
            this.buf = null;
            this.synchronizeName(t);
            if (!SaveSupport.this.isChanged) {
                SaveSupport.this.firePropertyChange(SaveSupport.PROP_SAVE);
            }
        }

        public void markDirty() {
            if (SaveSupport.this.isChanged || !SaveSupport.this.ip.getDataObject().isValid()) {
                return;
            }
            if (SaveSupport.this.knownToBeTemplate == null) {
                SaveSupport.this.knownToBeTemplate = SaveSupport.this.ip.getDataObject().isTemplate() ? Boolean.TRUE : Boolean.FALSE;
            }
            if (SaveSupport.this.knownToBeTemplate.booleanValue()) {
                return;
            }
            SaveSupport.this.isChanged = true;
            SaveSupport.this.firePropertyChange(SaveSupport.PROP_SAVE);
        }

        public void requestSave() throws IOException {
            if (SaveSupport.this.isChanged || !SaveSupport.this.ip.getDataObject().isValid()) {
                return;
            }
            if (SaveSupport.this.knownToBeTemplate == null) {
                SaveSupport.this.knownToBeTemplate = SaveSupport.this.ip.getDataObject().isTemplate() ? Boolean.TRUE : Boolean.FALSE;
            }
            if (SaveSupport.this.knownToBeTemplate.booleanValue()) {
                return;
            }
            SaveSupport.this.isChanged = true;
            SaveSupport.this.firePropertyChange(SaveSupport.PROP_SAVE);
            SaveSupport.this.ip.getScheduledRequest().schedule(SaveSupport.this.instance.get());
        }

        private void synchronizeName(Object object) {
            Method method;
            try {
                try {
                    method = object.getClass().getMethod("getDisplayName", null);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    method = object.getClass().getMethod("getName", null);
                }
            }
            catch (Exception exception) {
                return;
            }
            if (!method.isAccessible()) {
                return;
            }
            try {
                String string = (String)method.invoke(object, null);
                String string2 = SaveSupport.this.ip.getDataObject().getName();
                if (!string.equals(string2)) {
                    SaveSupport.this.file.setAttribute(SaveSupport.EA_NAME, (Object)string);
                } else if (SaveSupport.this.file.getAttribute(SaveSupport.EA_NAME) == null) {
                    SaveSupport.this.file.setAttribute(SaveSupport.EA_NAME, (Object)string);
                }
            }
            catch (Exception exception) {
                ErrorManager errorManager = ErrorManager.getDefault();
                errorManager.annotate((Throwable)exception, SaveSupport.this.file.toString());
                errorManager.notify(1, (Throwable)exception);
            }
        }
    }
}

