/*
 * Decompiled with CFR 0.152.
 */
package tr.view;

import java.awt.Frame;
import java.util.Collection;
import javax.swing.Action;
import org.openide.util.Lookup;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import tr.global.InitialAction;
import tr.global.InitialActionLookup;
import tr.prefs.gui.GUIPrefs;
import tr.view.Window;

public class WindowUtils {
    private static final TopComponent[] TC_ARRAY = new TopComponent[0];

    private WindowUtils() {
    }

    public static final Frame getAppFrame() {
        return WindowManager.getDefault().getMainWindow();
    }

    public static final void closeWindows() {
        TopComponent.Registry reg = WindowManager.getDefault().getRegistry();
        TopComponent[] tcs = reg.getOpened().toArray(TC_ARRAY);
        for (int i = 0; i < 10; ++i) {
            for (TopComponent tc : tcs) {
                if (tc instanceof Window) {
                    ((Window)tc).forceClose();
                    continue;
                }
                tc.close();
            }
            tcs = reg.getOpened().toArray(TC_ARRAY);
            if (tcs.length == 0) break;
        }
    }

    public static final void openInitialWindow() {
        String id = GUIPrefs.getInitialActionID();
        if (!id.equals("none")) {
            Lookup.Result r = InitialActionLookup.instance().lookup(new Lookup.Template(InitialAction.class));
            Collection c = r.allInstances();
            for (InitialAction action : c) {
                if (!action.getID().equals(id)) continue;
                ((Action)action).actionPerformed(null);
                return;
            }
        }
    }

    public static final void openOverviewWindow() {
        String id = "overview";
        Lookup.Result r = InitialActionLookup.instance().lookup(new Lookup.Template(InitialAction.class));
        Collection c = r.allInstances();
        for (InitialAction action : c) {
            if (!action.getID().equals(id)) continue;
            ((Action)action).actionPerformed(null);
            return;
        }
    }
}

