/*
 * Decompiled with CFR 0.152.
 */
package tr.extract.clean;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdesktop.layout.GroupLayout;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import tr.extract.clean.ExtractCleanOptionsPanelController;
import tr.extract.clean.ExtractCleanPrefs;

final class ExtractCleanPanel
extends JPanel {
    private final ExtractCleanOptionsPanelController controller;
    private JComboBox ageCombo;
    private JComboBox intervalCombo;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private final Item[] intervals = new Item[]{new Item(this.getI18nText("Run_Every_Startup"), 0), new Item(this.getI18nText("Run_Every_Day"), 1), new Item(this.getI18nText("Run_Every_Week"), 7), new Item(this.getI18nText("Run_Every_2_Weeks"), 14), new Item(this.getI18nText("Run_Every_3_Weeks"), 21), new Item(this.getI18nText("Run_Every_4_Weeks"), 28), new Item(this.getI18nText("Run_Never"), Integer.MAX_VALUE)};
    private final Item[] ages = new Item[]{new Item(this.getI18nText("Age_1_Day"), 1), new Item(this.getI18nText("Age_1_Week"), 7), new Item(this.getI18nText("Age_2_Weeks"), 14), new Item(this.getI18nText("Age_3_Weeks"), 21), new Item(this.getI18nText("Age_4_Weeks"), 28)};

    ExtractCleanPanel(ExtractCleanOptionsPanelController controller) {
        this.controller = controller;
        this.initComponents();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.intervalCombo = new JComboBox();
        this.ageCombo = new JComboBox();
        this.setBackground(Color.white);
        this.setBorder(BorderFactory.createTitledBorder(""));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)this.getRunLabel());
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)this.getAgeLabel());
        this.intervalCombo.setBackground(new Color(255, 255, 255));
        this.intervalCombo.setModel(new DefaultComboBoxModel<Item>(this.intervals));
        this.intervalCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExtractCleanPanel.this.intervalChanged(evt);
            }
        });
        this.ageCombo.setBackground(new Color(255, 255, 255));
        this.ageCombo.setModel(new DefaultComboBoxModel<Item>(this.ages));
        this.ageCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExtractCleanPanel.this.ageChanged(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel1, -1, 158, Short.MAX_VALUE).add((Component)this.jLabel2, -1, 158, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.intervalCombo, 0, 101, Short.MAX_VALUE).add((Component)this.ageCombo, 0, 101, Short.MAX_VALUE))));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.intervalCombo, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2, -2, 18, -2).add((Component)this.ageCombo, -2, -1, -2))));
    }

    private String getI18nText(String key) {
        return NbBundle.getMessage(this.getClass(), (String)key);
    }

    private String getRunLabel() {
        return this.getI18nText("Run_Label");
    }

    private String getAgeLabel() {
        return this.getI18nText("Age_Label");
    }

    private void ageChanged(ActionEvent evt) {
        this.controller.changed();
    }

    private void intervalChanged(ActionEvent evt) {
        this.controller.changed();
    }

    void load() {
        this.intervalCombo.setSelectedItem(this.getInterval(ExtractCleanPrefs.getCleanIntervalDays()));
        this.ageCombo.setSelectedItem(this.getAge(ExtractCleanPrefs.getCleanAgeDays()));
    }

    private Item getInterval(int value) {
        for (int i = 0; i < this.intervals.length; ++i) {
            if (this.intervals[i].value != value) continue;
            return this.intervals[i];
        }
        return this.intervals[0];
    }

    private Item getAge(int value) {
        for (int i = 0; i < this.ages.length; ++i) {
            if (this.ages[i].value != value) continue;
            return this.ages[i];
        }
        return this.ages[0];
    }

    void store() {
        int value;
        Item intervalItem;
        int value2;
        Item ageItem = (Item)this.ageCombo.getSelectedItem();
        if (ageItem != null && ageItem.value != (value2 = ExtractCleanPrefs.getCleanAgeDays())) {
            ExtractCleanPrefs.setCleanAgeDays(ageItem.value);
        }
        if ((intervalItem = (Item)this.intervalCombo.getSelectedItem()) != null && intervalItem.value != (value = ExtractCleanPrefs.getCleanIntervalDays())) {
            ExtractCleanPrefs.setCleanIntervalDays(intervalItem.value);
        }
    }

    boolean valid() {
        return true;
    }

    private static final class Item {
        public String label;
        public int value;

        public Item(String label, int value) {
            this.label = label;
            this.value = value;
        }

        public String toString() {
            return this.label;
        }
    }
}

