/*
 * Decompiled with CFR 0.152.
 */
package tr.view.overview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.Serializable;
import javax.swing.SwingUtilities;
import org.apache.batik.swing.JSVGCanvas;
import org.openide.ErrorManager;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import tr.util.Observable;
import tr.util.Observer;
import tr.view.Window;
import tr.view.overview.Overview;
import tr.view.overview.Resources;

public final class OverviewTopComponent
extends Window {
    private static final long serialVersionUID = 1L;
    public static final String PREFERRED_ID = "OverviewTopComponent";
    private static OverviewTopComponent instance;
    private final Overview overview;
    private final JSVGCanvas canvas;
    private Observer observer;

    private OverviewTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(OverviewTopComponent.class, (String)"CTL_OverviewTopComponent"));
        this.setToolTipText(NbBundle.getMessage(OverviewTopComponent.class, (String)"HINT_OverviewTopComponent"));
        this.setIcon(Resources.ICON_OVERVIEW.getImage());
        this.overview = new Overview();
        this.canvas = this.overview.getSVGCanvas();
        this.add((Component)this.canvas, "Center");
        this.canvas.setURI(Resources.URL_OVERVIEW.toString());
        this.canvas.setSize(1, 1);
    }

    public void addNotify() {
        super.addNotify();
        this.addListeners();
    }

    public void removeNotify() {
        super.removeNotify();
        this.removeListeners();
    }

    private void addListeners() {
        this.observer = new Observer(){

            public void update(Observable observable, final Object screen) {
                if (screen instanceof Overview.Screen) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            OverviewTopComponent.this.switchScreen((Overview.Screen)((Object)screen));
                        }
                    });
                }
            }
        };
        this.overview.addObserver(this.observer);
    }

    private void removeListeners() {
        this.overview.removeObserver(this.observer);
    }

    private void switchScreen(Overview.Screen screen) {
        screen.action.actionPerformed(null);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public static synchronized OverviewTopComponent getDefault() {
        if (instance == null) {
            instance = new OverviewTopComponent();
        }
        return instance;
    }

    public static synchronized OverviewTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            ErrorManager.getDefault().log(16, "Cannot find Overview component. It will not be located properly in the window system.");
            return OverviewTopComponent.getDefault();
        }
        if (win instanceof OverviewTopComponent) {
            return (OverviewTopComponent)win;
        }
        ErrorManager.getDefault().log(16, "There seem to be multiple components with the 'OverviewTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return OverviewTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 2;
    }

    public void componentActivated() {
        this.refresh();
    }

    public void componentOpened() {
        this.refresh();
    }

    public void refresh() {
        this.canvas.setSize(1, 1);
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    public String preferredID() {
        return PREFERRED_ID;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("tr.view.overview");
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return OverviewTopComponent.getDefault();
        }
    }
}

