/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javahelp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.help.HelpSet;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.javahelp.Help;
import org.netbeans.modules.javahelp.HelpConstants;
import org.netbeans.modules.javahelp.Installer;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public abstract class AbstractHelp
extends Help
implements HelpConstants {
    private Lookup.Result helpsets = null;
    private final Set listeners = new HashSet(1);

    protected AbstractHelp() {
    }

    protected final Collection getHelpSets() {
        if (this.helpsets == null) {
            Installer.err.log("searching for instances of HelpSet...");
            this.helpsets = Lookup.getDefault().lookup(new Lookup.Template(HelpSet.class));
            this.helpsets.addLookupListener(new LookupListener(){

                public void resultChanged(LookupEvent lookupEvent) {
                    AbstractHelp.this.helpSetsChanged();
                }
            });
            this.fireChangeEvent();
        }
        Collection collection = this.helpsets.allInstances();
        if (Installer.err.isLoggable(1)) {
            ArrayList<String> arrayList = new ArrayList<String>(Math.min(1, collection.size()));
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                arrayList.add(((HelpSet)iterator.next()).getTitle());
            }
            Installer.err.log("listing helpsets: " + arrayList);
        }
        return collection;
    }

    protected final boolean helpSetsReady() {
        return this.helpsets != null;
    }

    protected final boolean shouldMerge(HelpSet helpSet) {
        Boolean bl = (Boolean)helpSet.getKeyData("OpenIDE", "mergeIntoMaster");
        return bl == null || bl != false;
    }

    protected void helpSetsChanged() {
        Installer.err.log("helpSetsChanged");
        this.fireChangeEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener changeListener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener changeListener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void fireChangeEvent() {
        Iterator iterator;
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    AbstractHelp.this.fireChangeEvent();
                }
            });
            return;
        }
        Object object = this.listeners;
        synchronized (object) {
            iterator = new HashSet(this.listeners).iterator();
        }
        object = new ChangeEvent(this);
        Installer.err.log("Help.stateChanged");
        while (iterator.hasNext()) {
            ((ChangeListener)iterator.next()).stateChanged((ChangeEvent)object);
        }
    }
}

