/*
 * Decompiled with CFR 0.152.
 */
package tr.view.collect.screen;

import java.awt.BorderLayout;
import java.awt.EventQueue;
import java.awt.Insets;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Vector;
import javax.swing.JToolBar;
import org.openide.ErrorManager;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import tr.prefs.gui.GUIPrefs;
import tr.view.Window;
import tr.view.collect.AddThoughtsAction;
import tr.view.collect.DeleteThoughtAction;
import tr.view.collect.EditThoughtAction;
import tr.view.collect.Resources;
import tr.view.collect.screen.CollectThoughtsPanel;
import tr.view.collect.screen.ThoughtNode;
import tr.view.collect.screen.ThoughtNodeProvider;

public final class CollectThoughtsTopComponent
extends Window
implements ThoughtNodeProvider {
    public static final String PREFERRED_ID = "CollectThoughtsTopComponent";
    private static final long serialVersionUID = 1L;
    private static CollectThoughtsTopComponent instance;
    private transient CollectThoughtsPanel panel;
    private transient InstanceContent content;
    private transient Lookup lookup;

    private CollectThoughtsTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(CollectThoughtsTopComponent.class, (String)"CTL_CollectTopComponent"));
        this.setToolTipText(NbBundle.getMessage(CollectThoughtsTopComponent.class, (String)"HINT_CollectTopComponent"));
        this.setIcon(Resources.ICON_COLLECT.getImage());
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public static synchronized CollectThoughtsTopComponent getDefault() {
        if (instance == null) {
            instance = new CollectThoughtsTopComponent();
        }
        return instance;
    }

    public static synchronized CollectThoughtsTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            ErrorManager.getDefault().log(16, "Cannot find collect thoughts component. It will not be located properly in the window system.");
            return CollectThoughtsTopComponent.getDefault();
        }
        if (win instanceof CollectThoughtsTopComponent) {
            return (CollectThoughtsTopComponent)win;
        }
        ErrorManager.getDefault().log(16, "There seem to be multiple components with the 'CollectThoughtsTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return CollectThoughtsTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    private JToolBar getToolBar() {
        SystemAction[] actions = new SystemAction[]{SystemAction.get(AddThoughtsAction.class), null, SystemAction.get(EditThoughtAction.class), null, SystemAction.get(DeleteThoughtAction.class)};
        JToolBar toolbar = SystemAction.createToolbarPresenter((SystemAction[])actions);
        Insets insets = toolbar.getMargin();
        insets.set(insets.top, 20, insets.bottom, insets.right);
        toolbar.setMargin(insets);
        toolbar.setFloatable(false);
        return toolbar;
    }

    protected void componentOpened() {
        this.provide(null);
        this.removeAll();
        if (GUIPrefs.getButtonsPosition().equals("top")) {
            this.add(this.getToolBar(), "North");
        } else {
            this.add(this.getToolBar(), "South");
        }
        this.panel = new CollectThoughtsPanel(this);
        this.add(this.panel, "Center");
    }

    private synchronized InstanceContent getInstanceContent() {
        if (this.content == null) {
            this.content = new InstanceContent();
        }
        return this.content;
    }

    public Lookup getLookup() {
        if (this.lookup == null) {
            this.lookup = new AbstractLookup((AbstractLookup.Content)this.getInstanceContent());
        }
        return this.lookup;
    }

    public void provide(final ThoughtNode thoughtNode) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                if (CollectThoughtsTopComponent.this.panel == null || thoughtNode == null) {
                    CollectThoughtsTopComponent.this.getInstanceContent().set((Collection)Collections.EMPTY_LIST, null);
                } else {
                    Vector<ThoughtNode> collection = new Vector<ThoughtNode>();
                    collection.add(thoughtNode);
                    CollectThoughtsTopComponent.this.getInstanceContent().set(collection, null);
                }
            }
        });
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("tr.view.collect");
    }

    public String preferredID() {
        return PREFERRED_ID;
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return CollectThoughtsTopComponent.getDefault();
        }
    }
}

