/*
 * Decompiled with CFR 0.152.
 */
package tr.view.collect.dialog;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jdesktop.layout.GroupLayout;
import org.openide.util.NbBundle;
import tr.model.thought.Thought;
import tr.model.topic.Topic;
import tr.runtime.Open;
import tr.swing.editorpane.HyperEditorPane;
import tr.view.topic.TopicComboBox;
import tr.view.topic.TopicComboBoxModel;
import tr.view.topic.TopicListCellRenderer;

public class ThoughtDialogPanel
extends JPanel {
    private static final JTextField JTEXTFIELD = new JTextField();
    private HyperEditorPane notesEditorPane;
    private JLabel notesLabel;
    private JLabel thoughtLabel;
    private JTextField thoughtTextField;
    private JComboBox topicCombo;
    private JLabel topicLabel;
    private TopicComboBoxModel topicsModel;
    private Thought thought;

    public ThoughtDialogPanel() {
        this.initComponents();
        this.notesEditorPane.getEditButton().setFocusable(false);
        this.notesEditorPane.getURLButton().setFocusable(false);
        this.notesEditorPane.getFileButton().setFocusable(false);
    }

    private void initComponents() {
        this.thoughtLabel = new JLabel();
        this.thoughtTextField = new JTextField();
        this.topicLabel = new JLabel();
        this.topicsModel = new TopicComboBoxModel(false);
        this.topicCombo = new TopicComboBox((ComboBoxModel)this.topicsModel);
        this.notesEditorPane = new HyperEditorPane();
        this.notesLabel = new JLabel();
        this.thoughtLabel.setBackground(UIManager.getDefaults().getColor("Nb.ScrollPane.Border.color"));
        this.thoughtLabel.setHorizontalAlignment(11);
        this.thoughtLabel.setText(NbBundle.getMessage(ThoughtDialogPanel.class, (String)"thought"));
        this.topicLabel.setBackground(UIManager.getDefaults().getColor("Nb.ScrollPane.Border.color"));
        this.topicLabel.setHorizontalAlignment(11);
        this.topicLabel.setText(NbBundle.getMessage(ThoughtDialogPanel.class, (String)"topic"));
        this.topicCombo.setRenderer(new TopicListCellRenderer());
        this.topicCombo.setMaximumRowCount(30);
        this.topicCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ThoughtDialogPanel.this.topicActionPerformed(evt);
            }
        });
        this.notesEditorPane.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent evt) {
                ThoughtDialogPanel.this.hyperlink(evt);
            }
        });
        this.notesLabel.setBackground(UIManager.getDefaults().getColor("Nb.ScrollPane.Border.color"));
        this.notesLabel.setHorizontalAlignment(11);
        this.notesLabel.setText(NbBundle.getMessage(ThoughtDialogPanel.class, (String)"notes"));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2, false).add((Component)this.notesLabel, -1, 60, Short.MAX_VALUE).add(1, (Component)this.thoughtLabel, -1, 60, Short.MAX_VALUE).add(1, (Component)this.topicLabel, -1, 60, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.notesEditorPane, -1, 200, Short.MAX_VALUE).add((Component)this.thoughtTextField, -1, 200, Short.MAX_VALUE).add((Component)this.topicCombo, -2, 200, -2)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.thoughtTextField, -2, 22, -2).add((Component)this.thoughtLabel)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.topicLabel).add((Component)this.topicCombo, -2, 22, -2)).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addPreferredGap(0).add((Component)this.notesEditorPane, -1, 49, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add(41, 41, 41).add((Component)this.notesLabel))).addContainerGap()));
    }

    private void topicActionPerformed(ActionEvent evt) {
        Topic topic = (Topic)this.topicCombo.getSelectedItem();
        if (topic == null) {
            this.thoughtTextField.setBackground(JTEXTFIELD.getBackground());
            this.thoughtTextField.setForeground(JTEXTFIELD.getForeground());
        } else {
            this.thoughtTextField.setBackground(topic.getBackground());
            this.thoughtTextField.setForeground(topic.getForeground());
        }
    }

    private void hyperlink(HyperlinkEvent evt) {
        URL url = evt.getURL();
        if (url == null) {
            return;
        }
        if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            Open.open((URL)url);
        }
    }

    public void setDescription(String description) {
        this.thoughtTextField.setText(description);
    }

    public void setTopic(Topic topic) {
        this.topicCombo.setSelectedItem(topic);
    }

    public void setNotes(String notes) {
        this.notesEditorPane.setText(notes);
        this.notesEditorPane.setEditable(true);
    }

    public String getDescription() {
        return this.thoughtTextField.getText();
    }

    public Topic getTopic() {
        return (Topic)this.topicCombo.getSelectedItem();
    }

    public String getNotes() {
        return this.notesEditorPane.getText();
    }

    public void focus() {
        this.requestFocusInWindow();
        this.thoughtTextField.requestFocusInWindow();
    }
}

