/*
 * Decompiled with CFR 0.152.
 */
package tr.swing.editorpane;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkListener;
import org.openide.util.NbBundle;
import tr.swing.editorpane.JEditorPaneExt;
import tr.swing.editorpane.URLDialog;

public class HyperEditorPane
extends JPanel {
    private static final Logger LOG = Logger.getLogger("tr.swing.editorpane");
    private JEditorPaneExt hyperPane;
    private JToggleButton editButton;
    private JButton fileButton;
    private JButton urlButton;
    private JScrollPane scrollPane;
    private JToolBar toolBar;

    public HyperEditorPane() {
        this.initComponents();
    }

    private void initComponents() {
        this.toolBar = new JToolBar();
        this.editButton = new JToggleButton();
        this.editButton.setToolTipText(NbBundle.getMessage(this.getClass(), (String)"EditButtonToolTip"));
        this.urlButton = new JButton();
        this.urlButton.setToolTipText(NbBundle.getMessage(this.getClass(), (String)"URLButtonToolTip"));
        this.fileButton = new JButton();
        this.fileButton.setToolTipText(NbBundle.getMessage(this.getClass(), (String)"FileButtonToolTip"));
        this.scrollPane = new JScrollPane();
        this.hyperPane = new JEditorPaneExt();
        this.hyperPane.setEditable(true);
        this.hyperPane.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                HyperEditorPane.this.hyperPaneMouseClicked(evt);
            }
        });
        this.hyperPane.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    HyperEditorPane.this.editButton.setSelected(false);
                    HyperEditorPane.this.editToggleButtonActionPerformed(null);
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(50, 45));
        this.toolBar.setFloatable(false);
        this.toolBar.setMaximumSize(new Dimension(0, 0));
        this.toolBar.setMinimumSize(new Dimension(0, 26));
        this.editButton.setIcon(new ImageIcon(this.getClass().getResource("/tr/swing/editorpane/IconEdit16.gif")));
        this.editButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HyperEditorPane.this.editToggleButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.editButton);
        this.urlButton.setIcon(new ImageIcon(this.getClass().getResource("/tr/swing/editorpane/IconURL16.gif")));
        this.urlButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HyperEditorPane.this.urlButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.urlButton);
        this.fileButton.setIcon(new ImageIcon(this.getClass().getResource("/tr/swing/editorpane/IconFile16.gif")));
        this.fileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HyperEditorPane.this.fileButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.fileButton);
        this.add((Component)this.toolBar, "First");
        this.scrollPane.setViewportView(this.hyperPane);
        this.add((Component)this.scrollPane, "Center");
        this.hyperPane.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                HyperEditorPane.this.urlButton.setFocusable(true);
                HyperEditorPane.this.fileButton.setFocusable(true);
            }

            public void focusLost(FocusEvent e) {
                if (e.getOppositeComponent() != HyperEditorPane.this.editButton && e.getOppositeComponent() != HyperEditorPane.this.urlButton && e.getOppositeComponent() != HyperEditorPane.this.fileButton) {
                    HyperEditorPane.this.setEditable(false);
                    HyperEditorPane.this.editButton.setFocusable(true);
                    HyperEditorPane.this.urlButton.setFocusable(false);
                    HyperEditorPane.this.fileButton.setFocusable(false);
                }
            }
        });
    }

    private void hyperPaneMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            this.hyperPane.setEditable(!this.hyperPane.isEditable());
            if (this.hyperPane.isEditable()) {
                this.editButton.setSelected(true);
                this.hyperPane.requestFocusInWindow();
                try {
                    this.hyperPane.setCaretPosition(this.hyperPane.getText().length());
                }
                catch (Exception exception) {}
            } else {
                this.editButton.setSelected(false);
                this.editButton.requestFocusInWindow();
            }
        }
    }

    private void editToggleButtonActionPerformed(ActionEvent evt) {
        this.hyperPane.setEditable(this.editButton.isSelected());
        if (this.hyperPane.isEditable()) {
            this.hyperPane.requestFocusInWindow();
            try {
                this.hyperPane.setCaretPosition(this.hyperPane.getText().length());
            }
            catch (Exception exception) {}
        } else {
            this.editButton.requestFocusInWindow();
        }
    }

    private void urlButtonActionPerformed(ActionEvent evt) {
        URLDialog dialog = new URLDialog(null, this.urlButton, "Insert Web URL");
        int choice = dialog.showDialog();
        if (choice == 2) {
            if (this.hyperPane.isEditable()) {
                this.hyperPane.requestFocusInWindow();
            }
            return;
        }
        String urlText = dialog.getURL().trim();
        String urlDesc = dialog.getLinkText().trim();
        if (!urlText.contains("://")) {
            urlText = "http://" + urlText;
        }
        try {
            URL url = new URL(urlText);
        }
        catch (MalformedURLException ex) {
            LOG.severe(ex.getMessage());
            if (this.hyperPane.isEditable()) {
                this.hyperPane.requestFocusInWindow();
            }
            return;
        }
        boolean editing = this.hyperPane.isEditable();
        if (!editing) {
            this.hyperPane.setEditable(true);
        }
        int cp = this.hyperPane.getCaretPosition();
        String text = this.hyperPane.getText();
        String url = urlDesc.length() == 0 ? "[" + urlText + "]" : "[" + urlText + "|" + urlDesc + "]";
        text = text.substring(0, cp) + this.getSeparator(text, cp) + url + text.substring(cp);
        this.hyperPane.setText(text);
        if (editing) {
            this.hyperPane.requestFocusInWindow();
        } else {
            this.hyperPane.setEditable(false);
        }
    }

    private void fileButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Insert File URL");
        int option = chooser.showOpenDialog(null);
        if (option != 0) {
            if (this.hyperPane.isEditable()) {
                this.hyperPane.requestFocusInWindow();
            }
            return;
        }
        String path = chooser.getSelectedFile().getPath();
        File file = new File(path);
        if (!file.exists()) {
            LOG.severe("File does not exist.");
            if (this.hyperPane.isEditable()) {
                this.hyperPane.requestFocusInWindow();
            }
            return;
        }
        String url = null;
        try {
            url = file.toURL().toExternalForm();
        }
        catch (MalformedURLException ex) {
            LOG.severe(ex.getMessage());
            if (this.hyperPane.isEditable()) {
                this.hyperPane.requestFocusInWindow();
            }
            return;
        }
        boolean editing = this.hyperPane.isEditable();
        if (!editing) {
            this.hyperPane.setEditable(true);
        }
        int cp = this.hyperPane.getCaretPosition();
        String text = this.hyperPane.getText();
        url = "[" + url + "]";
        text = text.substring(0, cp) + this.getSeparator(text, cp) + url + text.substring(cp);
        this.hyperPane.setText(text);
        this.hyperPane.setText(text);
        if (editing) {
            this.hyperPane.requestFocusInWindow();
        } else {
            this.hyperPane.setEditable(false);
        }
    }

    private String getSeparator(String string, int index) {
        if (index < 1) {
            return "";
        }
        Pattern p = Pattern.compile("\\s");
        Matcher m = p.matcher(string.substring(index - 1, index));
        return m.matches() ? "" : " ";
    }

    public void setEnabled(boolean enabled) {
        this.hyperPane.setEnabled(enabled);
        this.editButton.setEnabled(enabled);
        this.fileButton.setEnabled(enabled);
        this.urlButton.setEnabled(enabled);
    }

    public void setEditable(boolean editable) {
        this.hyperPane.setEditable(editable);
        this.editButton.setSelected(editable);
    }

    public boolean isEditable() {
        return this.hyperPane.isEditable();
    }

    public String getText() {
        return this.hyperPane.getText();
    }

    public void setText(String text) {
        this.hyperPane.setText(text);
    }

    public void addDocumentListener(DocumentListener listener) {
        this.hyperPane.textDocument.addDocumentListener(listener);
    }

    public void removeDocumentListener(DocumentListener listener) {
        this.hyperPane.textDocument.removeDocumentListener(listener);
    }

    public void addHyperlinkListener(HyperlinkListener listener) {
        this.hyperPane.addHyperlinkListener(listener);
    }

    public void removeHyperlinkListener(HyperlinkListener listener) {
        this.hyperPane.removeHyperlinkListener(listener);
    }

    public JEditorPane getJEditorPane() {
        return this.hyperPane;
    }

    public JToggleButton getEditButton() {
        return this.editButton;
    }

    public JButton getURLButton() {
        return this.urlButton;
    }

    public JButton getFileButton() {
        return this.fileButton;
    }
}

