/*
 * Decompiled with CFR 0.152.
 */
package tr.swing.date;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import tr.swing.date.DateItem;
import tr.swing.date.DateType;
import tr.util.DateButton;
import tr.util.Observable;
import tr.util.ObservableImpl;
import tr.util.Observer;

public class DateCombo
extends JComboBox
implements ActionListener,
Observable {
    private final boolean calculate;
    private final DateItem chosen;
    private final ObservableImpl observable = new ObservableImpl(){};

    public DateCombo(DateItem[] items, boolean calculate) {
        super(new DefaultComboBoxModel<DateItem>(items));
        this.calculate = calculate;
        this.chosen = new DateItem(DateType.NONE, "", 0L);
        this.insertItemAt(this.chosen, 0);
        this.setMaximumRowCount(items.length + 1);
        this.addActionListener(this);
    }

    public void actionPerformed(ActionEvent e) {
        DateItem item = (DateItem)this.getSelectedItem();
        if (item == DateItem.DATE_CHOOSER) {
            DateButton db = new DateButton();
            db.component = this;
            if (this.chosen.type == DateType.DAYS) {
                Calendar c = Calendar.getInstance();
                c.add(6, (int)this.chosen.value);
                db.setDate(c.getTime());
            } else if (this.chosen.type == DateType.MS) {
                db.setDate(new Date(this.chosen.value));
            }
            db.doClick();
            Date date = db.getDate();
            if (date == null) {
                this.chosen.type = DateType.NONE;
                this.chosen.label = "";
                this.chosen.value = 0L;
            } else {
                this.chosen.type = DateType.MS;
                this.chosen.label = db.getText();
                this.chosen.value = date.getTime();
            }
        } else if (this.calculate) {
            if (item.type == DateType.DAYS) {
                this.chosen.type = DateType.MS;
                Calendar c = Calendar.getInstance();
                c.add(6, (int)item.value);
                this.chosen.label = DateButton.DATE_FORMAT.format(c.getTime());
                this.chosen.value = c.getTimeInMillis();
            } else if (item.type == DateType.MS) {
                this.chosen.type = DateType.MS;
                this.chosen.label = DateButton.DATE_FORMAT.format(new Date(item.value));
                this.chosen.value = item.value;
            }
        } else {
            this.chosen.type = item.type;
            this.chosen.label = item.label;
            this.chosen.value = item.value;
        }
        this.setSelectedIndex(0);
        this.observable.notifyObservers((Observable)this, (Object)this);
    }

    public DateItem getDateItem(DateType type, String label, long value) {
        if (type == DateType.MS) {
            this.chosen.type = type;
            this.chosen.label = label;
            this.chosen.value = value;
            return this.chosen;
        }
        for (int i = 0; i < this.getItemCount(); ++i) {
            DateItem item = (DateItem)this.getItemAt(i);
            if (item.type != type || item.value != value) continue;
            return item;
        }
        return null;
    }

    public static Date getDate(DateItem item) {
        if (item == null) {
            return null;
        }
        if (item.type == DateType.DAYS) {
            Calendar c = Calendar.getInstance();
            c.add(6, (int)item.value);
            return c.getTime();
        }
        if (item.type == DateType.MS) {
            return new Date(item.value);
        }
        return null;
    }

    public void addObserver(Observer observer) {
        this.observable.addObserver(observer);
    }

    public void removeObserver(Observer observer) {
        this.observable.removeObserver(observer);
    }

    public void removeObservers() {
        this.observable.removeObservers();
    }

    public void resetObservers() {
        this.observable.resetObservers();
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Test DateCombo");
        DateItem[] items = new DateItem[]{DateItem.DATE_CHOOSER, DateItem.TODAY, DateItem.TOMORROW, DateItem.WEEKS_1, DateItem.WEEKS_2, DateItem.WEEKS_4};
        final DateCombo dc1 = new DateCombo(items, false);
        dc1.addObserver(new Observer(){

            public void update(Observable observable, Object arguement) {
                DateItem item = (DateItem)dc1.getSelectedItem();
                if (item != null) {
                    Date date = DateCombo.getDate(item);
                    System.out.println(date);
                } else {
                    System.out.println("null");
                }
            }
        });
        final DateCombo dc2 = new DateCombo(items, true);
        dc2.addObserver(new Observer(){

            public void update(Observable observable, Object arguement) {
                DateItem item = (DateItem)dc2.getSelectedItem();
                if (item != null) {
                    Date date = DateCombo.getDate(item);
                    System.out.println(date);
                } else {
                    System.out.println("null");
                }
            }
        });
        frame.add((Component)dc1, "North");
        frame.add((Component)dc2, "South");
        frame.setSize(400, 400);
        frame.setVisible(true);
    }
}

