/*
 * Decompiled with CFR 0.152.
 */
package tr.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellEditor;

public class ColorEditor
extends AbstractCellEditor
implements TableCellEditor,
ActionListener {
    private static final String EDIT = "edit";
    private Color currentColor;
    private JButton button = new JButton();
    private JColorChooser colorChooser;
    private JDialog dialog;
    private Border selectedBorder;
    private JTable table;

    public ColorEditor() {
        this.button.setActionCommand(EDIT);
        this.button.addActionListener(this);
        this.button.setBorderPainted(true);
        this.colorChooser = new JColorChooser();
        this.dialog = JColorChooser.createDialog(this.button, "Choose a Colour", true, this.colorChooser, this, null);
    }

    public void actionPerformed(ActionEvent e) {
        if (EDIT.equals(e.getActionCommand())) {
            this.colorChooser.setColor(this.currentColor);
            this.dialog.setVisible(true);
            this.fireEditingStopped();
        } else {
            this.currentColor = this.colorChooser.getColor();
        }
        if (this.table != null) {
            this.table.requestFocus();
        }
    }

    public Object getCellEditorValue() {
        return this.currentColor;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.table = table;
        this.currentColor = (Color)value;
        this.button.setBackground(this.currentColor);
        if (this.selectedBorder == null) {
            this.selectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getSelectionBackground());
        }
        this.button.setBorder(this.selectedBorder);
        return this.button;
    }
}

