/*
 * Decompiled with CFR 0.152.
 */
package tr.data;

import java.awt.EventQueue;
import java.io.File;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;
import tr.data.FileFilterImpl;
import tr.data.Resources;
import tr.data.SaveAction;
import tr.datastore.DataStore;
import tr.datastore.DataStoreLookup;
import tr.datastore.xstream.XStreamDataStore;
import tr.model.Data;
import tr.model.DataLookup;
import tr.util.Utils;

public final class SaveToAction
extends CallableSystemAction {
    private static final Logger LOG = Logger.getLogger("tr.data");
    private static final Preferences prefs = Preferences.userRoot().node("ThinkingRock/file");
    private static final String KEY_SAVE_TO_PATH = "saveto.path";
    private static final String DEF_SAVE_TO_PATH = "";

    public SaveToAction() {
        this.setIcon(Resources.ICON_SAVETO);
        this.enableDisable();
        Lookup.Result r = DataLookup.instance().lookup(new Lookup.Template(Data.class));
        r.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent lookupEvent) {
                SaveToAction.this.enableDisable();
            }
        });
    }

    private void enableDisable() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                Data data = (Data)DataLookup.instance().lookup(Data.class);
                SaveToAction.this.setEnabled(data != null);
            }
        });
    }

    public void performAction() {
        DataStore ds = (DataStore)DataStoreLookup.instance().lookup(DataStore.class);
        if (ds == null) {
            return;
        }
        this.saveData(ds);
        JFileChooser chooser = new JFileChooser();
        String[] extns = XStreamDataStore.FILE_EXTENSIONS;
        FileFilterImpl filter = new FileFilterImpl("ThinkingRock XStream files", extns, true);
        chooser.setFileFilter(filter);
        String lastPath = SaveToAction.getSaveToPath();
        lastPath = lastPath.equals(DEF_SAVE_TO_PATH) ? ds.getPath() : lastPath;
        chooser.setSelectedFile(new File(lastPath));
        int returnVal = chooser.showDialog(null, "Save To");
        if (returnVal == 0) {
            String t;
            String m;
            int r;
            File file;
            String pathTo = chooser.getSelectedFile().getPath();
            String extn = Utils.getExtension((String)pathTo);
            if (!Utils.in((String)extn, (String[])extns)) {
                pathTo = Utils.setExtension((String)pathTo, (String)"trx");
            }
            if ((file = new File(pathTo)).exists() && (r = JOptionPane.showConfirmDialog(null, m = "Are you sure you to want to replace this file?    ", t = "Save To", 0)) != 0) {
                return;
            }
            LOG.info("Save To: " + pathTo);
            String path = ds.getPath();
            ds.setPath(pathTo);
            ds.setChanged(true);
            this.saveData(ds);
            SaveToAction.setSaveToPath(pathTo);
            ds.setPath(path);
        }
    }

    private void saveData(DataStore ds) {
        try {
            ds.store();
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
    }

    public String getName() {
        return NbBundle.getMessage(SaveAction.class, (String)"CTL_SaveToAction");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    public static final String getSaveToPath() {
        return prefs.get(KEY_SAVE_TO_PATH, DEF_SAVE_TO_PATH);
    }

    public static final void setSaveToPath(String value) {
        prefs.put(KEY_SAVE_TO_PATH, value);
        SaveToAction.flush();
    }

    private static void flush() {
        try {
            prefs.flush();
        }
        catch (BackingStoreException ex) {
            LOG.severe("Save to preferences error. " + ex.getMessage());
        }
    }
}

