/*
 * Decompiled with CFR 0.152.
 */
package tr.data;

import java.io.File;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;
import org.openide.windows.WindowManager;
import tr.background.activation.ActivatorTaskScheduler;
import tr.background.recurrence.RecurrenceTaskScheduler;
import tr.data.FileFilterImpl;
import tr.data.Resources;
import tr.datastore.DataStore;
import tr.datastore.DataStoreLookup;
import tr.datastore.xstream.XStreamDataStore;
import tr.view.WindowUtils;

public final class OpenAction
extends CallableSystemAction {
    private static final Logger LOG = Logger.getLogger("tr.data");

    public OpenAction() {
        this.setIcon(Resources.ICON_OPEN);
    }

    public void performAction() {
        DataStore ds = (DataStore)DataStoreLookup.instance().lookup(DataStore.class);
        if (ds == null) {
            LOG.severe("Datastore was not found.");
            return;
        }
        try {
            ds.store();
        }
        catch (Exception ex) {
            // empty catch block
        }
        JFileChooser chooser = new JFileChooser();
        String[] extns = XStreamDataStore.FILE_EXTENSIONS;
        FileFilterImpl filter = new FileFilterImpl("ThinkingRock XStream files", extns, true);
        chooser.setFileFilter(filter);
        chooser.setSelectedFile(new File(ds.getPath()));
        int returnVal = chooser.showOpenDialog(null);
        if (returnVal != 0) {
            return;
        }
        String path = chooser.getSelectedFile().getPath();
        ds.setPath(path);
        try {
            ds.load();
            WindowManager.getDefault().getMainWindow().setTitle("ThinkingRock " + path);
            WindowUtils.closeWindows();
            WindowUtils.openInitialWindow();
            ActivatorTaskScheduler.instance().runTask(0, 1, 0);
            RecurrenceTaskScheduler.instance().runTask(0, 2, 0);
        }
        catch (Exception ex) {
            String t = "File Open Error";
            String m = "The data file could not be opened. " + ex.getMessage();
            JOptionPane.showMessageDialog(null, m, t, 0);
            ex.printStackTrace(System.err);
        }
    }

    public String getName() {
        return NbBundle.getMessage(OpenAction.class, (String)"CTL_OpenAction");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }
}

