/*
 * Decompiled with CFR 0.152.
 */
package tr.data;

import java.io.File;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;
import org.openide.windows.WindowManager;
import tr.data.FileFilterImpl;
import tr.data.Resources;
import tr.datastore.DataStore;
import tr.datastore.DataStoreLookup;
import tr.datastore.xstream.XStreamDataStore;
import tr.model.Data;
import tr.util.Utils;
import tr.view.WindowUtils;

public final class NewAction
extends CallableSystemAction {
    private static final Logger LOG = Logger.getLogger("tr.data");

    public NewAction() {
        this.setIcon(Resources.ICON_NEW);
    }

    public void performAction() {
        DataStore ds = (DataStore)DataStoreLookup.instance().lookup(DataStore.class);
        if (ds == null) {
            LOG.severe("Datastore was not found.");
            return;
        }
        try {
            ds.store();
        }
        catch (Exception ex) {
            // empty catch block
        }
        JFileChooser chooser = new JFileChooser();
        String[] extns = XStreamDataStore.FILE_EXTENSIONS;
        FileFilterImpl filter = new FileFilterImpl("ThinkingRock XStream files", extns, true);
        chooser.setFileFilter(filter);
        chooser.setSelectedFile(new File(ds.getPath()));
        int returnVal = chooser.showDialog(null, "New File");
        if (returnVal == 0) {
            File newfile;
            String path = chooser.getSelectedFile().getPath();
            String extn = Utils.getExtension((String)path);
            if (!Utils.in((String)extn, (String[])extns)) {
                path = Utils.setExtension((String)path, (String)"trx");
            }
            if ((newfile = new File(path)).exists()) {
                String m = "Are you sure you to want to replace the selected file?      ";
                String t = "New File";
                int r = JOptionPane.showConfirmDialog(null, m, t, 0);
                if (r == 0) {
                    newfile.delete();
                } else {
                    return;
                }
            }
            System.out.println("New file: " + path);
            try {
                newfile.createNewFile();
                ds.setPath(path);
                ds.setData(new Data());
                ds.setChanged(true);
                ds.store();
                WindowManager.getDefault().getMainWindow().setTitle("ThinkingRock " + path);
                WindowUtils.closeWindows();
                WindowUtils.openInitialWindow();
            }
            catch (Exception ex) {
                String t = "New File Error";
                String m = "Could not create the new file.      \n" + ex.getMessage();
                JOptionPane.showMessageDialog(null, m, t, 0);
            }
        }
    }

    public String getName() {
        return NbBundle.getMessage(NewAction.class, (String)"CTL_NewAction");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }
}

