/*
 * Decompiled with CFR 0.152.
 */
package org.openide.execution;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.text.Format;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.openide.ErrorManager;
import org.openide.util.Utilities;

public final class NbProcessDescriptor
implements Serializable {
    private static final long serialVersionUID = -4535211234565221486L;
    private static ErrorManager execLog;
    private String processName;
    private String arguments;
    private String info;

    public NbProcessDescriptor(String string, String string2) {
        this(string, string2, null);
    }

    public NbProcessDescriptor(String string, String string2, String string3) {
        this.processName = string;
        this.arguments = string2;
        this.info = string3;
    }

    public String getProcessName() {
        return this.processName;
    }

    public String getArguments() {
        return this.arguments;
    }

    public String getInfo() {
        return this.info;
    }

    public Process exec(Format format, String[] stringArray, File file) throws IOException {
        return this.exec(format, stringArray, false, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Process exec(Format format, String[] stringArray, boolean bl, File file) throws IOException {
        int n;
        Object object;
        Iterator iterator;
        String string = format == null ? this.arguments : format.format(this.arguments);
        String[] stringArray2 = NbProcessDescriptor.parseArguments(string);
        String[] stringArray3 = null;
        stringArray = NbProcessDescriptor.substituteEnv(format, stringArray);
        stringArray3 = new String[stringArray2.length + 1];
        stringArray3[0] = format == null ? this.processName : format.format(this.processName);
        System.arraycopy(stringArray2, 0, stringArray3, 1, stringArray2.length);
        NbProcessDescriptor.logArgs(stringArray3);
        if (stringArray != null && bl) {
            HashMap hashMap = new HashMap(100);
            iterator = System.getProperties().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                object = (String)entry.getKey();
                if (!((String)object).startsWith("Env-")) continue;
                String string2 = ((String)object).substring(4);
                hashMap.put(string2, entry.getValue());
            }
            for (n = 0; n < stringArray.length; ++n) {
                object = stringArray[n];
                int n2 = ((String)object).indexOf(61);
                if (n2 == -1) {
                    throw new IOException("No equal sign in name=value: " + object);
                }
                hashMap.put(((String)object).substring(0, n2), ((String)object).substring(n2 + 1));
            }
            stringArray = new String[hashMap.size()];
            n = 0;
            iterator = hashMap.entrySet().iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                stringArray[n++] = (String)object.getKey() + '=' + (String)object.getValue();
            }
        }
        int n3 = Utilities.getOperatingSystem();
        iterator = null;
        n = 0;
        try {
            if (n3 == 4) {
                iterator = Thread.currentThread();
                n = ((Thread)((Object)iterator)).getPriority();
                ((Thread)((Object)iterator)).setPriority(5);
            }
            if (file == null) {
                if (stringArray == null) {
                    object = Runtime.getRuntime().exec(stringArray3);
                    return object;
                }
                object = Runtime.getRuntime().exec(stringArray3, stringArray);
                return object;
            }
            object = Runtime.getRuntime().exec(stringArray3, stringArray, file);
            return object;
        }
        finally {
            if (n3 == 4) {
                ((Thread)((Object)iterator)).setPriority(n);
            }
        }
    }

    private static void logArgs(String[] stringArray) {
        NbProcessDescriptor.getExecLog().log(1, "Running: " + Arrays.asList(stringArray));
    }

    public Process exec(Format format, String[] stringArray) throws IOException {
        return this.exec(format, stringArray, null);
    }

    public Process exec(Format format) throws IOException {
        return this.exec(format, null);
    }

    public Process exec() throws IOException {
        return this.exec(null, null);
    }

    public int hashCode() {
        return this.processName.hashCode() + this.arguments.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof NbProcessDescriptor)) {
            return false;
        }
        NbProcessDescriptor nbProcessDescriptor = (NbProcessDescriptor)object;
        return this.processName.equals(nbProcessDescriptor.processName) && this.arguments.equals(nbProcessDescriptor.arguments);
    }

    private static String[] parseArguments(String string) {
        return Utilities.parseParameters((String)string);
    }

    private static ErrorManager getExecLog() {
        if (execLog == null) {
            execLog = ErrorManager.getDefault().getInstance("IDE-Exec");
        }
        return execLog;
    }

    private static String[] substituteEnv(Format format, String[] stringArray) {
        if (stringArray == null || stringArray.length == 0 || format == null) {
            return stringArray;
        }
        String[] stringArray2 = new String[stringArray.length];
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            stringArray2[i] = stringArray[i];
            if (stringArray2[i] == null || (n = stringArray2[i].indexOf(61)) < 0) continue;
            String string = stringArray2[i].substring(n + 1);
            String string2 = stringArray2[i].substring(0, n);
            stringBuffer.append(string2).append('=').append(format.format(string));
            stringArray2[i] = stringBuffer.toString();
            stringBuffer.setLength(0);
        }
        return stringArray2;
    }
}

