/*
 * Decompiled with CFR 0.152.
 */
package tr.view.actions.screens.prefs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.table.DefaultTableModel;
import org.jdesktop.layout.GroupLayout;
import tr.model.util.Manager;
import tr.util.Observable;
import tr.view.actions.Resources;
import tr.view.actions.screens.fields.ActionsScreen;
import tr.view.actions.screens.fields.ActionsScreens;
import tr.view.actions.screens.prefs.ActionsScreensItem;
import tr.view.actions.screens.prefs.ActionsScreensOptionsPanelController;
import tr.view.actions.screens.prefs.ActionsScreensOptionsTableModel;

final class ActionsScreensOptionsPanel
extends JPanel {
    private final ActionsScreensOptionsPanelController controller;
    private JButton addButton;
    private JButton delButton;
    private JButton downButton;
    private JPanel mainPanel;
    private JTable table;
    private JScrollPane tableScrollPane;
    private JToolBar toolbar;
    private JButton upButton;
    private Manager<ActionsScreensItem> items;

    ActionsScreensOptionsPanel(ActionsScreensOptionsPanelController controller) {
        this.controller = controller;
        this.initComponents();
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.tableScrollPane = new JScrollPane();
        this.table = new JTable();
        this.toolbar = new JToolBar();
        this.addButton = new JButton();
        this.delButton = new JButton();
        this.downButton = new JButton();
        this.upButton = new JButton();
        this.setBackground(Color.white);
        this.mainPanel.setBorder(BorderFactory.createEtchedBorder());
        this.table.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.tableScrollPane.setViewportView(this.table);
        this.toolbar.setFloatable(false);
        this.toolbar.setOrientation(1);
        this.toolbar.setMargin(new Insets(2, 2, 2, 2));
        this.addButton.setIcon(Resources.ICON_PLUS);
        this.addButton.setHorizontalTextPosition(0);
        this.addButton.setMaximumSize(new Dimension(24, 24));
        this.addButton.setMinimumSize(new Dimension(24, 24));
        this.addButton.setPreferredSize(new Dimension(24, 24));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ActionsScreensOptionsPanel.this.addActionPerformed(evt);
            }
        });
        this.toolbar.add(this.addButton);
        this.delButton.setIcon(Resources.ICON_MINUS);
        this.delButton.setHorizontalTextPosition(0);
        this.delButton.setMaximumSize(new Dimension(24, 24));
        this.delButton.setMinimumSize(new Dimension(24, 24));
        this.delButton.setPreferredSize(new Dimension(24, 24));
        this.delButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ActionsScreensOptionsPanel.this.removeActionPerformed(evt);
            }
        });
        this.toolbar.add(this.delButton);
        this.downButton.setIcon(Resources.ICON_DOWN);
        this.downButton.setHorizontalTextPosition(0);
        this.downButton.setMaximumSize(new Dimension(24, 24));
        this.downButton.setMinimumSize(new Dimension(24, 24));
        this.downButton.setPreferredSize(new Dimension(24, 24));
        this.downButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ActionsScreensOptionsPanel.this.downActionPerformed(evt);
            }
        });
        this.toolbar.add(this.downButton);
        this.upButton.setIcon(Resources.ICON_UP);
        this.upButton.setHorizontalTextPosition(0);
        this.upButton.setMaximumSize(new Dimension(24, 24));
        this.upButton.setMinimumSize(new Dimension(24, 24));
        this.upButton.setPreferredSize(new Dimension(24, 24));
        this.upButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ActionsScreensOptionsPanel.this.upActionPerformed(evt);
            }
        });
        this.toolbar.add(this.upButton);
        GroupLayout mainPanelLayout = new GroupLayout((Container)this.mainPanel);
        this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
        mainPanelLayout.setHorizontalGroup((GroupLayout.Group)mainPanelLayout.createParallelGroup(1).add((GroupLayout.Group)mainPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.toolbar, -2, -1, -2).add(2, 2, 2).add((Component)this.tableScrollPane, -1, 146, Short.MAX_VALUE).addContainerGap()));
        mainPanelLayout.setVerticalGroup((GroupLayout.Group)mainPanelLayout.createParallelGroup(1).add((GroupLayout.Group)mainPanelLayout.createSequentialGroup().add((GroupLayout.Group)mainPanelLayout.createParallelGroup(1).add((GroupLayout.Group)mainPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.tableScrollPane, -1, 129, Short.MAX_VALUE)).add((GroupLayout.Group)mainPanelLayout.createSequentialGroup().add(37, 37, 37).add((Component)this.toolbar, -2, 112, -2))).addContainerGap()));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.mainPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.mainPanel, -1, -1, Short.MAX_VALUE));
    }

    private void selectTableRow(int row) {
        this.table.changeSelection(row, 0, false, false);
    }

    private void upActionPerformed(ActionEvent evt) {
        int row = this.table.getSelectedRow();
        if (row == -1) {
            return;
        }
        ActionsScreensOptionsTableModel tm = (ActionsScreensOptionsTableModel)this.table.getModel();
        if (tm == null) {
            return;
        }
        if (tm.moveUp(row)) {
            this.selectTableRow(row - 1);
        }
    }

    private void downActionPerformed(ActionEvent evt) {
        int row = this.table.getSelectedRow();
        if (row == -1) {
            return;
        }
        ActionsScreensOptionsTableModel tm = (ActionsScreensOptionsTableModel)this.table.getModel();
        if (tm == null) {
            return;
        }
        if (tm.moveDown(row)) {
            this.selectTableRow(row + 1);
        }
    }

    private void removeActionPerformed(ActionEvent evt) {
        int row = this.table.getSelectedRow();
        if (row == -1) {
            return;
        }
        ActionsScreensOptionsTableModel tm = (ActionsScreensOptionsTableModel)this.table.getModel();
        if (tm == null) {
            return;
        }
        if (tm.removeRow(row)) {
            if (row < this.table.getRowCount()) {
                this.selectTableRow(row);
            } else if (row > 0) {
                this.selectTableRow(row - 1);
            }
        }
    }

    private void addActionPerformed(ActionEvent evt) {
        ActionsScreensOptionsTableModel tm = (ActionsScreensOptionsTableModel)this.table.getModel();
        if (tm == null) {
            return;
        }
        if (tm.addRow()) {
            int row = this.table.getRowCount() - 1;
            this.table.changeSelection(row, 0, false, false);
            this.table.requestFocus();
            this.table.editCellAt(row, 0);
        }
    }

    void load() {
        this.items = new Manager();
        Manager<ActionsScreen> screens = ActionsScreens.instance().getScreens();
        for (ActionsScreen screen : screens.list()) {
            this.items.add((Observable)new ActionsScreensItem(screen.toString(), screen));
        }
        this.table.setModel(new ActionsScreensOptionsTableModel(this.items));
    }

    void store() {
        Manager screens = new Manager();
        for (ActionsScreensItem item : this.items.list()) {
            if (item.screen == null) {
                screens.add((Observable)ActionsScreen.create(item.name));
                continue;
            }
            item.screen.setKey(item.name);
            screens.add((Observable)item.screen);
        }
        ActionsScreens.instance().setScreens((Manager<ActionsScreen>)screens);
        ActionsScreens.instance().store();
    }

    boolean valid() {
        return true;
    }
}

