/*
 * Decompiled with CFR 0.152.
 */
package tr.view.actions.screens.fields;

import java.util.Vector;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import tr.model.util.Manager;
import tr.util.Observable;
import tr.view.actions.screens.fields.ActionsField;
import tr.view.actions.screens.fields.ActionsFilter;
import tr.view.actions.screens.fields.ActionsFilterDone;
import tr.view.actions.screens.fields.ActionsFilterStatus;
import tr.view.actions.screens.fields.ActionsScreen;
import tr.view.actions.screens.fields.DateItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ActionsScreens {
    private static final Logger LOG = Logger.getLogger("tr.view.actions");
    private static final String PREFS_PATH_ROOT = "ThinkingRock/actions/screens";
    private static ActionsScreens instance;
    private Manager<ActionsScreen> screens;

    private ActionsScreens() {
        this.load();
    }

    public static final ActionsScreens instance() {
        if (instance == null) {
            instance = new ActionsScreens();
        }
        return instance;
    }

    public Manager<ActionsScreen> getScreens() {
        if (this.screens == null) {
            this.screens = new Manager();
        }
        return this.screens;
    }

    public void setScreens(Manager<ActionsScreen> screens) {
        this.screens = screens;
    }

    public void store() {
        if (this.screens == null) {
            return;
        }
        LOG.fine("Storing actions screen definitions");
        Preferences prefsRoot = Preferences.userRoot().node(PREFS_PATH_ROOT);
        try {
            prefsRoot.removeNode();
        }
        catch (BackingStoreException ex) {
            // empty catch block
        }
        prefsRoot = Preferences.userRoot().node(PREFS_PATH_ROOT);
        for (int i = 0; i < this.screens.size(); ++i) {
            Preferences prefsScreen = prefsRoot.node("screen" + i);
            ActionsScreen screen = (ActionsScreen)this.screens.get(i);
            prefsScreen.put("key", screen.getKey());
            prefsScreen.putByteArray("order", screen.getFieldOrder());
            prefsScreen.putByteArray("sortfields", screen.getSortFields());
            prefsScreen.putByteArray("sortstatus", screen.getSortStatus());
            for (int j = 0; j < screen.getFields().size(); ++j) {
                Preferences prefsField = prefsScreen.node("field" + j);
                ActionsField field = (ActionsField)screen.getFields().get(j);
                prefsField.putInt("type", field.getType());
                prefsField.putBoolean("visible", field.isVisible());
                prefsField.putInt("width", field.getWidth());
            }
            for (int k = 0; k < screen.getFilters().size(); ++k) {
                Preferences prefsFilter = prefsScreen.node("filter" + k);
                ActionsFilter filter = (ActionsFilter)screen.getFilters().get(k);
                prefsFilter.putInt("id", filter.id);
                prefsFilter.putBoolean("used", filter.isUsed());
                prefsFilter.putBoolean("visible", filter.isVisible());
                Preferences prefsValues = prefsFilter.node("values");
                String[] values = filter.getSerialValues();
                if (values == null) continue;
                for (int n = 0; n < values.length; ++n) {
                    prefsValues.put("value" + n, values[n]);
                }
            }
        }
        try {
            prefsRoot.flush();
        }
        catch (BackingStoreException ex) {
            LOG.severe("Backing Store Exception");
        }
    }

    public void load() {
        try {
            if (!Preferences.userRoot().nodeExists(PREFS_PATH_ROOT)) {
                this.createDefaultScreens();
                return;
            }
            LOG.fine("Loading actions screen definitions");
            Preferences prefsRoot = Preferences.userRoot().node(PREFS_PATH_ROOT);
            this.screens = new Manager();
            int i = 0;
            while (prefsRoot.nodeExists("screen" + i)) {
                Preferences prefsScreen = prefsRoot.node("screen" + i++);
                ActionsScreen screen = ActionsScreen.create(prefsScreen.get("key", ""));
                screen.setFieldOrder(prefsScreen.getByteArray("order", null));
                screen.setSortFields(prefsScreen.getByteArray("sortfields", null));
                screen.setSortStatus(prefsScreen.getByteArray("sortstatus", null));
                int j = -1;
                while (prefsScreen.nodeExists("field" + ++j)) {
                    Preferences prefsField = prefsScreen.node("field" + j);
                    ActionsField field = (ActionsField)screen.getFields().get(j);
                    field.setVisible(prefsField.getBoolean("visible", field.isVisible()));
                    field.setWidth(prefsField.getInt("width", field.getWidth()));
                }
                int k = -1;
                while (prefsScreen.nodeExists("filter" + ++k)) {
                    String value;
                    Preferences prefsFilter = prefsScreen.node("filter" + k);
                    ActionsFilter filter = (ActionsFilter)screen.getFilters().get(k);
                    filter.setUsed(prefsFilter.getBoolean("used", false));
                    filter.setVisible(prefsFilter.getBoolean("visible", false));
                    Preferences prefsValues = prefsFilter.node("values");
                    Vector<String> values = new Vector<String>();
                    for (int n = 0; n < Integer.MAX_VALUE && !"%%%NONE%%%".equals(value = prefsValues.get("value" + n, "%%%NONE%%%")); ++n) {
                        values.add(value);
                    }
                    filter.setSerialValues(values.toArray(new String[0]));
                }
                this.screens.add((Observable)screen);
            }
        }
        catch (BackingStoreException ex) {
            LOG.severe("Backing Store Exception");
        }
    }

    private void createDefaultScreens() {
        LOG.fine("Creating default actions screen definitions");
        this.screens = new Manager();
        ActionsScreen screen = ActionsScreen.create("screen-actions");
        ActionsField field = (ActionsField)screen.getFields().get(4);
        field.setVisible(false);
        field = (ActionsField)screen.getFields().get(5);
        field.setVisible(false);
        field = (ActionsField)screen.getFields().get(8);
        field.setVisible(false);
        field = (ActionsField)screen.getFields().get(9);
        field.setVisible(false);
        field = (ActionsField)screen.getFields().get(10);
        field.setVisible(false);
        field = (ActionsField)screen.getFields().get(16);
        field.setVisible(false);
        field = (ActionsField)screen.getFields().get(15);
        field.setVisible(false);
        ActionsFilter filter = (ActionsFilter)screen.getFilters().get(0);
        filter.setUsed(true);
        filter.setVisible(true);
        filter.setSerialValues(new String[]{ActionsFilterDone.DoneItem.NOT_DONE.toID()});
        filter = (ActionsFilter)screen.getFilters().get(1);
        filter.setUsed(true);
        filter.setVisible(true);
        filter.setSerialValues(new String[]{ActionsFilterStatus.StatusItem.ALL.toID()});
        filter = (ActionsFilter)screen.getFilters().get(2);
        filter.setUsed(true);
        filter.setVisible(true);
        filter.setSerialValues(new String[]{"all"});
        filter = (ActionsFilter)screen.getFilters().get(6);
        filter.setUsed(true);
        filter.setVisible(true);
        filter.setSerialValues(new String[]{"all"});
        filter = (ActionsFilter)screen.getFilters().get(12);
        filter.setUsed(true);
        filter.setVisible(true);
        filter.setSerialValues(new String[]{String.valueOf(DateItem.TODAY.value)});
        filter = (ActionsFilter)screen.getFilters().get(13);
        filter.setUsed(true);
        filter.setVisible(true);
        filter.setSerialValues(new String[]{""});
        this.screens.add((Observable)screen);
        screen = ActionsScreen.create("screen-done");
        field = (ActionsField)screen.getFields().get(4);
        field.setVisible(false);
        field = (ActionsField)screen.getFields().get(8);
        field.setVisible(false);
        field = (ActionsField)screen.getFields().get(9);
        field.setVisible(false);
        field = (ActionsField)screen.getFields().get(10);
        field.setVisible(false);
        field = (ActionsField)screen.getFields().get(16);
        field.setVisible(false);
        field = (ActionsField)screen.getFields().get(15);
        field.setVisible(false);
        filter = (ActionsFilter)screen.getFilters().get(0);
        filter.setUsed(true);
        filter.setVisible(false);
        filter.setSerialValues(new String[]{ActionsFilterDone.DoneItem.DONE.toID()});
        filter = (ActionsFilter)screen.getFilters().get(2);
        filter.setUsed(true);
        filter.setVisible(true);
        filter.setSerialValues(new String[]{"all"});
        filter = (ActionsFilter)screen.getFilters().get(6);
        filter.setUsed(true);
        filter.setVisible(true);
        filter.setSerialValues(new String[]{"all"});
        filter = (ActionsFilter)screen.getFilters().get(7);
        filter.setUsed(true);
        filter.setVisible(true);
        filter.setSerialValues(new String[]{String.valueOf(DateItem.WEEKS_AGO_4.value)});
        filter = (ActionsFilter)screen.getFilters().get(8);
        filter.setUsed(true);
        filter.setVisible(true);
        filter.setSerialValues(new String[]{String.valueOf(DateItem.TODAY.value)});
        filter = (ActionsFilter)screen.getFilters().get(13);
        filter.setUsed(true);
        filter.setVisible(true);
        filter.setSerialValues(new String[]{""});
        this.screens.add((Observable)screen);
        screen = ActionsScreen.create("screen-do-asap");
        field = (ActionsField)screen.getFields().get(3);
        field.setVisible(false);
        field = (ActionsField)screen.getFields().get(4);
        field.setVisible(false);
        field = (ActionsField)screen.getFields().get(5);
        field.setVisible(false);
        field = (ActionsField)screen.getFields().get(8);
        field.setVisible(false);
        field = (ActionsField)screen.getFields().get(9);
        field.setVisible(false);
        field = (ActionsField)screen.getFields().get(10);
        field.setVisible(false);
        field = (ActionsField)screen.getFields().get(16);
        field.setVisible(false);
        field = (ActionsField)screen.getFields().get(15);
        field.setVisible(false);
        filter = (ActionsFilter)screen.getFilters().get(0);
        filter.setUsed(true);
        filter.setVisible(true);
        filter.setSerialValues(new String[]{ActionsFilterDone.DoneItem.NOT_DONE.toID()});
        filter = (ActionsFilter)screen.getFilters().get(1);
        filter.setUsed(true);
        filter.setVisible(false);
        filter.setSerialValues(new String[]{ActionsFilterStatus.StatusItem.DO_ASAP.toID()});
        filter = (ActionsFilter)screen.getFilters().get(2);
        filter.setUsed(true);
        filter.setVisible(true);
        filter.setSerialValues(new String[]{"all"});
        filter = (ActionsFilter)screen.getFilters().get(6);
        filter.setUsed(true);
        filter.setVisible(true);
        filter.setSerialValues(new String[]{"all"});
        filter = (ActionsFilter)screen.getFilters().get(13);
        filter.setUsed(true);
        filter.setVisible(true);
        filter.setSerialValues(new String[]{""});
        this.screens.add((Observable)screen);
        screen = ActionsScreen.create("screen-delegated");
        field = (ActionsField)screen.getFields().get(4);
        field.setVisible(false);
        field = (ActionsField)screen.getFields().get(5);
        field.setVisible(false);
        field = (ActionsField)screen.getFields().get(8);
        field.setVisible(false);
        field = (ActionsField)screen.getFields().get(9);
        field.setVisible(false);
        field = (ActionsField)screen.getFields().get(10);
        field.setVisible(false);
        field = (ActionsField)screen.getFields().get(16);
        field.setVisible(false);
        field = (ActionsField)screen.getFields().get(15);
        field.setVisible(false);
        filter = (ActionsFilter)screen.getFilters().get(0);
        filter.setUsed(true);
        filter.setVisible(true);
        filter.setSerialValues(new String[]{ActionsFilterDone.DoneItem.NOT_DONE.toID()});
        filter = (ActionsFilter)screen.getFilters().get(1);
        filter.setUsed(true);
        filter.setVisible(false);
        filter.setSerialValues(new String[]{ActionsFilterStatus.StatusItem.DELEGATED.toID()});
        filter = (ActionsFilter)screen.getFilters().get(2);
        filter.setUsed(true);
        filter.setVisible(true);
        filter.setSerialValues(new String[]{"all"});
        filter = (ActionsFilter)screen.getFilters().get(6);
        filter.setUsed(true);
        filter.setVisible(true);
        filter.setSerialValues(new String[]{"all"});
        filter = (ActionsFilter)screen.getFilters().get(13);
        filter.setUsed(true);
        filter.setVisible(true);
        filter.setSerialValues(new String[]{""});
        this.screens.add((Observable)screen);
        screen = ActionsScreen.create("screen-scheduled");
        field = (ActionsField)screen.getFields().get(3);
        field.setVisible(false);
        field = (ActionsField)screen.getFields().get(4);
        field.setVisible(false);
        field = (ActionsField)screen.getFields().get(5);
        field.setVisible(false);
        field = (ActionsField)screen.getFields().get(8);
        field.setVisible(false);
        field = (ActionsField)screen.getFields().get(9);
        field.setVisible(false);
        field = (ActionsField)screen.getFields().get(10);
        field.setVisible(false);
        field = (ActionsField)screen.getFields().get(15);
        field.setVisible(false);
        field = (ActionsField)screen.getFields().get(16);
        field.setVisible(false);
        field = (ActionsField)screen.getFields().get(16);
        field.setVisible(false);
        field = (ActionsField)screen.getFields().get(15);
        field.setVisible(false);
        filter = (ActionsFilter)screen.getFilters().get(0);
        filter.setUsed(true);
        filter.setVisible(true);
        filter.setSerialValues(new String[]{ActionsFilterDone.DoneItem.NOT_DONE.toID()});
        filter = (ActionsFilter)screen.getFilters().get(1);
        filter.setUsed(true);
        filter.setVisible(false);
        filter.setSerialValues(new String[]{ActionsFilterStatus.StatusItem.SCHEDULED.toID()});
        filter = (ActionsFilter)screen.getFilters().get(2);
        filter.setUsed(true);
        filter.setVisible(true);
        filter.setSerialValues(new String[]{"all"});
        filter = (ActionsFilter)screen.getFilters().get(6);
        filter.setUsed(true);
        filter.setVisible(true);
        filter.setSerialValues(new String[]{"all"});
        filter = (ActionsFilter)screen.getFilters().get(13);
        filter.setUsed(true);
        filter.setVisible(true);
        filter.setSerialValues(new String[]{""});
        this.screens.add((Observable)screen);
    }
}

