/*
 * Decompiled with CFR 0.152.
 */
package tr.view.actions.screens.fields;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import tr.model.Data;
import tr.model.DataLookup;
import tr.model.IDGenerator;
import tr.model.action.Action;
import tr.model.criteria.Value;
import tr.model.util.Manager;
import tr.util.Observable;
import tr.util.Observer;
import tr.view.actions.screens.fields.ActionsFilter;
import tr.view.actions.screens.fields.ActionsFilterComboBox;
import tr.view.actions.screens.fields.MultiChoiceDialog;

public class ActionsFilterTime
extends ActionsFilter {
    public static final byte ID = 3;
    public static final String KEY = "filter-time";
    public static final String ALL = "all";
    public static final String MULTIPLE = "multiple";
    protected TimesComboBox combo;

    protected ActionsFilterTime() {
        super((byte)3);
    }

    public String toString() {
        return this.getText(KEY);
    }

    public void setUsed(boolean used) {
        if (!used && this.combo != null) {
            this.combo.setSelectedItem(null);
        }
        super.setUsed(used);
    }

    public synchronized JComboBox getComboBox() {
        if (this.combo == null) {
            this.combo = new TimesComboBox(new TimesComboBoxModel());
            this.combo.setBackground(Color.white);
        }
        return this.combo;
    }

    public TableCellRenderer getValuesRenderer() {
        return (TableCellRenderer)((Object)this.getComboBox());
    }

    public TableCellEditor getValuesEditor() {
        return new DefaultCellEditor(this.getComboBox());
    }

    public boolean accept(Action action) {
        Value value = (Value)this.getComboBox().getSelectedItem();
        if (value == null || value.getID() == 0) {
            return true;
        }
        if (value.getID() == 1) {
            return this.combo.chosen.contains(action.getTime());
        }
        return value.equals((Object)action.getTime());
    }

    public boolean acceptAll() {
        Value value = (Value)this.getComboBox().getSelectedItem();
        return value == null || value.getID() == 0;
    }

    public String[] getSerialValues() {
        Value value = (Value)this.getComboBox().getSelectedItem();
        if (value == null) {
            return null;
        }
        if (value.getID() == 0) {
            return new String[]{ALL};
        }
        if (value.getID() == 1) {
            if (this.combo == null || this.combo.chosen == null) {
                return null;
            }
            String[] values = new String[this.combo.chosen.size()];
            for (int i = 0; i < values.length; ++i) {
                values[i] = String.valueOf(this.combo.chosen.get(i).getID());
            }
            return values;
        }
        return new String[]{String.valueOf(value.getID())};
    }

    public void setSerialValues(String[] values) {
        this.getComboBox();
        this.combo.stopChangeEvents();
        if (values == null || values.length == 0) {
            this.combo.setSelectedItem(null);
        } else if (values.length == 1) {
            if (values[0].equals(ALL)) {
                this.combo.setSelectedIndex(0);
            } else {
                this.combo.setSelectedItem(this.getValue(values[0]));
            }
        } else if (values.length > 1) {
            this.combo.setSelectedIndex(1);
            this.combo.chosen = new Vector();
            for (String id : values) {
                this.combo.chosen.add(this.getValue(id));
            }
        }
        this.combo.startChangeEvents();
    }

    private Value getValue(String id) {
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        for (Value value : data.getTimeCriterion().values.list()) {
            try {
                if (value.getID() != Integer.parseInt(id)) continue;
                return value;
            }
            catch (Exception ex) {
            }
        }
        return null;
    }

    public class TimesComboBox
    extends ActionsFilterComboBox
    implements TableCellRenderer {
        private final Manager<Value> manager;
        private ActionListener listener;
        public Vector<Value> chosen;

        public TimesComboBox(TimesComboBoxModel model) {
            super((ComboBoxModel)model);
            this.listener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Value v = (Value)TimesComboBox.this.getSelectedItem();
                    if (v != null && v.getID() == 1) {
                        Vector all = TimesComboBox.this.manager.list();
                        if (TimesComboBox.this.chosen == null) {
                            TimesComboBox.this.chosen = new Vector();
                        }
                        MultiChoiceDialog<Value> d = new MultiChoiceDialog<Value>(TimesComboBox.this, all, TimesComboBox.this.chosen);
                        d.setTitle(ActionsFilterTime.this.getText(ActionsFilterTime.KEY));
                        d.setLocationRelativeTo(TimesComboBox.this);
                        d.setVisible(true);
                        if (d.isOkay()) {
                            TimesComboBox.this.chosen = d.getChosen();
                        }
                    }
                    TimesComboBox.this.firePropertyChange("filter-value", null, null);
                }
            };
            this.manager = model.manager;
            this.setPreferredSize(new Dimension(120, 24));
            this.addActionListener(this.listener);
        }

        protected void stopChangeEvents() {
            this.removeActionListener(this.listener);
        }

        protected void startChangeEvents() {
            this.addActionListener(this.listener);
        }
    }

    public class TimesComboBoxModel
    extends DefaultComboBoxModel
    implements Observer {
        public final Value all;
        public final Value multiple;
        public final Manager<Value> manager;
        private List<Value> times;

        public TimesComboBoxModel() {
            Data data = (Data)DataLookup.instance().lookup(Data.class);
            if (data == null) {
                this.all = null;
                this.multiple = null;
                this.manager = null;
                this.times = new Vector<Value>();
                return;
            }
            this.manager = data.getTimeCriterion().values;
            this.manager.addObserver((Observer)this);
            this.all = new Value(ActionsFilterTime.this.getText("filter-all"), new IDGenerator(){

                public int getNextID() {
                    return 0;
                }
            });
            this.multiple = new Value(ActionsFilterTime.this.getText("filter-multiple"), new IDGenerator(){

                public int getNextID() {
                    return 1;
                }
            });
            this.initialise();
        }

        private void initialise() {
            this.times = this.manager.list();
            this.times.add(0, this.all);
            this.times.add(1, this.multiple);
        }

        public Object getElementAt(int index) {
            return this.times.get(index);
        }

        public int getSize() {
            return this.times.size();
        }

        public void update(Observable o, Object arg) {
            this.initialise();
            this.fireContentsChanged(this, 0, this.getSize());
        }
    }
}

