/*
 * Decompiled with CFR 0.152.
 */
package tr.view.actions.screens.fields;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.openide.util.NbBundle;
import tr.model.action.Action;
import tr.view.actions.screens.fields.ActionsFilter;
import tr.view.actions.screens.fields.ActionsFilterComboBox;
import tr.view.actions.screens.fields.MultiChoiceDialog;

public class ActionsFilterStatus
extends ActionsFilter {
    public static final byte ID = 1;
    public static final String KEY = "filter-status";
    protected StatusComboBox combo;

    protected ActionsFilterStatus() {
        super((byte)1);
    }

    public String toString() {
        return this.getText(KEY);
    }

    public void setUsed(boolean used) {
        if (!used && this.combo != null) {
            this.combo.setSelectedItem(null);
        }
        super.setUsed(used);
    }

    public synchronized JComboBox getComboBox() {
        if (this.combo == null) {
            this.combo = new StatusComboBox(new StatusComboBoxModel());
            this.combo.setBackground(Color.white);
        }
        return this.combo;
    }

    public TableCellRenderer getValuesRenderer() {
        return (TableCellRenderer)((Object)this.getComboBox());
    }

    public TableCellEditor getValuesEditor() {
        return new DefaultCellEditor(this.getComboBox());
    }

    public boolean accept(Action action) {
        StatusItem item = (StatusItem)this.getComboBox().getSelectedItem();
        if (item == null) {
            return true;
        }
        switch (item) {
            case ALL: {
                return true;
            }
            case MULTIPLE: {
                return this.isStateInMultiple(action);
            }
            case DELEGATED: {
                return action.isStateDelegated();
            }
            case DO_ASAP: {
                return action.isStateASAP();
            }
            case INACTIVE: {
                return action.isStateInactive();
            }
            case SCHEDULED: {
                return action.isStateScheduled();
            }
        }
        return false;
    }

    private boolean isStateInMultiple(Action action) {
        if (this.combo == null) {
            return false;
        }
        if (action.isStateASAP()) {
            return this.combo.chosen.contains(StatusItem.DO_ASAP);
        }
        if (action.isStateScheduled()) {
            return this.combo.chosen.contains(StatusItem.SCHEDULED);
        }
        if (action.isStateDelegated()) {
            return this.combo.chosen.contains(StatusItem.DELEGATED);
        }
        if (action.isStateInactive()) {
            return this.combo.chosen.contains(StatusItem.INACTIVE);
        }
        return false;
    }

    public boolean acceptAll() {
        StatusItem item = (StatusItem)this.getComboBox().getSelectedItem();
        return item == null || item == StatusItem.ALL;
    }

    public String[] getSerialValues() {
        StatusItem item = (StatusItem)this.getComboBox().getSelectedItem();
        if (item == null) {
            return null;
        }
        if (item == StatusItem.MULTIPLE) {
            if (this.combo == null || this.combo.chosen == null) {
                return null;
            }
            String[] values = new String[this.combo.chosen.size()];
            for (int i = 0; i < values.length; ++i) {
                values[i] = this.combo.chosen.get(i).toID();
            }
            return values;
        }
        return new String[]{item.toID()};
    }

    public void setSerialValues(String[] values) {
        this.getComboBox();
        this.combo.stopChangeEvents();
        if (values == null || values.length == 0) {
            this.getComboBox().setSelectedItem(null);
        } else if (values.length == 1) {
            this.getComboBox().setSelectedItem(StatusItem.fromID(values[0]));
        } else if (values.length > 1) {
            this.getComboBox().setSelectedItem(StatusItem.MULTIPLE);
            this.combo.chosen = new Vector();
            for (String id : values) {
                this.combo.chosen.add(StatusItem.fromID(id));
            }
        }
        this.combo.startChangeEvents();
    }

    public class StatusComboBox
    extends ActionsFilterComboBox
    implements TableCellRenderer {
        private ActionListener listener;
        public Vector<StatusItem> chosen;

        public StatusComboBox(StatusComboBoxModel model) {
            super((ComboBoxModel)model);
            this.listener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (StatusComboBox.this.getSelectedItem() == StatusItem.MULTIPLE) {
                        Vector<StatusItem> all = new Vector<StatusItem>();
                        all.add(StatusItem.DO_ASAP);
                        all.add(StatusItem.DELEGATED);
                        all.add(StatusItem.INACTIVE);
                        all.add(StatusItem.SCHEDULED);
                        if (StatusComboBox.this.chosen == null) {
                            StatusComboBox.this.chosen = new Vector();
                        }
                        MultiChoiceDialog<StatusItem> d = new MultiChoiceDialog<StatusItem>(StatusComboBox.this, all, StatusComboBox.this.chosen);
                        d.setTitle(ActionsFilterStatus.this.getText(ActionsFilterStatus.KEY));
                        d.setLocationRelativeTo(StatusComboBox.this);
                        d.setVisible(true);
                        if (d.isOkay()) {
                            StatusComboBox.this.chosen = d.getChosen();
                        }
                    }
                    StatusComboBox.this.firePropertyChange("filter-value", null, null);
                }
            };
            this.setPreferredSize(new Dimension(120, 24));
            this.addActionListener(this.listener);
        }

        protected void stopChangeEvents() {
            this.removeActionListener(this.listener);
        }

        protected void startChangeEvents() {
            this.addActionListener(this.listener);
        }
    }

    public class StatusComboBoxModel
    extends DefaultComboBoxModel {
        private StatusItem[] items = new StatusItem[]{StatusItem.ALL, StatusItem.MULTIPLE, StatusItem.DELEGATED, StatusItem.DO_ASAP, StatusItem.INACTIVE, StatusItem.SCHEDULED};

        public Object getElementAt(int index) {
            return this.items[index];
        }

        public int getSize() {
            return this.items.length;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StatusItem implements Comparable<StatusItem>
    {
        ALL,
        MULTIPLE,
        DELEGATED,
        DO_ASAP,
        INACTIVE,
        SCHEDULED;


        public String toString() {
            switch (this) {
                case ALL: {
                    return NbBundle.getMessage(this.getClass(), (String)"filter-all");
                }
                case MULTIPLE: {
                    return NbBundle.getMessage(this.getClass(), (String)"filter-multiple");
                }
                case DO_ASAP: {
                    return NbBundle.getMessage(this.getClass(), (String)"filter-status-doasap");
                }
                case DELEGATED: {
                    return NbBundle.getMessage(this.getClass(), (String)"filter-status-delegated");
                }
                case INACTIVE: {
                    return NbBundle.getMessage(this.getClass(), (String)"filter-status-inactive");
                }
                case SCHEDULED: {
                    return NbBundle.getMessage(this.getClass(), (String)"filter-status-scheduled");
                }
            }
            return "";
        }

        public String toID() {
            switch (this) {
                case ALL: {
                    return "0";
                }
                case MULTIPLE: {
                    return "1";
                }
                case DELEGATED: {
                    return "2";
                }
                case DO_ASAP: {
                    return "3";
                }
                case INACTIVE: {
                    return "4";
                }
                case SCHEDULED: {
                    return "5";
                }
            }
            return "0";
        }

        public static StatusItem fromID(String sid) {
            int id = Integer.parseInt(sid);
            switch (id) {
                case 0: {
                    return ALL;
                }
                case 1: {
                    return MULTIPLE;
                }
                case 2: {
                    return DELEGATED;
                }
                case 3: {
                    return DO_ASAP;
                }
                case 4: {
                    return INACTIVE;
                }
                case 5: {
                    return SCHEDULED;
                }
            }
            return ALL;
        }
    }
}

