/*
 * Decompiled with CFR 0.152.
 */
package tr.view.actions.screens.fields;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.openide.util.NbBundle;
import tr.model.action.Action;
import tr.view.actions.screens.fields.ActionsFilter;
import tr.view.actions.screens.fields.ActionsFilterComboBox;

public class ActionsFilterDone
extends ActionsFilter {
    public static final byte ID = 0;
    public static final String KEY = "filter-done";
    private DoneComboBox combo;

    protected ActionsFilterDone() {
        super((byte)0);
    }

    public String toString() {
        return this.getText(KEY);
    }

    public void setUsed(boolean used) {
        if (!used && this.combo != null) {
            this.combo.setSelectedItem(null);
        }
        super.setUsed(used);
    }

    public JComboBox getComboBox() {
        if (this.combo == null) {
            this.combo = new DoneComboBox(new DoneComboBoxModel());
            this.combo.setBackground(Color.white);
        }
        return this.combo;
    }

    public TableCellRenderer getValuesRenderer() {
        return (TableCellRenderer)((Object)this.getComboBox());
    }

    public TableCellEditor getValuesEditor() {
        return new DefaultCellEditor(this.getComboBox());
    }

    public boolean accept(Action action) {
        DoneItem item = (DoneItem)((Object)this.getComboBox().getSelectedItem());
        if (item == null || item == DoneItem.ALL) {
            return true;
        }
        if (action.isDone()) {
            return item == DoneItem.DONE;
        }
        return item == DoneItem.NOT_DONE;
    }

    public String[] getSerialValues() {
        String[] stringArray;
        DoneItem item = (DoneItem)((Object)this.getComboBox().getSelectedItem());
        if (item == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = item.toID();
        }
        return stringArray;
    }

    public void setSerialValues(String[] values) {
        this.getComboBox();
        this.combo.stopChangeEvents();
        if (values == null || values.length == 0) {
            this.getComboBox().setSelectedItem(null);
        } else {
            this.getComboBox().setSelectedItem((Object)DoneItem.fromID(values[0]));
        }
        this.combo.startChangeEvents();
    }

    public boolean acceptAll() {
        DoneItem item = (DoneItem)((Object)this.getComboBox().getSelectedItem());
        return item == null || item == DoneItem.ALL;
    }

    public boolean acceptDone() {
        DoneItem item = (DoneItem)((Object)this.getComboBox().getSelectedItem());
        return item == null || item == DoneItem.ALL || item == DoneItem.DONE;
    }

    public boolean acceptToDo() {
        DoneItem item = (DoneItem)((Object)this.getComboBox().getSelectedItem());
        return item == null || item == DoneItem.ALL || item == DoneItem.NOT_DONE;
    }

    public class DoneComboBox
    extends ActionsFilterComboBox
    implements TableCellRenderer {
        private ActionListener listener;

        public DoneComboBox(DoneComboBoxModel model) {
            super((ComboBoxModel)model);
            this.listener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DoneComboBox.this.firePropertyChange("filter-value", null, null);
                }
            };
            this.setPreferredSize(new Dimension(100, 24));
            this.addActionListener(this.listener);
        }

        protected void stopChangeEvents() {
            this.removeActionListener(this.listener);
        }

        protected void startChangeEvents() {
            this.addActionListener(this.listener);
        }
    }

    public class DoneComboBoxModel
    extends DefaultComboBoxModel {
        private DoneItem[] items = new DoneItem[]{DoneItem.ALL, DoneItem.DONE, DoneItem.NOT_DONE};

        public Object getElementAt(int index) {
            return this.items[index];
        }

        public int getSize() {
            return this.items.length;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DoneItem {
        ALL,
        DONE,
        NOT_DONE;


        public String toString() {
            switch (this) {
                case ALL: {
                    return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"filter-all");
                }
                case DONE: {
                    return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"filter-done-done");
                }
                case NOT_DONE: {
                    return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"filter-done-not-done");
                }
            }
            return "";
        }

        public String toID() {
            switch (this) {
                case ALL: {
                    return "0";
                }
                case DONE: {
                    return "1";
                }
                case NOT_DONE: {
                    return "2";
                }
            }
            return "0";
        }

        public static DoneItem fromID(String sid) {
            int id = Integer.parseInt(sid);
            switch (id) {
                case 0: {
                    return ALL;
                }
                case 1: {
                    return DONE;
                }
                case 2: {
                    return NOT_DONE;
                }
            }
            return ALL;
        }
    }
}

