/*
 * Decompiled with CFR 0.152.
 */
package tr.view.actions.screens.fields;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import tr.model.Data;
import tr.model.DataLookup;
import tr.model.action.Action;
import tr.model.context.Context;
import tr.model.util.Manager;
import tr.util.Observable;
import tr.util.Observer;
import tr.view.actions.screens.fields.ActionsFilter;
import tr.view.actions.screens.fields.ActionsFilterComboBox;
import tr.view.actions.screens.fields.MultiChoiceDialog;

public class ActionsFilterContext
extends ActionsFilter {
    public static final byte ID = 2;
    public static final String KEY = "filter-context";
    public static final String ALL = "all";
    public static final String MULTIPLE = "multiple";
    protected ContextsComboBox combo;

    protected ActionsFilterContext() {
        super((byte)2);
    }

    public String toString() {
        return this.getText(KEY);
    }

    public void setUsed(boolean used) {
        if (!used && this.combo != null) {
            this.combo.setSelectedItem(null);
        }
        super.setUsed(used);
    }

    public synchronized JComboBox getComboBox() {
        if (this.combo == null) {
            this.combo = new ContextsComboBox(new ContextsComboBoxModel());
            this.combo.setBackground(Color.white);
        }
        return this.combo;
    }

    public TableCellRenderer getValuesRenderer() {
        return (TableCellRenderer)((Object)this.getComboBox());
    }

    public TableCellEditor getValuesEditor() {
        return new DefaultCellEditor(this.getComboBox());
    }

    public boolean accept(Action action) {
        Context context = (Context)this.getComboBox().getSelectedItem();
        if (context == null || context.key != null && context.key.equals(ALL)) {
            return true;
        }
        if (context.key != null && context.key.equals(MULTIPLE)) {
            return this.combo.chosen.contains(action.getContext());
        }
        return context.equals((Object)action.getContext());
    }

    public boolean acceptAll() {
        Context context = (Context)this.getComboBox().getSelectedItem();
        return context == null || context.key != null && context.key.equals(ALL);
    }

    public String[] getSerialValues() {
        Context context = (Context)this.getComboBox().getSelectedItem();
        if (context == null) {
            return null;
        }
        if (context.key != null && context.key.equals(ALL)) {
            return new String[]{ALL};
        }
        if (context.key != null && context.key.equals(MULTIPLE)) {
            if (this.combo == null || this.combo.chosen == null) {
                return null;
            }
            String[] values = new String[this.combo.chosen.size()];
            for (int i = 0; i < values.length; ++i) {
                values[i] = this.combo.chosen.get(i).getName();
            }
            return values;
        }
        return new String[]{context.getName()};
    }

    public void setSerialValues(String[] values) {
        this.getComboBox();
        this.combo.stopChangeEvents();
        if (values == null || values.length == 0) {
            this.combo.setSelectedItem(null);
        } else if (values.length == 1) {
            if (values[0].equals(ALL)) {
                this.combo.setSelectedIndex(0);
            } else {
                this.combo.setSelectedItem(this.getContext(values[0]));
            }
        } else if (values.length > 1) {
            this.combo.setSelectedIndex(1);
            this.combo.chosen = new Vector();
            for (String name : values) {
                this.combo.chosen.add(this.getContext(name));
            }
        }
        this.combo.startChangeEvents();
    }

    private Context getContext(String name) {
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        Manager contextManager = data.getContextManager();
        for (Context context : contextManager.list()) {
            if (!context.getName().equals(name)) continue;
            return context;
        }
        return null;
    }

    public class ContextsComboBox
    extends ActionsFilterComboBox
    implements TableCellRenderer {
        private ActionListener listener;
        public Vector<Context> chosen;

        public ContextsComboBox(ContextsComboBoxModel model) {
            super((ComboBoxModel)model);
            this.listener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Context c = (Context)ContextsComboBox.this.getSelectedItem();
                    if (c != null && c.key != null && c.key.equals(ActionsFilterContext.MULTIPLE)) {
                        Data data = (Data)DataLookup.instance().lookup(Data.class);
                        Vector all = data == null ? new Vector() : data.getContextManager().list();
                        if (ContextsComboBox.this.chosen == null) {
                            ContextsComboBox.this.chosen = new Vector();
                        }
                        MultiChoiceDialog<Context> d = new MultiChoiceDialog<Context>(ContextsComboBox.this, all, ContextsComboBox.this.chosen);
                        d.setTitle(ActionsFilterContext.this.getText(ActionsFilterContext.KEY));
                        d.setLocationRelativeTo(ContextsComboBox.this);
                        d.setVisible(true);
                        if (d.isOkay()) {
                            ContextsComboBox.this.chosen = d.getChosen();
                        }
                    }
                    ContextsComboBox.this.firePropertyChange("filter-value", null, null);
                }
            };
            this.setPreferredSize(new Dimension(120, 24));
            this.addActionListener(this.listener);
        }

        protected void stopChangeEvents() {
            this.removeActionListener(this.listener);
        }

        protected void startChangeEvents() {
            this.addActionListener(this.listener);
        }
    }

    public class ContextsComboBoxModel
    extends DefaultComboBoxModel
    implements Observer {
        private final Context all = new Context();
        private final Context multiple;
        private Manager<Context> manager;
        private List<Context> contexts;
        private Lookup.Result result;

        public ContextsComboBoxModel() {
            this.all.setName(ActionsFilterContext.this.getText("filter-all"));
            this.all.key = ActionsFilterContext.ALL;
            this.multiple = new Context();
            this.multiple.setName(ActionsFilterContext.this.getText("filter-multiple"));
            this.multiple.key = ActionsFilterContext.MULTIPLE;
            this.initialise();
        }

        private void initialise() {
            Data data;
            if (this.manager != null) {
                this.manager.removeObserver((Observer)this);
            }
            if ((data = (Data)DataLookup.instance().lookup(Data.class)) == null) {
                this.manager = null;
                this.contexts = new Vector<Context>();
            } else {
                this.manager = data.getContextManager();
                this.manager.addObserver((Observer)this);
                this.contexts = this.manager.list();
                Collections.sort(this.contexts);
            }
            this.contexts.add(0, this.all);
            this.contexts.add(1, this.multiple);
            if (this.result == null) {
                this.result = DataLookup.instance().lookup(new Lookup.Template(Data.class));
                this.result.addLookupListener(new LookupListener(){

                    public void resultChanged(LookupEvent lookupEvent) {
                        ContextsComboBoxModel.this.update(null, null);
                    }
                });
            }
        }

        public Object getElementAt(int index) {
            return this.contexts.get(index);
        }

        public int getSize() {
            return this.contexts.size();
        }

        public void update(Observable o, Object arg) {
            this.initialise();
            this.fireContentsChanged(this, 0, this.getSize());
        }
    }
}

