/*
 * Decompiled with CFR 0.152.
 */
package tr.view.actions.screens;

import java.awt.BorderLayout;
import java.awt.EventQueue;
import java.util.Collections;
import java.util.logging.Logger;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import tr.model.Data;
import tr.model.DataLookup;
import tr.view.Window;
import tr.view.actions.Resources;
import tr.view.actions.screens.ItemCountShower;
import tr.view.actions.screens.ReviewActionsPanel;
import tr.view.actions.screens.fields.ActionsScreen;

public final class ReviewActionsTopComponent
extends Window
implements ItemCountShower {
    private static final Logger LOG = Logger.getLogger("tr.view.actions");
    private static final String PREFERRED_ID = "ReviewActionsTopComponent";
    private final InstanceContent content = new InstanceContent();
    private transient ReviewActionsPanel panel;
    private transient ActionsScreen screen;
    private transient Lookup lookup;
    private transient Lookup.Result dataLookupResult;

    private ReviewActionsTopComponent(ActionsScreen screen) {
        this.screen = screen;
        this.setName(screen.toString());
        this.setToolTipText(NbBundle.getMessage(ReviewActionsTopComponent.class, (String)"TTT_ReviewActionsTopComponent"));
        this.setIcon(Resources.ICON_ACTIONS.getImage());
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public static synchronized ReviewActionsTopComponent createInstance(ActionsScreen screen) {
        return new ReviewActionsTopComponent(screen);
    }

    public int getPersistenceType() {
        return 2;
    }

    protected void componentOpened() {
        if (this.panel == null) {
            this.removeAll();
            this.panel = new ReviewActionsPanel(this.screen, this);
            this.add(this.panel, "Center");
        }
        if (this.dataLookupResult == null) {
            this.dataLookupResult = DataLookup.instance().lookup(new Lookup.Template(Data.class));
            this.dataLookupResult.addLookupListener(new LookupListener(){

                public void resultChanged(LookupEvent lookupEvent) {
                    ReviewActionsTopComponent.this.removeAll();
                    if (ReviewActionsTopComponent.this.panel != null) {
                        ReviewActionsTopComponent.this.panel.save();
                        ReviewActionsTopComponent.this.panel = null;
                    }
                }
            });
        }
        super.componentOpened();
    }

    protected void componentActivated() {
        super.componentActivated();
        if (this.panel != null) {
            this.panel.viewRow();
        }
    }

    protected void componentClosed() {
        this.removeAll();
        if (this.panel != null) {
            this.panel.save();
        }
        super.componentClosed();
    }

    public String preferredID() {
        return PREFERRED_ID;
    }

    public Lookup getLookup() {
        if (this.panel == null) {
            return super.getLookup();
        }
        if (this.lookup == null) {
            this.lookup = new AbstractLookup((AbstractLookup.Content)this.content);
            this.content.set(Collections.singleton(this.panel), null);
        }
        return this.lookup;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("tr.view.actions");
    }

    public void showItemCount(final int count) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ReviewActionsTopComponent.this.setName(ReviewActionsTopComponent.this.screen.toString() + " (" + count + ")");
            }
        });
    }
}

