/*
 * Decompiled with CFR 0.152.
 */
package tr.view.actions.screens;

import java.awt.Color;
import java.awt.Component;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import tr.global.Constants;
import tr.model.Data;
import tr.model.Item.Item;
import tr.model.action.Action;
import tr.model.action.ActionState;
import tr.model.action.ActionStateDelegated;
import tr.model.action.ActionStateScheduled;
import tr.model.project.Project;
import tr.model.thought.Thought;
import tr.model.topic.Topic;
import tr.swing.StyledDate;
import tr.swing.StyledString;
import tr.util.DateUtils;
import tr.util.Observable;
import tr.util.Observer;
import tr.view.actions.Resources;
import tr.view.actions.screens.FiltersActionSelector;
import tr.view.actions.screens.fields.ActionsField;
import tr.view.actions.screens.fields.ActionsScreen;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReviewActionsTableModel
extends AbstractTableModel {
    private Observer dataObserver;
    private Observer selectorObserver;
    private static final Logger LOG = Logger.getLogger("tr.view.actions");
    private final ActionsScreen screen;
    private final Data data;
    private final Project rootProject;
    private final Project rootActions;
    private FiltersActionSelector selector;
    private List<ActionsField> colData;
    private List<RowData> rowData;
    public TableCellRenderer iconHeaderRenderer = new DefaultTableCellRenderer(){

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JTableHeader header;
            if (table != null && (header = table.getTableHeader()) != null) {
                this.setForeground(header.getForeground());
                this.setBackground(header.getBackground());
                this.setFont(header.getFont());
            }
            if (value instanceof Icon) {
                this.setIcon((Icon)value);
                this.setText("");
            } else {
                this.setIcon(null);
                this.setText("");
            }
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.setHorizontalAlignment(2);
            return this;
        }
    };

    public ReviewActionsTableModel(ActionsScreen screen, Data data, FiltersActionSelector selector) {
        this.screen = screen;
        this.data = data;
        this.selector = selector;
        this.rootProject = data.getRootProjects();
        this.rootActions = data.getRootActions();
        this.initColData();
        this.initRowData();
    }

    public void addListeners() {
        this.dataObserver = new Observer(){

            public void update(Observable o, Object arg) {
                LOG.fine("Data changed.");
                ReviewActionsTableModel.this.initRowData();
            }
        };
        this.data.addObserver(this.dataObserver);
        this.selectorObserver = new Observer(){

            public void update(Observable o, Object arg) {
                LOG.fine("Selector changed.");
                ReviewActionsTableModel.this.initRowData();
            }
        };
        this.selector.addObserver(this.selectorObserver);
    }

    public void removeListeners() {
        this.data.removeObserver(this.dataObserver);
        this.selector.removeObserver(this.selectorObserver);
    }

    public synchronized void initColData() {
        Vector<ActionsField> newColData = new Vector<ActionsField>();
        for (ActionsField field : this.screen.getFields().list()) {
            newColData.add(field);
        }
        this.colData = newColData;
    }

    private void initRowData(List<RowData> rowdata, Project project, Action action) {
        if (this.selector.isSelected(action)) {
            rowdata.add(new RowData(project, action));
        }
    }

    private void initRowData(List<RowData> rowdata, Project project) {
        Iterator iterator = project.iterator(Item.class);
        while (iterator.hasNext()) {
            Item item = (Item)iterator.next();
            if (item instanceof Action) {
                this.initRowData(rowdata, project, (Action)item);
                continue;
            }
            if (!(item instanceof Project)) continue;
            this.initRowData(rowdata, (Project)item);
        }
    }

    public synchronized void initRowData() {
        this.selector.prime();
        Vector<RowData> newRowData = new Vector<RowData>();
        this.initRowData(newRowData, this.rootActions);
        this.initRowData(newRowData, this.rootProject);
        this.rowData = newRowData;
        this.fireTableDataChanged();
    }

    public boolean isShowAll() {
        return this.screen.isShowAll();
    }

    public boolean isShowDone() {
        return this.screen.isShowDone();
    }

    public boolean isShowToDo() {
        return this.screen.isShowToDo();
    }

    public void setSelector(FiltersActionSelector selector) {
        this.selector = selector;
    }

    public TableCellRenderer getTableCellRenderer(int column) {
        return this.colData.get(column).getRenderer();
    }

    public int getMaximumWidth(int column) {
        return this.colData.get(column).getMaximumWidth();
    }

    public int getMinimumWidth(int column) {
        return this.colData.get(column).getMinimumWidth();
    }

    public int getPreferredWidth(int column) {
        return this.colData.get(column).getPreferredWidth();
    }

    @Override
    public int getColumnCount() {
        return this.colData.size();
    }

    @Override
    public String getColumnName(int column) {
        return this.colData.get(column).getColumnName();
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return this.colData.get(column).getColumnClass();
    }

    @Override
    public int getRowCount() {
        return this.rowData.size();
    }

    private StyledString getStyledString(String s, Action action) {
        Topic t = action.getTopic();
        return this.getStyledString(s, action.isDone(), t.getForeground(), t.getBackground());
    }

    private StyledString getStyledString(String s, boolean d, Topic t) {
        return this.getStyledString(s, d, t.getForeground(), t.getBackground());
    }

    private StyledString getStyledString(String s, boolean d, Color fg, Color bg) {
        StyledString ss = new StyledString();
        ss.setString(s);
        ss.setStrike(d);
        ss.setForeground(fg);
        ss.setBackground(bg);
        return ss;
    }

    private StyledDate getStyledDate(Date date, boolean showTime, Action action) {
        StyledDate sd = new StyledDate(Constants.DATE_FORMAT_FIXED, Constants.DATE_TIME_FORMAT_FIXED);
        sd.setDate(date);
        sd.setShowTime(showTime);
        sd.setStrike(action.isDone());
        sd.setForeground(action.getTopic().getForeground());
        sd.setBackground(action.getTopic().getBackground());
        return sd;
    }

    private StyledDate getStyledDate(Date date, boolean t, boolean d, Color fg, Color bg) {
        StyledDate sd = new StyledDate(Constants.DATE_FORMAT_FIXED, Constants.DATE_TIME_FORMAT_FIXED);
        sd.setDate(date);
        sd.setShowTime(t);
        sd.setStrike(d);
        sd.setForeground(fg);
        sd.setBackground(bg);
        return sd;
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (column >= this.colData.size() || row >= this.rowData.size()) {
            return "";
        }
        Action action = this.rowData.get((int)row).action;
        ActionsField field = this.colData.get(column);
        switch (field.getType()) {
            case 15: {
                if (action.isStateScheduled()) {
                    return this.getStyledDate(null, false, action);
                }
                return this.getStyledDate(action.getStartDate(), false, action);
            }
            case 16: {
                Date date = action.isStateScheduled() ? null : action.getDueDate();
                Color bg = action.getTopic().getBackground();
                Color fg = action.getTopic().getForeground();
                if (date != null) {
                    Date today = Calendar.getInstance().getTime();
                    if (DateUtils.isBeforeDay((Date)date, (Date)today)) {
                        fg = Constants.COLOR_DATE_PAST;
                    } else if (DateUtils.isSameDay((Date)date, (Date)today)) {
                        fg = Constants.COLOR_DATE_TODAY;
                    } else if (DateUtils.isWithinDaysFuture((Date)date, (int)7)) {
                        fg = Constants.COLOR_DATE_WEEK;
                    }
                }
                return this.getStyledDate(date, false, action.isDone(), fg, bg);
            }
            case 6: {
                Date date = null;
                boolean time = false;
                if (action.isStateScheduled()) {
                    time = true;
                    date = ((ActionStateScheduled)action.getState()).getDate();
                } else if (action.isStateDelegated()) {
                    date = ((ActionStateDelegated)action.getState()).getDate();
                }
                Color bg = action.getTopic().getBackground();
                Color fg = action.getTopic().getForeground();
                if (date != null) {
                    Date today = Calendar.getInstance().getTime();
                    if (DateUtils.isBeforeDay((Date)date, (Date)today)) {
                        fg = Constants.COLOR_DATE_PAST;
                    } else if (DateUtils.isSameDay((Date)date, (Date)today)) {
                        fg = Constants.COLOR_DATE_TODAY;
                    } else if (DateUtils.isWithinDaysFuture((Date)date, (int)7)) {
                        fg = Constants.COLOR_DATE_WEEK;
                    }
                }
                return this.getStyledDate(date, time, action.isDone(), fg, bg);
            }
            case 7: {
                return this.getStyledString(action.getContext().toString(), action);
            }
            case 4: {
                return this.getStyledDate(action.getCreated(), false, action);
            }
            case 3: {
                ActionState state = action.getState();
                String s = action.isStateDelegated() ? ((ActionStateDelegated)state).getTo() : "";
                return this.getStyledString(s, action);
            }
            case 2: {
                return this.getStyledString(action.getDescription(), action);
            }
            case 1: {
                return new Boolean(action.isDone());
            }
            case 5: {
                return this.getStyledDate(action.getDoneDate(), false, action);
            }
            case 9: {
                return this.getStyledString(action.getEnergy() == null ? "" : action.getEnergy().toString(), action);
            }
            case 13: {
                if (action.isSingleAction()) {
                    Thought thought = action.getThought();
                    if (thought != null) {
                        return this.getStyledString(thought.getDescription(), action.isDone(), thought.getTopic());
                    }
                    return this.getStyledString("", action.isDone(), action.getTopic());
                }
                Project project = this.rowData.get((int)row).project;
                if (project != null) {
                    return this.getStyledString(project.getDescription(), project.isDone(), project.getTopic());
                }
                return this.getStyledString("", project.isDone(), project.getTopic());
            }
            case 12: {
                if (action.isSingleAction()) {
                    Thought thought = action.getThought();
                    return thought == null ? null : Resources.ICON_THOUGHT;
                }
                Project project = this.rowData.get((int)row).project;
                return project == null ? null : Resources.ICON_PROJECT;
            }
            case 14: {
                if (action.isSingleAction()) {
                    Thought thought = action.getThought();
                    if (thought != null) {
                        return this.getStyledString(thought.getTopic().toString(), action.isDone(), thought.getTopic());
                    }
                    return this.getStyledString("", action.isDone(), action.getTopic());
                }
                Project project = this.rowData.get((int)row).project;
                if (project != null) {
                    return this.getStyledString(project.getTopic().toString(), project.isDone(), project.getTopic());
                }
                return this.getStyledString("", project.isDone(), project.getTopic());
            }
            case 0: {
                return action.getIcon(false);
            }
            case 10: {
                return this.getStyledString(action.getPriority() == null ? "" : action.getPriority().toString(), action);
            }
            case 8: {
                return this.getStyledString(action.getTime() == null ? "" : action.getTime().toString(), action);
            }
            case 11: {
                return this.getStyledString(action.getTopic().toString(), action);
            }
        }
        return "";
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        if (this.colData.get(column).getType() == 1) {
            Action action = this.rowData.get((int)row).action;
            action.setDone(((Boolean)value).booleanValue());
        }
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return this.colData.get(column).getType() == 1;
    }

    public RowData getRowDataAt(int row) {
        return this.rowData.get(row);
    }

    public TableCellRenderer getHeaderRenderer(int col) {
        if (this.colData.get(col).getType() == 1) {
            return this.iconHeaderRenderer;
        }
        return null;
    }

    public Object getHeaderValue(int col) {
        if (this.colData.get(col).getType() == 1) {
            return tr.view.Resources.ICON_TICKBOX;
        }
        return null;
    }

    public final class RowData {
        public Project project;
        public Action action;

        public RowData(Project project, Action action) {
            this.project = project;
            this.action = action;
        }
    }
}

