/*
 * Decompiled with CFR 0.152.
 */
package tr.view.actions.screens;

import java.util.logging.Logger;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.openide.util.NbBundle;
import tr.util.Observable;
import tr.util.Observer;
import tr.view.actions.screens.fields.ActionsFilter;
import tr.view.actions.screens.fields.ActionsScreen;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FiltersTableModel
extends AbstractTableModel
implements Observer {
    private static final Logger LOG = Logger.getLogger("tr.view.actions");
    private static final int[] maxwidths = new int[]{150, 40, 48, -1};
    private static final int[] minwidths = new int[]{150, 40, 48, -1};
    private static final int[] prewidths = new int[]{150, 40, 48, -1};
    private static final Class[] classes = new Class[]{String.class, Boolean.class, Boolean.class, Object.class};
    private static final TableCellRenderer[] renderers = new TableCellRenderer[]{null, null, null, null};
    private static final String[] headings = new String[]{FiltersTableModel.getText("FiltersDialog.column.name"), FiltersTableModel.getText("FiltersDialog.column.used"), FiltersTableModel.getText("FiltersDialog.column.visible"), FiltersTableModel.getText("FiltersDialog.column.values")};
    private static final byte COLUMN_NAME = 0;
    private static final byte COLUMN_USED = 1;
    private static final byte COLUMN_SHOW = 2;
    private static final byte COLUMN_VALS = 3;
    private final ActionsScreen screen;

    public FiltersTableModel(ActionsScreen screen) {
        this.screen = screen;
        this.screen.addObserver(this);
    }

    public TableCellRenderer getCellRenderer(int column) {
        return renderers[column];
    }

    public TableCellRenderer getCellRenderer(int row, int col) {
        if (col == 3) {
            return ((ActionsFilter)this.screen.getFilters().get(row)).getValuesRenderer();
        }
        return null;
    }

    public TableCellEditor getCellEditor(int row, int col) {
        if (col == 3) {
            return ((ActionsFilter)this.screen.getFilters().get(row)).getValuesEditor();
        }
        return null;
    }

    public int getMaximumWidth(int column) {
        return maxwidths[column];
    }

    public int getMinimumWidth(int column) {
        return minwidths[column];
    }

    public int getPreferredWidth(int column) {
        return prewidths[column];
    }

    @Override
    public int getColumnCount() {
        return classes.length;
    }

    @Override
    public String getColumnName(int column) {
        return headings[column];
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return classes[column];
    }

    @Override
    public int getRowCount() {
        return this.screen.getFilters().size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        ActionsFilter filter = (ActionsFilter)this.screen.getFilters().get(row);
        switch (column) {
            case 0: {
                return filter.toString();
            }
            case 1: {
                return filter.isUsed();
            }
            case 2: {
                return filter.isVisible();
            }
            case 3: {
                return filter.getValueAt();
            }
        }
        return "";
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        ActionsFilter filter = (ActionsFilter)this.screen.getFilters().get(row);
        switch (column) {
            case 0: {
                return;
            }
            case 1: {
                filter.setUsed((Boolean)value);
                this.fireTableDataChanged();
                return;
            }
            case 2: {
                filter.setVisible((Boolean)value);
                this.fireTableDataChanged();
                return;
            }
            case 3: {
                this.fireTableDataChanged();
                return;
            }
        }
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        ActionsFilter filter = (ActionsFilter)this.screen.getFilters().get(row);
        switch (column) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
            case 2: {
                return filter.isUsed();
            }
            case 3: {
                return filter.isUsed();
            }
        }
        return false;
    }

    public void update(Observable o, Object arg) {
        this.fireTableDataChanged();
    }

    private static String getText(String key) {
        return NbBundle.getMessage(FiltersTableModel.class, (String)key);
    }
}

