/*
 * Decompiled with CFR 0.152.
 */
package tr.view.actions.prefs;

import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class ActionsPrefs {
    private static final Logger LOG = Logger.getLogger("tr.view.actions.prefs");
    public static final Preferences prefs = Preferences.userRoot().node("ThinkingRock/screens/actions");
    private static final String KEY_REPORT_USE_COLOUR = "report.colour.";
    private static final boolean DEF_REPORT_USE_COLOUR = true;

    public static final boolean isReportUseColour() {
        return prefs.getBoolean(KEY_REPORT_USE_COLOUR, true);
    }

    public static final void setReportUseColour(boolean value) {
        prefs.putBoolean(KEY_REPORT_USE_COLOUR, value);
        ActionsPrefs.flush();
    }

    private static void flush() {
        try {
            prefs.flush();
        }
        catch (BackingStoreException ex) {
            LOG.severe("Actions preferences error. " + ex.getMessage());
        }
    }
}

