/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.projects;

import java.beans.PropertyVetoException;
import java.io.IOException;
import java.util.Set;
import org.netbeans.core.startup.layers.LocalFileSystemEx;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.MultiFileSystem;

public final class FilterFileSystem
extends MultiFileSystem {
    private final FileObject root;
    private final FileSystem del;

    public FilterFileSystem(FileObject fileObject) throws FileStateInvalidException {
        super(new FileSystem[]{fileObject.getFileSystem()});
        this.root = fileObject;
        this.del = fileObject.getFileSystem();
        try {
            this.setSystemName(this.del.getSystemName() + " : " + fileObject.getPath());
        }
        catch (PropertyVetoException propertyVetoException) {
            ErrorManager.getDefault().notify((Throwable)propertyVetoException);
        }
        this.setPropagateMasks(true);
    }

    public final FileObject getRootFileObject() {
        return this.root;
    }

    protected FileObject findResourceOn(FileSystem fileSystem, String string) {
        return fileSystem.findResource(this.root.getPath() + "/" + string);
    }

    protected Set createLocksOn(String string) throws IOException {
        String string2 = this.root.getPath() + "/" + string;
        LocalFileSystemEx.potentialLock((String)string, (String)string2);
        return super.createLocksOn(string);
    }
}

