/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.io.IOException;
import java.util.Enumeration;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.text.Keymap;
import org.netbeans.core.NbKeymap;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

class ShortcutsFolder {
    private static final String PROFILES_FOLDER = "Keymaps";
    private static final String SHORTCUTS_FOLDER = "Shortcuts";
    private static final String CURRENT_PROFILE_ATTRIBUTE = "currentKeymap";
    private static ShortcutsFolder shortcutsFolder;
    private Listener listener = new Listener();
    private FileObject profilesFileObject;
    private FileObject shortcutsFileObject;
    private FileObject currentFolder;
    private ErrorManager debug = ErrorManager.getDefault().getInstance(ShortcutsFolder.class.getName());
    static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;

    static void initShortcuts() {
        if (shortcutsFolder != null) {
            return;
        }
        shortcutsFolder = new ShortcutsFolder();
    }

    private ShortcutsFolder() {
        try {
            FileObject fileObject = Repository.getDefault().getDefaultFileSystem().getRoot();
            this.profilesFileObject = fileObject.getFileObject(PROFILES_FOLDER);
            if (this.profilesFileObject == null) {
                this.profilesFileObject = fileObject.createFolder(PROFILES_FOLDER);
            }
            this.profilesFileObject.addFileChangeListener((FileChangeListener)this.listener);
            this.shortcutsFileObject = fileObject.getFileObject(SHORTCUTS_FOLDER);
            if (this.shortcutsFileObject == null) {
                this.shortcutsFileObject = fileObject.createFolder(SHORTCUTS_FOLDER);
            }
            this.shortcutsFileObject.addFileChangeListener((FileChangeListener)this.listener);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
        this.refresh();
    }

    static void waitFinished() {
        ShortcutsFolder.shortcutsFolder.listener.task.waitFinished();
    }

    private void refresh() {
        NbKeymap nbKeymap = (NbKeymap)Lookup.getDefault().lookup(Keymap.class);
        nbKeymap.removeBindings();
        this.readShortcuts(nbKeymap, this.shortcutsFileObject);
        String string = (String)this.profilesFileObject.getAttribute(CURRENT_PROFILE_ATTRIBUTE);
        if (string == null || string.equals("")) {
            string = "NetBeans";
        }
        if (this.currentFolder != null) {
            this.currentFolder.removeFileChangeListener((FileChangeListener)this.listener);
        }
        this.currentFolder = Repository.getDefault().getDefaultFileSystem().getRoot().getFileObject("Keymaps/" + string);
        if (this.currentFolder == null) {
            try {
                this.currentFolder = this.profilesFileObject.createFolder(string);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
        if (this.currentFolder != null) {
            this.readShortcuts(nbKeymap, this.currentFolder);
            this.currentFolder.addFileChangeListener((FileChangeListener)this.listener);
        }
    }

    private void readShortcuts(NbKeymap nbKeymap, FileObject fileObject) {
        this.debug.log("\nreadShortcuts " + fileObject);
        DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
        Enumeration enumeration = dataFolder.children(false);
        while (enumeration.hasMoreElements()) {
            InstanceCookie instanceCookie;
            DataObject dataObject = (DataObject)enumeration.nextElement();
            if (dataObject instanceof DataFolder || (instanceCookie = (InstanceCookie)dataObject.getCookie(class$org$openide$cookies$InstanceCookie == null ? ShortcutsFolder.class$("org.openide.cookies.InstanceCookie") : class$org$openide$cookies$InstanceCookie)) == null) continue;
            try {
                Action action = (Action)instanceCookie.instanceCreate();
                String string = dataObject.getName();
                this.debug.log("  " + string + " : " + action);
                KeyStroke[] keyStrokeArray = Utilities.stringToKeys((String)string);
                ShortcutsFolder.addShortcut(nbKeymap, action, keyStrokeArray);
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(1, (Throwable)exception);
            }
        }
    }

    private static void addShortcut(NbKeymap nbKeymap, Action action, KeyStroke[] keyStrokeArray) {
        Keymap keymap = nbKeymap;
        int n = keyStrokeArray.length - 1;
        for (int i = 0; i < n; ++i) {
            Action action2 = keymap.getAction(keyStrokeArray[i]);
            if (action2 == null) {
                action2 = nbKeymap.createMapAction(new NbKeymap.SubKeymap(null), keyStrokeArray[i]);
                keymap.addActionForKeyStroke(keyStrokeArray[i], action2);
            }
            if (!(action2 instanceof NbKeymap.KeymapAction)) {
                return;
            }
            keymap = ((NbKeymap.KeymapAction)action2).getSubMap();
        }
        keymap.addActionForKeyStroke(keyStrokeArray[n], action);
    }

    private static DataFolder getDataFolder(String string) {
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().getRoot();
        if ((fileObject = fileObject.getFileObject(string)) == null) {
            return null;
        }
        return DataFolder.findFolder((FileObject)fileObject);
    }

    private class Listener
    extends FileChangeAdapter
    implements Runnable {
        private RequestProcessor.Task task = new RequestProcessor("ShortcutsFolder").create((Runnable)this);

        private Listener() {
        }

        public void run() {
            ShortcutsFolder.this.refresh();
        }

        public void fileDataCreated(FileEvent fileEvent) {
            this.task.schedule(500);
        }

        public void fileChanged(FileEvent fileEvent) {
            this.task.schedule(500);
        }

        public void fileDeleted(FileEvent fileEvent) {
            this.task.schedule(500);
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
            if (fileAttributeEvent.getName() != null && !fileAttributeEvent.getName().equals(ShortcutsFolder.CURRENT_PROFILE_ATTRIBUTE)) {
                return;
            }
            this.task.schedule(500);
        }
    }
}

