/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.openide.ErrorManager;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.propertysheet.PropertySheet;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAdapter;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeOp;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.io.NbMarshalledObject;
import org.openide.util.io.SafeException;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

public final class NbSheet
extends TopComponent {
    private static final String PROP_LONGER_DISPLAY_NAME = "longerDisplayName";
    static final long serialVersionUID = 7807519514644165460L;
    private static NbSheet sharedSheet;
    private final transient Listener listener;
    private final transient SheetNodesListener snListener;
    boolean global;
    private PropertySheet propertySheet;
    private Node[] nodes = new Node[0];
    private static MessageFormat globalPropertiesFormat;
    private static MessageFormat localPropertiesFormat;

    public NbSheet() {
        this(false);
    }

    public NbSheet(boolean bl) {
        this.global = bl;
        this.propertySheet = new PropertySheet();
        this.putClientProperty("NamingType", "BothOnlyCompName");
        this.setLayout(new BorderLayout());
        this.add((Component)this.propertySheet, "Center");
        this.setIcon(Utilities.loadImage((String)"org/netbeans/core/resources/frames/properties.gif", (boolean)true));
        this.updateTitle();
        this.putClientProperty("SlidingName", NbBundle.getMessage((Class)NbSheet.class, (String)"CTL_PropertiesWindow"));
        this.listener = new Listener();
        this.snListener = new SheetNodesListener();
        this.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)NbSheet.class).getString("ACSN_PropertiesSheet"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)NbSheet.class).getString("ACSD_PropertiesSheet"));
    }

    public static NbSheet findDefault() {
        if (sharedSheet == null) {
            TopComponent topComponent = WindowManager.getDefault().findTopComponent("properties");
            if (topComponent != null) {
                if (topComponent instanceof NbSheet) {
                    sharedSheet = (NbSheet)topComponent;
                } else {
                    IllegalStateException illegalStateException = new IllegalStateException("Incorrect settings file. Unexpected class returned. Expected:" + NbSheet.class.getName() + " Returned:" + topComponent.getClass().getName());
                    ErrorManager.getDefault().notify(1, (Throwable)illegalStateException);
                    NbSheet.getDefault();
                }
            } else {
                NbSheet.getDefault();
            }
        }
        return sharedSheet;
    }

    protected String preferredID() {
        return "properties";
    }

    public static NbSheet getDefault() {
        if (sharedSheet == null) {
            sharedSheet = new NbSheet(true);
        }
        return sharedSheet;
    }

    public int getPersistenceType() {
        return 0;
    }

    public HelpCtx getHelpCtx() {
        return this.global ? ExplorerUtils.getHelpCtx((Node[])this.nodes, (HelpCtx)new HelpCtx(NbSheet.class)) : null;
    }

    public void requestFocus() {
        super.requestFocus();
        this.propertySheet.requestFocus();
    }

    public boolean requestFocusInWindow() {
        super.requestFocusInWindow();
        return this.propertySheet.requestFocusInWindow();
    }

    public void open(Workspace workspace) {
        Workspace workspace2;
        Mode mode;
        if (this.global && (mode = (workspace2 = workspace == null ? WindowManager.getDefault().getCurrentWorkspace() : workspace).findMode((TopComponent)this)) == null) {
            Mode mode2 = workspace2.findMode("properties");
            if (mode2 == null) {
                mode2 = workspace2.createMode("properties", NbBundle.getBundle((Class)NbSheet.class).getString("CTL_PropertiesWindow"), null);
            }
            mode2.dockInto((TopComponent)this);
        }
        super.open(workspace);
        if (this.global) {
            SwingUtilities.invokeLater(this.listener);
        }
    }

    protected void updateTitle() {
        Object[] objectArray;
        Mode mode = WindowManager.getDefault().findMode((TopComponent)this);
        String string = null;
        ArrayList<Node> arrayList = new ArrayList<Node>(Arrays.asList(this.nodes));
        Node node = null;
        if (!arrayList.isEmpty()) {
            node = (Node)arrayList.get(0);
        }
        if (node == null) {
            string = "";
        } else {
            string = node.getDisplayName();
            objectArray = node.getValue(PROP_LONGER_DISPLAY_NAME);
            if (objectArray instanceof String) {
                string = (String)objectArray;
            }
        }
        objectArray = new Object[]{new Integer(arrayList.size()), string};
        if (mode != null && "properties".equals(mode.getName())) {
            if (globalPropertiesFormat == null) {
                globalPropertiesFormat = new MessageFormat(NbBundle.getMessage((Class)NbSheet.class, (String)"CTL_FMT_GlobalProperties"));
            }
            this.setName(globalPropertiesFormat.format(objectArray));
        } else {
            if (localPropertiesFormat == null) {
                localPropertiesFormat = new MessageFormat(NbBundle.getMessage((Class)NbSheet.class, (String)"CTL_FMT_LocalProperties"));
            }
            this.setName(localPropertiesFormat.format(objectArray));
        }
        this.setToolTipText(this.getName());
    }

    public void setNodes(Node[] nodeArray) {
        this.setNodesWithoutReattaching(nodeArray);
        this.snListener.detach();
        this.snListener.attach(nodeArray);
    }

    private void setNodesWithoutReattaching(Node[] nodeArray) {
        this.nodes = nodeArray;
        this.propertySheet.setNodes(nodeArray);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NbSheet.this.updateTitle();
            }
        });
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        if (this.global) {
            objectOutput.writeObject(null);
        } else {
            Node.Handle[] handleArray = NodeOp.toHandles((Node[])this.nodes);
            objectOutput.writeObject(handleArray);
        }
        objectOutput.writeBoolean(this.global);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        try {
            super.readExternal(objectInput);
        }
        catch (SafeException safeException) {
            // empty catch block
        }
        Object object = objectInput.readObject();
        if (object instanceof NbMarshalledObject || object instanceof ExplorerManager) {
            this.global = (Boolean)objectInput.readObject();
        } else {
            Node[] nodeArray;
            if (object == null) {
                nodeArray = TopComponent.getRegistry().getActivatedNodes();
            } else {
                Node.Handle[] handleArray = (Node.Handle[])object;
                try {
                    nodeArray = NodeOp.fromHandles((Node.Handle[])handleArray);
                }
                catch (IOException iOException) {
                    ErrorManager errorManager = ErrorManager.getDefault();
                    errorManager.annotate((Throwable)iOException, NbBundle.getBundle((Class)NbSheet.class).getString("EXC_CannotLoadNodes"));
                    errorManager.notify(1, (Throwable)iOException);
                    nodeArray = new Node[]{};
                }
            }
            this.global = objectInput.readBoolean();
            this.setNodes(nodeArray);
        }
    }

    public Object readResolve() throws ObjectStreamException {
        if (this.global) {
            return NbSheet.getDefault();
        }
        if (this.nodes == null || this.nodes.length <= 0) {
            return null;
        }
        return this;
    }

    protected Object writeReplace() throws ObjectStreamException {
        if (this.global) {
            return new Replacer();
        }
        return super.writeReplace();
    }

    private void updateGlobalListening(boolean bl) {
        if (this.global) {
            if (bl) {
                TopComponent.getRegistry().addPropertyChangeListener((PropertyChangeListener)this.listener);
            } else {
                TopComponent.getRegistry().removePropertyChangeListener((PropertyChangeListener)this.listener);
            }
        }
    }

    protected void componentOpened() {
        this.updateGlobalListening(true);
    }

    protected void componentClosed() {
        this.updateGlobalListening(false);
    }

    protected void componentDeactivated() {
        super.componentDeactivated();
        if (Utilities.getOperatingSystem() == 4096) {
            this.propertySheet.firePropertyChange("MACOSX", true, false);
        }
    }

    static {
        globalPropertiesFormat = null;
        localPropertiesFormat = null;
    }

    private class Listener
    implements Runnable,
    PropertyChangeListener {
        Listener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("activatedNodes")) {
                this.activate();
            }
        }

        public void run() {
            this.activate();
        }

        public void activate() {
            Node[] nodeArray = TopComponent.getRegistry().getActivatedNodes();
            NbSheet.this.setNodes(nodeArray);
        }
    }

    private static final class Replacer
    implements Serializable {
        static final long serialVersionUID = -7897067133215740572L;

        Replacer() {
        }

        private Object readResolve() throws ObjectStreamException {
            return NbSheet.getDefault();
        }
    }

    private class SheetNodesListener
    extends NodeAdapter
    implements Runnable {
        private HashMap listenerMap;
        private HashMap pListenerMap;

        SheetNodesListener() {
        }

        public void nodeDestroyed(NodeEvent nodeEvent) {
            Node node = nodeEvent.getNode();
            NodeListener nodeListener = (NodeListener)this.listenerMap.get(node);
            PropertyChangeListener propertyChangeListener = (PropertyChangeListener)this.pListenerMap.get(node);
            node.removeNodeListener(nodeListener);
            node.removePropertyChangeListener(propertyChangeListener);
            this.listenerMap.remove(node);
            this.pListenerMap.remove(node);
            if (this.listenerMap.isEmpty() && !NbSheet.this.global) {
                NbSheet.this.setCloseOperation(0);
                Mutex.EVENT.readAccess(new Runnable(){

                    public void run() {
                        NbSheet.this.close();
                    }
                });
            } else {
                NbSheet.this.setNodesWithoutReattaching(this.listenerMap.keySet().toArray(new Node[this.listenerMap.size()]));
            }
        }

        public void attach(Node[] nodeArray) {
            this.listenerMap = new HashMap(nodeArray.length * 2);
            this.pListenerMap = new HashMap(nodeArray.length * 2);
            NodeListener nodeListener = null;
            PropertyChangeListener propertyChangeListener = null;
            for (int i = 0; i < nodeArray.length; ++i) {
                nodeListener = NodeOp.weakNodeListener((NodeListener)this, (Object)nodeArray[i]);
                propertyChangeListener = WeakListeners.propertyChange((PropertyChangeListener)((Object)this), (Object)nodeArray[i]);
                this.listenerMap.put(nodeArray[i], nodeListener);
                this.pListenerMap.put(nodeArray[i], propertyChangeListener);
                nodeArray[i].addNodeListener(nodeListener);
                nodeArray[i].addPropertyChangeListener(propertyChangeListener);
            }
        }

        public void detach() {
            Map.Entry entry;
            if (this.listenerMap == null) {
                return;
            }
            Iterator iterator = this.listenerMap.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                ((Node)entry.getKey()).removeNodeListener((NodeListener)entry.getValue());
            }
            iterator = this.pListenerMap.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                ((Node)entry.getKey()).removePropertyChangeListener((PropertyChangeListener)entry.getValue());
            }
            this.listenerMap = null;
            this.pListenerMap = null;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("displayName".equals(propertyChangeEvent.getPropertyName())) {
                SwingUtilities.invokeLater(this);
            }
        }

        public void run() {
            NbSheet.this.updateTitle();
        }
    }
}

