/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectStreamException;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.beaninfo.ExplorerPanel;
import org.netbeans.core.IDESettings;
import org.netbeans.core.NbPlaces;
import org.openide.ErrorManager;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.TreeView;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeOp;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

public final class NbMainExplorer
extends CloneableTopComponent {
    static final long serialVersionUID = 6021472310669753679L;
    private List prevRoots;
    private Map rootsToTCs;
    private transient RootsListener rootsListener = new RootsListener();
    public static final int MIN_HEIGHT = 150;
    public static final int DEFAULT_WIDTH = 350;
    private static Map moduleTabs;
    private static NbMainExplorer explorer;
    static /* synthetic */ Class class$org$netbeans$core$IDESettings;
    static /* synthetic */ Class class$org$netbeans$core$EnvironmentNode;

    public NbMainExplorer() {
        NbPlaces nbPlaces = NbPlaces.getDefault();
        nbPlaces.addChangeListener(WeakListeners.change((ChangeListener)this.rootsListener, (Object)nbPlaces));
        this.refreshRoots();
    }

    public HelpCtx getHelpCtx() {
        return ExplorerUtils.getHelpCtx((Node[])this.getActivatedNodes(), (HelpCtx)new HelpCtx(NbMainExplorer.class));
    }

    private static synchronized ModuleTab findModuleTab(Node node, ModuleTab moduleTab) {
        ModuleTab moduleTab2;
        if (moduleTabs == null) {
            moduleTabs = new WeakHashMap(5);
        }
        if ((moduleTab2 = (ModuleTab)((Object)moduleTabs.get(node))) != null) {
            return moduleTab2;
        }
        if (moduleTab != null) {
            moduleTabs.put(node, moduleTab);
            return moduleTab;
        }
        ModuleTab moduleTab3 = new ModuleTab();
        moduleTabs.put(node, moduleTab3);
        return moduleTab3;
    }

    public void open(Workspace workspace) {
        this.doOpen(workspace);
    }

    private void doOpen(Workspace workspace) {
        if (workspace == null) {
            this.refreshRoots();
        } else {
            super.open(workspace);
            this.close(workspace);
            NbMainExplorer nbMainExplorer = NbMainExplorer.getExplorer();
            nbMainExplorer.openRoots(workspace);
        }
    }

    public void openRoots() {
        this.openRoots(WindowManager.getDefault().getCurrentWorkspace());
    }

    public void openRoots(Workspace workspace) {
        ExplorerTab explorerTab = MainTab.lastActivated;
        this.refreshRoots();
        Node[] nodeArray = NbMainExplorer.getRoots().toArray(new Node[0]);
        ExplorerTab explorerTab2 = null;
        for (int i = 0; i < nodeArray.length; ++i) {
            explorerTab2 = this.getRootPanel(nodeArray[i]);
            if (explorerTab2 == null) continue;
            explorerTab2.open(workspace);
        }
        if (explorerTab == null) {
            explorerTab = this.getRootPanel(nodeArray[0]);
        }
        if (SwingUtilities.isEventDispatchThread()) {
            Mode mode;
            if (explorerTab != null && (mode = workspace.findMode((TopComponent)explorerTab)) != null) {
                explorerTab.requestActive();
            }
        } else if (explorerTab != null) {
            final MainTab mainTab = explorerTab;
            final Workspace workspace2 = workspace;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Mode mode = workspace2.findMode((TopComponent)mainTab);
                    if (mode != null) {
                        mainTab.requestActive();
                    }
                }
            });
        }
    }

    final void refreshRoots() {
        Object object;
        Node node;
        Iterator iterator;
        Collection collection;
        List list = NbMainExplorer.getRoots();
        if (this.prevRoots != null) {
            collection = new HashSet(this.prevRoots);
            ((AbstractSet)collection).removeAll(list);
            iterator = this.rootsToTCs.entrySet().iterator();
            while (iterator.hasNext()) {
                node = iterator.next();
                object = (Node)node.getKey();
                if (!((HashSet)collection).contains(object)) continue;
                NbMainExplorer.closeEverywhere((TopComponent)node.getValue());
            }
        } else {
            this.prevRoots();
        }
        collection = NbMainExplorer.whereOpened(this.rootsToTCs().values().toArray(new TopComponent[0]));
        iterator = list.iterator();
        while (iterator.hasNext()) {
            node = (Node)iterator.next();
            object = this.getRootPanel(node);
            if (object != null) continue;
            object = this.createTC(node, false);
            Iterator iterator2 = collection.iterator();
            while (iterator2.hasNext()) {
                object.open((Workspace)iterator2.next());
            }
        }
        this.prevRoots = list;
    }

    private static void closeEverywhere(TopComponent topComponent) {
        Workspace[] workspaceArray = WindowManager.getDefault().getWorkspaces();
        for (int i = 0; i < workspaceArray.length; ++i) {
            if (!topComponent.isOpened(workspaceArray[i])) continue;
            topComponent.close(workspaceArray[i]);
        }
    }

    private static List whereOpened(TopComponent[] topComponentArray) {
        Workspace[] workspaceArray = WindowManager.getDefault().getWorkspaces();
        ArrayList<Workspace> arrayList = new ArrayList<Workspace>(workspaceArray.length);
        block0: for (int i = 0; i < workspaceArray.length; ++i) {
            for (int j = 0; j < topComponentArray.length; ++j) {
                if (!topComponentArray[j].isOpened(workspaceArray[i])) continue;
                arrayList.add(workspaceArray[i]);
                continue block0;
            }
        }
        return arrayList;
    }

    public static List getRoots() {
        NbPlaces nbPlaces = NbPlaces.getDefault();
        LinkedList<Node> linkedList = new LinkedList<Node>();
        linkedList.addAll(Arrays.asList(nbPlaces.roots()));
        linkedList.add(nbPlaces.environment());
        return linkedList;
    }

    private ExplorerTab createTC(Node node, boolean bl) {
        MainTab mainTab = null;
        NbPlaces nbPlaces = NbPlaces.getDefault();
        if (node.equals((Object)nbPlaces.environment())) {
            if (bl) {
                TopComponent topComponent = WindowManager.getDefault().findTopComponent("runtime");
                if (topComponent != null) {
                    if (topComponent instanceof MainTab) {
                        mainTab = (MainTab)topComponent;
                    } else {
                        IllegalStateException illegalStateException = new IllegalStateException("Incorrect settings file. Unexpected class returned. Expected:" + MainTab.class.getName() + " Returned:" + topComponent.getClass().getName());
                        ErrorManager.getDefault().notify(1, (Throwable)illegalStateException);
                        mainTab = MainTab.getDefaultMainTab();
                    }
                } else {
                    mainTab = MainTab.getDefaultMainTab();
                }
            } else {
                mainTab = MainTab.getDefaultMainTab();
            }
            mainTab.setRootContext(node, false);
        } else {
            mainTab = NbMainExplorer.findModuleTab(node, null);
            mainTab.setRootContext(node);
        }
        this.rootsToTCs().put(node, mainTab);
        return mainTab;
    }

    private Map rootsToTCs() {
        if (this.rootsToTCs == null) {
            this.rootsToTCs = new HashMap(7);
        }
        return this.rootsToTCs;
    }

    private List prevRoots() {
        if (this.prevRoots == null) {
            this.prevRoots = new LinkedList();
        }
        return this.prevRoots;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        int n = objectInput.readInt();
        for (int i = 0; i < n; ++i) {
            objectInput.readObject();
        }
        objectInput.readObject();
        objectInput.readBoolean();
        objectInput.readBoolean();
        objectInput.readInt();
        objectInput.readInt();
    }

    public final ExplorerTab getRootPanel(Node node) {
        return (ExplorerTab)((Object)this.rootsToTCs().get(node));
    }

    public static NbMainExplorer getExplorer() {
        if (explorer == null) {
            explorer = new NbMainExplorer();
        }
        return explorer;
    }

    private static Mode explorerMode(Workspace workspace) {
        Mode mode = workspace.findMode("explorer");
        if (mode == null) {
            String string = NbBundle.getBundle((Class)NbMainExplorer.class).getString("CTL_ExplorerTitle");
            mode = workspace.createMode("explorer", string, NbMainExplorer.class.getResource("/org/netbeans/core/resources/frames/explorer.gif"));
        }
        return mode;
    }

    public static void main(String[] stringArray) throws Exception {
        NbMainExplorer nbMainExplorer = new NbMainExplorer();
        nbMainExplorer.open();
    }

    public static class ExplorerTab
    extends ExplorerPanel
    implements TopComponent.Cloneable {
        static final long serialVersionUID = -8202452314155464024L;
        protected TreeView view;
        private PropertyChangeListener weakRcL;
        private PropertyChangeListener weakIdeL;
        private NodeListener weakNRcL;
        private IDESettings ideSettings = (IDESettings)IDESettings.findObject((Class)(class$org$netbeans$core$IDESettings == null ? (class$org$netbeans$core$IDESettings = NbMainExplorer.class$("org.netbeans.core.IDESettings")) : class$org$netbeans$core$IDESettings), (boolean)true);
        private NodeListener rcListener;
        private boolean valid = true;
        private boolean rootVis = true;
        protected int persistenceType = 0;

        public ExplorerTab() {
            this.getActionMap().put("delete", ExplorerUtils.actionDelete((ExplorerManager)this.getExplorerManager(), (boolean)this.ideSettings.getConfirmDelete()));
            this.weakIdeL = WeakListeners.propertyChange((PropertyChangeListener)this.rcListener(), (Object)((Object)this.ideSettings));
            this.ideSettings.addPropertyChangeListener(this.weakIdeL);
        }

        public int getPersistenceType() {
            return 0;
        }

        protected void componentShowing() {
            super.componentShowing();
            if (this.view == null) {
                this.view = this.initGui();
                this.view.setRootVisible(this.rootVis);
                this.view.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)(class$org$netbeans$core$NbMainExplorer == null ? (class$org$netbeans$core$NbMainExplorer = NbMainExplorer.class$("org.netbeans.core.NbMainExplorer")) : class$org$netbeans$core$NbMainExplorer)).getString("ACSN_ExplorerBeanTree"));
                this.view.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$core$NbMainExplorer == null ? (class$org$netbeans$core$NbMainExplorer = NbMainExplorer.class$("org.netbeans.core.NbMainExplorer")) : class$org$netbeans$core$NbMainExplorer)).getString("ACSD_ExplorerBeanTree"));
            }
        }

        public void addNotify() {
            super.addNotify();
            if (WindowManager.getDefault().findMode((TopComponent)this) != null) {
                return;
            }
            this.componentShowing();
        }

        public void requestFocus() {
            super.requestFocus();
            if (this.view != null) {
                this.view.requestFocus();
            }
        }

        public boolean requestFocusInWindow() {
            super.requestFocusInWindow();
            if (this.view != null) {
                return this.view.requestFocusInWindow();
            }
            return false;
        }

        protected TreeView initGui() {
            BeanTreeView beanTreeView = new BeanTreeView();
            beanTreeView.setDragSource(true);
            this.setLayout(new BorderLayout());
            this.add((Component)beanTreeView);
            return beanTreeView;
        }

        public void open(Workspace workspace) {
            this.setValidRootContext();
            super.open(workspace);
        }

        public void setRootContext(Node node) {
            Node node2 = this.getExplorerManager().getRootContext();
            if (this.weakRcL != null) {
                node2.removePropertyChangeListener(this.weakRcL);
            }
            if (this.weakNRcL != null) {
                node2.removeNodeListener(this.weakNRcL);
            }
            this.getExplorerManager().setRootContext(node);
            this.initializeWithRootContext(node);
        }

        public void setRootContext(Node node, boolean bl) {
            this.rootVis = bl;
            if (this.view != null) {
                this.view.setRootVisible(bl);
            }
            this.setRootContext(node);
        }

        public void adjustComponentPersistence() {
            Node.Handle handle = this.getExplorerManager().getRootContext().getHandle();
            this.persistenceType = handle == null ? 2 : 1;
        }

        public Node getRootContext() {
            return this.getExplorerManager().getRootContext();
        }

        public Object readResolve() throws ObjectStreamException {
            this.scheduleValidation();
            return this;
        }

        private void setValidRootContext() {
            if (!this.valid) {
                this.valid = true;
                this.validateRootContext();
            }
        }

        protected void validateRootContext() {
            this.initializeWithRootContext(this.getExplorerManager().getRootContext());
        }

        protected void updateTitle() {
            this.setName(this.getExplorerManager().getRootContext().getDisplayName());
        }

        private NodeListener rcListener() {
            if (this.rcListener == null) {
                this.rcListener = new RootContextListener();
            }
            return this.rcListener;
        }

        private void initializeWithRootContext(Node node) {
            this.setIcon(node.getIcon(1));
            this.setToolTipText(node.getShortDescription());
            this.setName(node.getDisplayName());
            this.updateTitle();
            if (this.weakRcL == null) {
                this.weakRcL = WeakListeners.propertyChange((PropertyChangeListener)this.rcListener(), (Object)node);
            } else {
                node.removePropertyChangeListener(this.weakRcL);
            }
            node.addPropertyChangeListener(this.weakRcL);
            if (this.weakNRcL == null) {
                this.weakNRcL = NodeOp.weakNodeListener((NodeListener)this.rcListener(), (Object)node);
            } else {
                node.removeNodeListener(this.weakNRcL);
            }
            node.addNodeListener(this.weakNRcL);
        }

        protected final void scheduleValidation() {
            this.valid = false;
            this.setValidRootContext();
        }

        public void setName(String string) {
            super.setName(string);
            if (this.view != null) {
                this.view.getAccessibleContext().setAccessibleName(string);
            }
        }

        public void setToolTipText(String string) {
            super.setToolTipText(string);
            if (this.view != null) {
                this.view.getAccessibleContext().setAccessibleDescription(string);
            }
        }

        public TopComponent cloneComponent() {
            ExplorerTab explorerTab = new ExplorerTab();
            explorerTab.getExplorerManager().setRootContext(this.getExplorerManager().getRootContext());
            try {
                explorerTab.getExplorerManager().setSelectedNodes(this.getExplorerManager().getSelectedNodes());
            }
            catch (PropertyVetoException propertyVetoException) {
                ErrorManager.getDefault().notify((Throwable)propertyVetoException);
            }
            return explorerTab;
        }

        private final class RootContextListener
        implements NodeListener {
            RootContextListener() {
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                Object object = propertyChangeEvent.getSource();
                if (object instanceof IDESettings) {
                    ExplorerTab.this.getActionMap().put("delete", ExplorerUtils.actionDelete((ExplorerManager)ExplorerTab.this.getExplorerManager(), (boolean)((IDESettings)((Object)object)).getConfirmDelete()));
                    return;
                }
                final Node node = (Node)object;
                if ("displayName".equals(string) || "name".equals(string)) {
                    Mutex.EVENT.readAccess(new Runnable(){

                        public void run() {
                            ExplorerTab.this.setName(node.getDisplayName());
                        }
                    });
                } else if ("icon".equals(string)) {
                    Mutex.EVENT.readAccess(new Runnable(){

                        public void run() {
                            ExplorerTab.this.setIcon(node.getIcon(1));
                        }
                    });
                } else if ("shortDescription".equals(string)) {
                    ExplorerTab.this.setToolTipText(node.getShortDescription());
                }
            }

            public void nodeDestroyed(NodeEvent nodeEvent) {
                ExplorerTab.this.setCloseOperation(0);
                ExplorerTab.this.close();
            }

            public void childrenRemoved(NodeMemberEvent nodeMemberEvent) {
            }

            public void childrenReordered(NodeReorderEvent nodeReorderEvent) {
            }

            public void childrenAdded(NodeMemberEvent nodeMemberEvent) {
            }
        }
    }

    public static class MainTab
    extends ExplorerTab {
        static final long serialVersionUID = 4233454980309064344L;
        private static MainTab lastActivated;
        private static MainTab DEFAULT;

        public static synchronized MainTab getDefaultMainTab() {
            if (DEFAULT == null) {
                DEFAULT = new MainTab();
                DEFAULT.scheduleValidation();
            }
            return DEFAULT;
        }

        public static MainTab findEnvironmentTab() {
            return (MainTab)NbMainExplorer.getExplorer().createTC(NbPlaces.getDefault().environment(), true);
        }

        public static MainTab createEnvironmentTab() {
            return (MainTab)NbMainExplorer.getExplorer().createTC(NbPlaces.getDefault().environment(), false);
        }

        public int getPersistenceType() {
            return 0;
        }

        protected String preferredID() {
            return "runtime";
        }

        public HelpCtx getHelpCtx() {
            return ExplorerUtils.getHelpCtx((Node[])this.getExplorerManager().getSelectedNodes(), (HelpCtx)new HelpCtx(class$org$netbeans$core$EnvironmentNode == null ? (class$org$netbeans$core$EnvironmentNode = NbMainExplorer.class$("org.netbeans.core.EnvironmentNode")) : class$org$netbeans$core$EnvironmentNode));
        }

        public Object readResolve() throws ObjectStreamException {
            if (DEFAULT == null) {
                DEFAULT = this;
            }
            MainTab.getDefaultMainTab().scheduleValidation();
            return MainTab.getDefaultMainTab();
        }

        public void open(Workspace workspace) {
            Workspace workspace2 = workspace == null ? WindowManager.getDefault().getCurrentWorkspace() : workspace;
            Mode mode = workspace2.findMode((TopComponent)this);
            if (mode == null) {
                NbMainExplorer.explorerMode(workspace2).dockInto((TopComponent)this);
            }
            super.open(workspace);
        }

        protected void updateTitle() {
        }

        protected void componentActivated() {
            super.componentActivated();
            lastActivated = this;
        }

        protected void validateRootContext() {
            super.validateRootContext();
            this.registerRootContext(this.getExplorerManager().getRootContext());
        }

        protected void registerRootContext(Node node) {
            NbMainExplorer nbMainExplorer = NbMainExplorer.getExplorer();
            nbMainExplorer.prevRoots().add(node);
            nbMainExplorer.rootsToTCs().put(node, this);
        }
    }

    public static class ModuleTab
    extends MainTab {
        static final long serialVersionUID = 8089827754534653731L;

        public void setRootContext(Node node) {
            super.setRootContext(node);
            this.adjustComponentPersistence();
        }

        public int getPersistenceType() {
            return this.persistenceType;
        }

        protected void validateRootContext() {
            Class<?> clazz = this.getExplorerManager().getRootContext().getClass();
            Node[] nodeArray = NbPlaces.getDefault().roots();
            for (int i = 0; i < nodeArray.length; ++i) {
                if (!clazz.equals(nodeArray[i].getClass())) continue;
                this.setRootContext(nodeArray[i]);
                this.registerRootContext(nodeArray[i]);
                break;
            }
        }

        public Object readResolve() throws ObjectStreamException {
            Node node = this.getExplorerManager().getRootContext();
            ModuleTab moduleTab = NbMainExplorer.findModuleTab(node, this);
            if (moduleTab == null) {
                throw new InvalidObjectException("Cannot deserialize ModuleTab for node " + node);
            }
            moduleTab.scheduleValidation();
            return moduleTab;
        }
    }

    private static final class RootsListener
    implements ChangeListener {
        RootsListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            NbMainExplorer.getExplorer().doOpen(null);
        }
    }
}

