/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.ToolTipManager;
import org.openide.ErrorManager;
import org.openide.awt.HtmlBrowser;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.options.SystemOption;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class IDESettings
extends SystemOption {
    static final long serialVersionUID = 801136840705717911L;
    public static final String PROP_SHOW_TOOLTIPS_IN_IDE = "showToolTipsInIDE";
    public static final String PROP_CONFIRM_DELETE = "confirmDelete";
    public static final String PROP_HOME_PAGE = "homePage";
    public static final String PROP_USE_PROXY = "useProxy";
    public static final String PROP_PROXY_TYPE = "proxyType";
    public static final String PROP_PROXY_HOST = "userProxyHost";
    public static final String PROP_PROXY_PORT = "userProxyPort";
    public static final String PROP_SHOW_FILE_EXTENSIONS = "showFileExtensions";
    public static final String PROP_MODULES_SORT_MODE = "modulesSortMode";
    public static final String PROP_WWWBROWSER = "WWWBrowser";
    public static final String PROP_UIMODE = "UIMode";
    public static final String PROP_NON_PROXY_HOSTS = "userNonProxy";
    public static final String PROP_IGNORED_FILES = "IgnoredFiles";
    public static final String KEY_PROXY_HOST = "http.proxyHost";
    public static final String KEY_PROXY_PORT = "http.proxyPort";
    public static final String KEY_NON_PROXY_HOSTS = "http.nonProxyHosts";
    public static final String KEY_HTTPS_PROXY_HOST = "https.proxyHost";
    public static final String KEY_HTTPS_PROXY_PORT = "https.proxyPort";
    public static final String KEY_HTTPS_NON_PROXY_HOSTS = "https.nonProxyHosts";
    public static final int MODULES_SORT_UNSORTED = 0;
    public static final int MODULES_SORT_DISPLAYNAME = 1;
    public static final int MODULES_SORT_CODENAME = 2;
    public static final int MODULES_SORT_ENABLED = 3;
    public static final int MODULES_SORT_URL = 4;
    public static final int MODULES_SORT_CATEGORY = 5;
    public static final int DIRECT_CONNECTION = 0;
    public static final int AUTO_DETECT_PROXY = 1;
    public static final int MANUAL_SET_PROXY = 2;
    private static boolean showToolTips;
    private static boolean showTips;
    private static int lastTip;
    private static boolean confirmDelete;
    private static int modulesSortMode;
    private static boolean useProxy;
    private static int proxyType;
    private static String userProxyHost;
    private static String userProxyPort;
    private static String presetNonProxyHosts;
    private String userNonProxyHosts = "";
    private static int uiMode;
    private static String ignoredFiles;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;

    protected void initialize() {
        super.initialize();
        this.userNonProxyHosts = IDESettings.getModifiedNonProxyHosts(this.getSystemNonProxyHosts());
        this.setProxy();
        this.setProxy();
        this.putProperty(PROP_WWWBROWSER, "", false);
    }

    private void setProxy() {
        String string = this.getProxyHost();
        String string2 = this.getProxyPort();
        String string3 = this.getNonProxyHosts();
        System.setProperty(KEY_PROXY_HOST, string);
        System.setProperty(KEY_PROXY_PORT, string2);
        System.setProperty(KEY_NON_PROXY_HOSTS, string3);
        System.setProperty(KEY_HTTPS_PROXY_HOST, string);
        System.setProperty(KEY_HTTPS_PROXY_PORT, string2);
        System.setProperty(KEY_HTTPS_NON_PROXY_HOSTS, string3);
    }

    public static URL getRealHomeURL() {
        try {
            return new URL(NbBundle.getMessage((Class)IDESettings.class, (String)"URL_default_home_page"));
        }
        catch (MalformedURLException malformedURLException) {
            throw new AssertionError((Object)malformedURLException);
        }
    }

    public int getModulesSortMode() {
        return modulesSortMode;
    }

    public void setModulesSortMode(int n) {
        int n2 = modulesSortMode;
        modulesSortMode = n;
        this.firePropertyChange(PROP_MODULES_SORT_MODE, new Integer(n2), new Integer(n));
    }

    public boolean getShowToolTipsInIDE() {
        return showToolTips;
    }

    public void setShowToolTipsInIDE(boolean bl) {
        if (showToolTips == bl) {
            return;
        }
        showToolTips = bl;
        ToolTipManager.sharedInstance().setEnabled(bl);
        this.firePropertyChange(PROP_SHOW_TOOLTIPS_IN_IDE, !showToolTips ? Boolean.TRUE : Boolean.FALSE, showToolTips ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean getConfirmDelete() {
        return confirmDelete;
    }

    public void setConfirmDelete(boolean bl) {
        if (bl == confirmDelete) {
            return;
        }
        Boolean bl2 = confirmDelete ? Boolean.TRUE : Boolean.FALSE;
        confirmDelete = bl;
        this.firePropertyChange(PROP_CONFIRM_DELETE, bl2, confirmDelete ? Boolean.TRUE : Boolean.FALSE);
    }

    public String displayName() {
        return NbBundle.getBundle((Class)IDESettings.class).getString("CTL_IDESettings");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(IDESettings.class);
    }

    public String getHomePage() {
        return HtmlBrowser.getHomePage();
    }

    public void setHomePage(String string) {
        HtmlBrowser.setHomePage((String)string);
    }

    public boolean getUseProxy() {
        return useProxy;
    }

    public void setUseProxy(boolean bl) {
        if (useProxy != bl) {
            if (bl) {
                this.setProxyType(2);
            } else {
                this.setProxyType(1);
            }
        }
    }

    public int getProxyType() {
        int n;
        int n2 = n = proxyType == -1 ? 1 : proxyType;
        if (n == 1 && !this.isSystemProxyDetect()) {
            n = 0;
        }
        return n;
    }

    public void setProxyType(int n) {
        if (proxyType != n) {
            int n2 = proxyType;
            boolean bl = this.getUseProxy();
            String string = this.getProxyHost();
            String string2 = this.getProxyPort();
            String string3 = this.getNonProxyHosts();
            proxyType = n;
            if (bl != this.getUseProxy()) {
                this.firePropertyChange(PROP_USE_PROXY, bl ? Boolean.TRUE : Boolean.FALSE, this.getUseProxy() ? Boolean.TRUE : Boolean.FALSE);
            }
            if (!string.equals(this.getProxyHost())) {
                this.firePropertyChange(PROP_PROXY_HOST, string, this.getProxyHost());
            }
            if (!string2.equals(this.getProxyPort())) {
                this.firePropertyChange(PROP_PROXY_PORT, string2, this.getProxyPort());
            }
            if (!string3.equals(this.getNonProxyHosts())) {
                this.firePropertyChange(PROP_NON_PROXY_HOSTS, string3, this.getNonProxyHosts());
            }
            this.setProxy();
        }
    }

    public String getUserProxyHost() {
        return userProxyHost;
    }

    public String getUserProxyPort() {
        return userProxyPort;
    }

    public void setUserProxyHost(String string) {
        String string2;
        if (!(string = string == null ? "" : string).equals(string2 = this.getUserProxyHost())) {
            userProxyHost = string;
            if (2 == this.getProxyType()) {
                System.setProperty(KEY_PROXY_HOST, string);
                System.setProperty(KEY_HTTPS_PROXY_HOST, string);
                this.firePropertyChange(PROP_PROXY_HOST, string2, string);
            }
        }
    }

    public void setUserProxyPort(String string) {
        String string2;
        if (!(string = string == null ? "" : string).equals(string2 = this.getUserProxyPort())) {
            userProxyPort = string;
            if (2 == this.getProxyType()) {
                System.setProperty(KEY_PROXY_PORT, string);
                System.setProperty(KEY_HTTPS_PROXY_PORT, string);
                this.firePropertyChange(PROP_PROXY_PORT, string2, string);
            }
        }
    }

    public String getProxyHost() {
        switch (this.getProxyType()) {
            case 1: {
                return this.getSystemProxyHost();
            }
            case 2: {
                return this.getUserProxyHost();
            }
            case 0: {
                return "";
            }
        }
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)("Unknown proxy type " + this.getProxyType()));
        }
        return null;
    }

    public void setUserNonProxyHosts(String string) {
        String string2 = string = string == null ? "" : string;
        if (!string.equals(this.userNonProxyHosts)) {
            System.setProperty(KEY_NON_PROXY_HOSTS, string);
            System.setProperty(KEY_HTTPS_NON_PROXY_HOSTS, string);
            this.firePropertyChange(KEY_NON_PROXY_HOSTS, this.userNonProxyHosts, string);
            this.userNonProxyHosts = string;
        }
    }

    public String getUserNonProxyHosts() {
        return this.userNonProxyHosts;
    }

    public void readOldProxyHost(String string) {
        this.setUserProxyHost(string);
    }

    public void readOldProxyPort(String string) {
        this.setUserProxyPort(string);
    }

    public void setProxyHost(String string) {
        String string2 = string = string == null ? "" : string;
        if (!$assertionsDisabled && 2 != this.getProxyType()) {
            throw new AssertionError((Object)("Don't set proxy host if proxy type " + this.getProxyType()));
        }
        if (!this.getUserProxyHost().equals(string)) {
            String string3 = this.getUserProxyHost();
            this.setUserProxyHost(string);
            System.setProperty(KEY_PROXY_HOST, string);
            System.setProperty(KEY_HTTPS_PROXY_HOST, string);
        }
    }

    public String getProxyPort() {
        switch (this.getProxyType()) {
            case 1: {
                return this.getSystemProxyPort();
            }
            case 2: {
                return this.getUserProxyPort();
            }
            case 0: {
                return "";
            }
        }
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)("Unknown proxy type " + this.getProxyType()));
        }
        return null;
    }

    public void setProxyPort(String string) {
        String string2 = string = string == null ? "" : string;
        if (!$assertionsDisabled && 2 != this.getProxyType()) {
            throw new AssertionError((Object)("Don't set proxy port if proxy type " + this.getProxyType()));
        }
        if (!this.getUserProxyPort().equals(string)) {
            String string3 = this.getUserProxyPort();
            this.setUserProxyPort(string);
            System.setProperty(KEY_PROXY_PORT, this.getProxyPort());
            System.setProperty(KEY_HTTPS_PROXY_PORT, this.getProxyPort());
        }
    }

    public boolean getShowFileExtensions() {
        return DataNode.getShowFileExtensions();
    }

    public void setShowFileExtensions(boolean bl) {
        boolean bl2 = this.getShowFileExtensions();
        DataNode.setShowFileExtensions((boolean)bl);
        this.firePropertyChange(PROP_SHOW_FILE_EXTENSIONS, bl2, bl);
    }

    public HtmlBrowser.Factory getWWWBrowser() {
        block8: {
            try {
                Object object = this.getProperty(PROP_WWWBROWSER);
                if (object instanceof String && !"".equals(object)) {
                    Lookup.Item item = Lookup.getDefault().lookupItem(new Lookup.Template(HtmlBrowser.Factory.class, (String)object, null));
                    return item == null ? null : (HtmlBrowser.Factory)item.getInstance();
                }
                if (object != null && !"".equals(object)) break block8;
                Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(HtmlBrowser.Factory.class));
                Iterator iterator = result.allInstances().iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource("Services/Browsers");
                    DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
                    DataObject[] dataObjectArray = dataFolder.getChildren();
                    for (int i = 0; i < dataObjectArray.length; ++i) {
                        Object object2 = null;
                        try {
                            if (Boolean.TRUE.equals(dataObjectArray[i].getPrimaryFile().getAttribute("hidden"))) continue;
                            InstanceCookie instanceCookie = (InstanceCookie)dataObjectArray[i].getCookie(class$org$openide$cookies$InstanceCookie == null ? IDESettings.class$("org.openide.cookies.InstanceCookie") : class$org$openide$cookies$InstanceCookie);
                            if (instanceCookie == null || (object2 = instanceCookie.instanceCreate()) == null || !object2.equals(e)) continue;
                            return (HtmlBrowser.Factory)e;
                        }
                        catch (IOException iOException) {
                            ErrorManager.getDefault().notify(1, (Throwable)iOException);
                            continue;
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            ErrorManager.getDefault().notify(1, (Throwable)classNotFoundException);
                        }
                    }
                }
                return null;
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify((Throwable)exception);
            }
        }
        return null;
    }

    public void setWWWBrowser(HtmlBrowser.Factory factory) {
        try {
            if (factory == null) {
                this.putProperty(PROP_WWWBROWSER, "", true);
                return;
            }
            Lookup.Item item = Lookup.getDefault().lookupItem(new Lookup.Template(HtmlBrowser.Factory.class, null, (Object)factory));
            if (item != null) {
                this.putProperty(PROP_WWWBROWSER, item.getId(), true);
            } else {
                ErrorManager.getDefault().log("IDESettings: Cannot find browser in lookup");
                this.putProperty(PROP_WWWBROWSER, "", true);
            }
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
    }

    public void setUIMode(int n) {
        if (uiMode == n) {
            return;
        }
        int n2 = uiMode;
        uiMode = n;
        this.firePropertyChange(PROP_UIMODE, new Integer(n2), new Integer(n));
    }

    public int getUIMode() {
        return uiMode;
    }

    private static String getModifiedNonProxyHosts(String string) {
        String string2;
        String string3 = string.replaceAll(";", "|").replaceAll(",", "|");
        String string4 = string2 = presetNonProxyHosts == null ? "" : presetNonProxyHosts.replaceAll(";", "|").replaceAll(",", "|");
        if (Utilities.isWindows()) {
            string3 = IDESettings.addReguralToNonProxyHosts(string3);
        }
        String string5 = string2 + (string2.length() == 0 ? "" : "|") + string3 + (string3.length() == 0 ? "" : "|") + "localhost|127.0.0.1";
        String string6 = "";
        try {
            string6 = InetAddress.getLocalHost().getHostName();
            if (!string6.equals("localhost")) {
                string5 = string5 + "|" + string6;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        try {
            String string7 = InetAddress.getLocalHost().getCanonicalHostName();
            if (!string7.equals("localhost") && !string7.equals(string6)) {
                string5 = string5 + "|" + string7;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return IDESettings.compactNonProxyHosts(string5);
    }

    public String getIgnoredFiles() {
        return ignoredFiles;
    }

    public void setIgnoredFiles(String string) throws IllegalArgumentException {
        if (!ignoredFiles.equals(string)) {
            try {
                String string2 = ignoredFiles;
                Pattern.compile(string);
                ignoredFiles = string;
                this.firePropertyChange(PROP_IGNORED_FILES, string2, string);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
                illegalArgumentException.initCause(patternSyntaxException);
                ErrorManager.getDefault().annotate((Throwable)illegalArgumentException, 256, patternSyntaxException.getMessage(), patternSyntaxException.getLocalizedMessage(), null, null);
                throw illegalArgumentException;
            }
        }
    }

    private boolean isSystemProxyDetect() {
        return System.getProperty("netbeans.system_http_proxy") != null;
    }

    private String getSystemProxyHost() {
        String string = System.getProperty("netbeans.system_http_proxy");
        if (string == null) {
            return "";
        }
        int n = string.indexOf(":");
        if (n <= 0 || n >= string.length() - 1) {
            return "";
        }
        return string.substring(0, n);
    }

    private String getSystemNonProxyHosts() {
        String string = System.getProperty("netbeans.system_http_non_proxy_hosts");
        return string == null ? "" : string;
    }

    private static String normalizeProxyHost(String string) {
        if (string.toLowerCase().startsWith("http://")) {
            return string.substring(7, string.length());
        }
        return string;
    }

    private static String compactNonProxyHosts(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        HashSet<String> hashSet = new HashSet<String>();
        String string2 = "";
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (!hashSet.add(string3.toLowerCase(Locale.US))) continue;
            string2 = string2 + (string2.length() > 0 ? "|" : "") + string3;
        }
        return string2;
    }

    private static String addReguralToNonProxyHosts(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        String string2 = "";
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.indexOf(42) == -1) {
                string3 = string3 + '*';
            } else if (string3.indexOf(60) != -1) {
                string3 = "";
            }
            string2 = string2 + (string2.length() > 0 ? "|" : "") + string3;
        }
        return string2;
    }

    private String getSystemProxyPort() {
        String string = System.getProperty("netbeans.system_http_proxy");
        if (string == null) {
            return "";
        }
        int n = string.indexOf(":");
        if (n <= 0 || n >= string.length() - 1) {
            return "";
        }
        return string.substring(n + 1);
    }

    public String getNonProxyHosts() {
        switch (this.getProxyType()) {
            case 1: {
                return IDESettings.getModifiedNonProxyHosts(this.getSystemNonProxyHosts());
            }
            case 2: {
                return this.getUserNonProxyHosts();
            }
            case 0: {
                return "";
            }
        }
        throw new AssertionError((Object)("Unknown proxy type " + this.getProxyType()));
    }

    static {
        $assertionsDisabled = !IDESettings.class.desiredAssertionStatus();
        showToolTips = true;
        showTips = true;
        lastTip = -1;
        confirmDelete = true;
        modulesSortMode = 5;
        useProxy = false;
        proxyType = -1;
        userProxyHost = System.getProperty(KEY_PROXY_HOST, "");
        userProxyPort = System.getProperty(KEY_PROXY_PORT, "");
        presetNonProxyHosts = System.getProperty(KEY_NON_PROXY_HOSTS, "");
        uiMode = 2;
        ignoredFiles = "^(CVS|SCCS|vssver\\.scc|#.*#|%.*%|\\.(cvsignore|svn|DS_Store))$|^\\.[#_]|~$";
    }
}

