/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import [Lorg.openide.filesystems.FileSystem;;
import java.io.IOException;
import java.io.NotSerializableException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.netbeans.core.NbPlaces;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.filesystems.RepositoryEvent;
import org.openide.filesystems.RepositoryListener;
import org.openide.filesystems.RepositoryReorderedEvent;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.FolderInstance;
import org.openide.loaders.InstanceDataObject;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.WeakSet;

public class AutomountSupport
extends FolderInstance
implements RepositoryListener,
Runnable {
    private static RequestProcessor RP = new RequestProcessor("Automount");
    private static ThreadLocal VAR = new ThreadLocal();
    private static DblTask defaultTask;
    private static final int DELAY = 1000;
    private static Set createdByMe;
    private static Set sticky;
    private static Set shineAway;
    private static Set errCookies;
    private boolean defaultInstance;
    private static ErrorManager err;
    static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;

    private AutomountSupport(DataObject.Container container, boolean bl) {
        super(container);
        this.defaultInstance = bl;
    }

    protected Object createInstance(InstanceCookie[] instanceCookieArray) throws IOException, ClassNotFoundException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < instanceCookieArray.length; ++i) {
            Object object;
            try {
                object = instanceCookieArray[i].instanceCreate();
            }
            catch (IOException iOException) {
                if (!errCookies.add(instanceCookieArray[i])) continue;
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
                continue;
            }
            errCookies.remove(instanceCookieArray[i]);
            if (object instanceof FileSystem) {
                arrayList.add(object);
                continue;
            }
            if (!(object instanceof FileSystem[])) continue;
            arrayList.addAll(Arrays.asList((FileSystem[])object));
        }
        Object object = arrayList.size() == 1 ? arrayList.get(0) : arrayList.toArray(new FileSystem[0]);
        if (this.defaultInstance) {
            AutomountSupport.updateFileSystems(arrayList);
        }
        return object;
    }

    protected Object instanceForCookie(DataObject dataObject, InstanceCookie instanceCookie) throws IOException, ClassNotFoundException {
        if (errCookies.contains(instanceCookie)) {
            dataObject.delete();
            return null;
        }
        try {
            return super.instanceForCookie(dataObject, instanceCookie);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
            dataObject.delete();
            return null;
        }
    }

    protected InstanceCookie acceptContainer(DataObject.Container container) {
        return new AutomountSupport(container, false);
    }

    protected InstanceCookie acceptCookie(InstanceCookie instanceCookie) throws IOException, ClassNotFoundException {
        if (instanceCookie instanceof InstanceCookie.Of) {
            InstanceCookie.Of of = (InstanceCookie.Of)instanceCookie;
            if (of.instanceOf(FileSystem.class) || of.instanceOf(FileSystem;.class)) {
                return instanceCookie;
            }
            return null;
        }
        Class<?> clazz = instanceCookie.instanceClass();
        if (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        if (FileSystem.class.isAssignableFrom(clazz)) {
            return instanceCookie;
        }
        return null;
    }

    protected Task postCreationTask(Runnable runnable) {
        return RP.post(runnable);
    }

    private List getList() {
        Object object = null;
        try {
            object = this.instanceCreate();
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ErrorManager.getDefault().notify((Throwable)classNotFoundException);
        }
        if (object == null) {
            return Collections.EMPTY_LIST;
        }
        if (object instanceof FileSystem) {
            return Collections.nCopies(1, object);
        }
        return Arrays.asList((FileSystem[])object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Task initialize() {
        if (defaultTask != null) {
            return defaultTask;
        }
        NbPlaces.getDefault();
        DataFolder dataFolder = NbPlaces.findSessionFolder("Mount");
        AutomountSupport automountSupport = new AutomountSupport((DataObject.Container)dataFolder, true);
        RequestProcessor.Task task = RP.create((Runnable)automountSupport);
        task.setPriority(1);
        defaultTask = new DblTask((Task)automountSupport, task);
        Repository repository = Repository.getDefault();
        repository.addRepositoryListener((RepositoryListener)automountSupport);
        AutomountSupport automountSupport2 = automountSupport;
        synchronized (automountSupport2) {
            sticky.addAll(Arrays.asList(repository.toArray()));
            if (sticky.size() > 1) {
                defaultTask.store();
            }
        }
        automountSupport.recreate();
        return defaultTask;
    }

    public void run() {
        try {
            FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
            fileSystem.runAtomicAction(new FileSystem.AtomicAction(){

                public void run() {
                    NbPlaces.getDefault();
                    DataFolder dataFolder = NbPlaces.findSessionFolder("Mount");
                    List list = AutomountSupport.this.getList();
                    Enumeration enumeration = dataFolder.getPrimaryFile().getFolders(true);
                    while (enumeration.hasMoreElements()) {
                        try {
                            DataFolder dataFolder2 = (DataFolder)DataFolder.find((FileObject)((FileObject)enumeration.nextElement()));
                            AutomountSupport.this.checkSaved(list, dataFolder2, dataFolder2.getChildren(), false);
                        }
                        catch (DataObjectNotFoundException dataObjectNotFoundException) {}
                    }
                    AutomountSupport.this.checkSaved(list, dataFolder, dataFolder.getChildren(), true);
                }
            });
        }
        catch (IOException iOException) {
            throw new IllegalStateException();
        }
    }

    public void fileSystemAdded(RepositoryEvent repositoryEvent) {
        defaultTask.fs(repositoryEvent);
    }

    public void fileSystemRemoved(RepositoryEvent repositoryEvent) {
        defaultTask.fs(repositoryEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fileSystemPoolReordered(RepositoryReorderedEvent repositoryReorderedEvent) {
        if (VAR.get() == null) {
            if (AutomountSupport.isLog()) {
                AutomountSupport.log("Reorder in repository");
                Repository repository = Repository.getDefault();
                synchronized (repository) {
                    FileSystem[] fileSystemArray = Repository.getDefault().toArray();
                    for (int i = 0; i < fileSystemArray.length; ++i) {
                        AutomountSupport.log("   " + i + "th = " + fileSystemArray[i]);
                    }
                }
            }
            defaultTask.store();
        } else {
            AutomountSupport.log("Repository reordered by AU");
        }
    }

    private static boolean containsFS(FileSystem fileSystem) {
        FileSystem[] fileSystemArray = Repository.getDefault().toArray();
        for (int i = 0; i < fileSystemArray.length; ++i) {
            if (fileSystemArray[i] != fileSystem) continue;
            return true;
        }
        return false;
    }

    private static String escape(String string) throws IOException {
        try {
            Method method = InstanceDataObject.class.getDeclaredMethod("escapeAndCut", String.class);
            method.setAccessible(true);
            return (String)method.invoke(null, (Object[])new String[]{string});
        }
        catch (Exception exception) {
            throw (IOException)ErrorManager.getDefault().annotate((Throwable)new IOException("Escape support failed"), (Throwable)exception);
        }
    }

    public static String computeNewName(String string, DataFolder dataFolder) throws IOException {
        if (string == null || string.length() == 0) {
            return null;
        }
        boolean bl = true;
        String string2 = string;
        int n = 1;
        while (bl) {
            String string3;
            bl = false;
            String string4 = AutomountSupport.escape(string2);
            if (string4.equals(string3 = FileUtil.findFreeFileName((FileObject)dataFolder.getPrimaryFile(), (String)string4, (String)"settings"))) continue;
            bl = true;
            string2 = string + "_" + n;
            ++n;
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkSaved(List list, DataFolder dataFolder, DataObject[] dataObjectArray, boolean bl) {
        Repository repository;
        Repository repository2 = repository = Repository.getDefault();
        synchronized (repository2) {
            Object object;
            Object object2;
            InstanceCookie instanceCookie;
            int n;
            Object object3;
            boolean bl2;
            List<FileSystem> list2 = Arrays.asList(repository.toArray());
            ArrayList<FileSystem> arrayList = new ArrayList<FileSystem>(list2);
            arrayList.removeAll(createdByMe);
            arrayList.removeAll(list);
            ArrayList<Object> arrayList2 = new ArrayList<Object>(list2.size() * 2);
            arrayList2.addAll(Arrays.asList(dataObjectArray));
            sticky.removeAll(list);
            HashSet<FileSystem> hashSet = new HashSet<FileSystem>(list2);
            hashSet.retainAll(createdByMe);
            ArrayList<FileSystem> arrayList3 = new ArrayList<FileSystem>(list2);
            arrayList3.retainAll(list);
            boolean bl3 = bl2 = arrayList3.size() == list.size() && !((Object)arrayList3).equals(list);
            if (bl2) {
                class Cmp
                extends HashMap
                implements Comparator {
                    Cmp() {
                    }

                    public int compare(Object object, Object object2) {
                        return this.index(object) - this.index(object2);
                    }

                    private int index(Object object) {
                        return (Integer)this.get(object);
                    }
                }
                object3 = new Cmp();
                n = arrayList3.size();
                instanceCookie = arrayList2.iterator();
                while (instanceCookie.hasNext()) {
                    object2 = (DataObject)instanceCookie.next();
                    ++n;
                    object = (InstanceCookie)object2.getCookie(class$org$openide$cookies$InstanceCookie == null ? AutomountSupport.class$("org.openide.cookies.InstanceCookie") : class$org$openide$cookies$InstanceCookie);
                    if (object != null) {
                        try {
                            Object object4 = object.instanceCreate();
                            int n2 = arrayList3.indexOf(object4);
                            if (n2 >= 0) {
                                ((HashMap)object3).put(object2, new Integer(n2));
                                continue;
                            }
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            ErrorManager.getDefault().notify(1, (Throwable)classNotFoundException);
                        }
                        catch (IOException iOException) {
                            ErrorManager.getDefault().notify(1, (Throwable)iOException);
                        }
                    }
                    ((HashMap)object3).put(object2, new Integer(n));
                }
                Collections.sort(arrayList2, object3);
            }
            object3 = arrayList.iterator();
            if (bl) {
                while (object3.hasNext()) {
                    FileSystem fileSystem = (FileSystem)object3.next();
                    if (fileSystem.isDefault()) continue;
                    try {
                        object2 = AutomountSupport.computeNewName(fileSystem.getDisplayName(), dataFolder);
                        try {
                            instanceCookie = InstanceDataObject.create((DataFolder)dataFolder, (String)object2, (Object)fileSystem, null);
                            createdByMe.add(fileSystem);
                        }
                        catch (NotSerializableException notSerializableException) {
                            continue;
                        }
                        if (instanceCookie.instanceCreate() != fileSystem) {
                            object = new StringBuffer(255);
                            ((StringBuffer)object).append("This bug is caused by wrong implementation of InstanceDataObject, see ");
                            ((StringBuffer)object).append("http://www.netbeans.org/issues/show_bug.cgi?id=14557");
                            ((StringBuffer)object).append("\nSTORING: ");
                            ((StringBuffer)object).append(fileSystem);
                            ((StringBuffer)object).append("\nINSTNCE: ");
                            ((StringBuffer)object).append(instanceCookie.instanceCreate());
                            throw new IllegalStateException(((StringBuffer)object).toString());
                        }
                        hashSet.add(fileSystem);
                        if (AutomountSupport.isLog()) {
                            AutomountSupport.log(" written to disk: " + fileSystem + " into: " + instanceCookie);
                        }
                        arrayList2.add(instanceCookie);
                        sticky.remove(fileSystem);
                        bl2 = true;
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify((Throwable)iOException);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        ErrorManager.getDefault().notify((Throwable)classNotFoundException);
                    }
                }
            }
            for (n = 0; n < dataObjectArray.length; ++n) {
                instanceCookie = (InstanceCookie)dataObjectArray[n].getCookie(class$org$openide$cookies$InstanceCookie == null ? AutomountSupport.class$("org.openide.cookies.InstanceCookie") : class$org$openide$cookies$InstanceCookie);
                if (instanceCookie == null) continue;
                try {
                    object2 = instanceCookie.instanceCreate();
                    if (!(object2 instanceof FileSystem) || hashSet.contains(object2)) continue;
                    dataObjectArray[n].delete();
                    createdByMe.retainAll(Arrays.asList(repository.toArray()));
                    if (AutomountSupport.isLog()) {
                        AutomountSupport.log("  deleted from disk: " + object2 + " from: " + dataObjectArray[n]);
                    }
                    arrayList2.remove(dataObjectArray[n]);
                    bl2 = true;
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    ErrorManager.getDefault().notify((Throwable)classNotFoundException);
                    continue;
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
            if (bl2) {
                try {
                    dataFolder.setOrder(arrayList2.toArray(new DataObject[0]));
                    if (this.isFinished()) {
                        AutomountSupport.log("I should not be finished");
                        this.waitFinished();
                        AutomountSupport.log("And I am not no longer: " + this.isFinished());
                    }
                    if (AutomountSupport.isLog()) {
                        AutomountSupport.log("Changed order on the disk");
                        Iterator iterator = arrayList2.iterator();
                        int n3 = 0;
                        while (iterator.hasNext()) {
                            object2 = (DataObject)iterator.next();
                            object = (InstanceCookie)object2.getCookie(class$org$openide$cookies$InstanceCookie == null ? AutomountSupport.class$("org.openide.cookies.InstanceCookie") : class$org$openide$cookies$InstanceCookie);
                            if (object == null) continue;
                            AutomountSupport.log("  " + n3++ + " is: " + object.instanceCreate());
                        }
                    }
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    ErrorManager.getDefault().notify((Throwable)classNotFoundException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateFileSystems(List list) {
        Repository repository;
        Repository repository2 = repository = Repository.getDefault();
        synchronized (repository2) {
            int n;
            Object object;
            Object object2;
            Object object3;
            List<FileSystem> list2 = Arrays.asList(repository.toArray());
            LinkedList<FileSystem> linkedList = new LinkedList<FileSystem>(list2);
            linkedList.removeAll(list);
            linkedList.removeAll(sticky);
            AutomountSupport.log("sticky: " + sticky);
            linkedList.retainAll(createdByMe);
            if (AutomountSupport.isLog()) {
                object3 = linkedList.iterator();
                while (object3.hasNext()) {
                    object2 = (FileSystem)object3.next();
                    AutomountSupport.log("  r: " + object2 + " contains: " + sticky.contains(object2));
                }
            }
            object3 = new LinkedList(list);
            object3.removeAll(list2);
            object3.removeAll(shineAway);
            if (AutomountSupport.isLog()) {
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = (FileSystem)object2.next();
                    AutomountSupport.log("  a: " + object + " contains: " + sticky.contains(object));
                }
            }
            VAR.set(VAR);
            AutomountSupport.cycleFileSystems(linkedList, false);
            AutomountSupport.cycleFileSystems((Collection)object3, true);
            VAR.set(null);
            createdByMe.addAll(list);
            createdByMe.retainAll(Arrays.asList(repository.toArray()));
            object2 = repository.toArray();
            object = new LinkedList(list);
            object.retainAll(Arrays.asList(object2));
            int[] nArray = new int[((Object)object2).length];
            int n2 = object.size() + 1;
            boolean bl = false;
            for (n = 0; n < ((Object)object2).length; ++n) {
                if (object2[n].isDefault()) {
                    nArray[n] = 0;
                    continue;
                }
                int n3 = object.indexOf(object2[n]);
                n3 = n3 == -1 ? n2++ : ++n3;
                nArray[n3] = n;
                bl |= n3 != n;
            }
            if (bl) {
                if (AutomountSupport.isLog()) {
                    AutomountSupport.log("Doing reorder");
                    for (n = 0; n < ((Object)object2).length; ++n) {
                        AutomountSupport.log("  " + n + " <- " + nArray[n] + " now: " + object2[n]);
                    }
                    AutomountSupport.log("On disk");
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        AutomountSupport.log("  " + iterator.next());
                    }
                    AutomountSupport.log("------");
                }
                VAR.set(VAR);
                try {
                    repository.reorder(nArray);
                }
                finally {
                    VAR.set(null);
                }
            } else {
                AutomountSupport.log("No reoder");
            }
        }
    }

    private static void cycleFileSystems(Collection collection, boolean bl) {
        Repository repository = Repository.getDefault();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            FileSystem fileSystem = (FileSystem)iterator.next();
            if (bl) {
                FileSystem fileSystem2 = repository.findFileSystem(fileSystem.getSystemName());
                if (fileSystem2 != null && fileSystem2 != fileSystem && sticky.remove(fileSystem2)) {
                    repository.removeFileSystem(fileSystem2);
                }
                repository.addFileSystem(fileSystem);
                continue;
            }
            repository.removeFileSystem(fileSystem);
        }
    }

    private static boolean isLog() {
        if (err == null) {
            err = ErrorManager.getDefault().getInstance("org.netbeans.core.AutomountSupport");
        }
        return err.isLoggable(1);
    }

    private static void log(String string) {
        if (AutomountSupport.isLog()) {
            err.log(string);
        }
    }

    static {
        createdByMe = new WeakSet();
        sticky = new WeakSet();
        shineAway = new WeakSet();
        errCookies = new WeakSet();
    }

    private static final class DblTask
    extends Task
    implements TaskListener {
        private Task defaultInstance;
        private RequestProcessor.Task storeTask;
        private Task updateTask = Task.EMPTY;
        private boolean isStoring;

        public DblTask(Task task, RequestProcessor.Task task2) {
            this.defaultInstance = task;
            this.storeTask = task2;
            task.addTaskListener((TaskListener)this);
            task2.addTaskListener((TaskListener)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void store() {
            DblTask dblTask = this;
            synchronized (dblTask) {
                this.storeTask.schedule(1000);
                this.isStoring = true;
            }
            this.notifyRunning();
        }

        private synchronized boolean areBothFinished() {
            boolean bl;
            boolean bl2 = bl = !this.isStoring || this.storeTask.isFinished();
            if (!bl) {
                return false;
            }
            boolean bl3 = this.defaultInstance.isFinished();
            if (!bl3) {
                return false;
            }
            boolean bl4 = this.updateTask.isFinished();
            return bl4;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitFinished() {
            AutomountSupport.log("Entered waitFinished");
            for (int i = 0; i < 2; ++i) {
                do {
                    boolean bl;
                    this.updateTask.waitFinished();
                    this.defaultInstance.waitFinished();
                    DblTask dblTask = this;
                    synchronized (dblTask) {
                        bl = this.isStoring;
                    }
                    if (!bl) continue;
                    this.storeTask.waitFinished();
                } while (!this.areBothFinished());
            }
            AutomountSupport.log("Leaving waitFinished");
        }

        public void taskFinished(Task task) {
            if (this.areBothFinished()) {
                this.notifyFinished();
            }
        }

        public synchronized void fs(RepositoryEvent repositoryEvent) {
            boolean bl;
            boolean bl2 = bl = VAR.get() == null;
            if (!bl) {
                AutomountSupport.log("fs: " + repositoryEvent.getFileSystem() + " added: " + repositoryEvent.isAdded() + " by AU support");
                return;
            }
            class Run
            implements Runnable {
                public RepositoryEvent ev;

                public Run(RepositoryEvent repositoryEvent) {
                    this.ev = repositoryEvent;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Repository repository;
                    Repository repository2 = repository = Repository.getDefault();
                    synchronized (repository2) {
                        FileSystem fileSystem = this.ev.getFileSystem();
                        boolean bl = AutomountSupport.containsFS(fileSystem);
                        boolean bl2 = this.ev.isAdded();
                        AutomountSupport.log("fs: " + fileSystem + " added: " + bl2 + " contains: " + bl);
                        if (bl2) {
                            if (bl) {
                                sticky.add(fileSystem);
                                shineAway.remove(fileSystem);
                                defaultTask.store();
                            }
                        } else if (!bl) {
                            sticky.remove(fileSystem);
                            shineAway.add(fileSystem);
                            defaultTask.store();
                        }
                    }
                    DblTask.this.removeTaskListener(DblTask.this);
                    this.ev = null;
                }
            }
            RequestProcessor.Task task = RP.post((Runnable)new Run(repositoryEvent));
            task.addTaskListener((TaskListener)this);
            this.updateTask = task;
        }
    }
}

