/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.util.LinkedList;
import java.util.StringTokenizer;
import javax.swing.JList;
import javax.swing.JScrollPane;
import org.netbeans.beaninfo.editors.StringArrayCustomEditor;
import org.netbeans.beaninfo.editors.StringArrayCustomizable;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.editors.XMLPropertyEditor;
import org.openide.nodes.Node;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StringArrayEditor
implements XMLPropertyEditor,
StringArrayCustomizable,
ExPropertyEditor {
    private static final String XML_STRING_ARRAY = "StringArray";
    private static final String XML_STRING_ITEM = "StringItem";
    private static final String ATTR_COUNT = "count";
    private static final String ATTR_INDEX = "index";
    private static final String ATTR_VALUE = "value";
    private String[] strings;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private boolean editable = true;
    private String separator = ",";

    public Object getValue() {
        return this.strings;
    }

    public void setValue(Object object) {
        this.strings = (String[])object;
        this.support.firePropertyChange("", null, null);
    }

    public String[] getStringArray() {
        return (String[])this.getValue();
    }

    public void setStringArray(String[] stringArray) {
        this.setValue(stringArray);
    }

    protected final String getStrings(boolean bl) {
        if (this.strings == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.strings.length; ++i) {
            stringBuffer.append(bl ? "\"" + this.strings[i] + "\"" : this.strings[i]);
            if (i == this.strings.length - 1) continue;
            stringBuffer.append(this.separator);
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public String getAsText() {
        return this.getStrings(false);
    }

    public void setAsText(String string) {
        String[] stringArray;
        if (string.equals("null")) {
            this.setValue(null);
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, this.separator);
        LinkedList<String> linkedList = new LinkedList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            stringArray = stringTokenizer.nextToken();
            linkedList.add(stringArray.trim());
        }
        stringArray = linkedList.toArray(new String[linkedList.size()]);
        this.setValue(stringArray);
    }

    public String getJavaInitializationString() {
        if (this.strings == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer("new String[] {");
        stringBuffer.append(this.getStrings(true));
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public String[] getTags() {
        return null;
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
    }

    public boolean supportsCustomEditor() {
        return this.editable || this.strings != null && this.strings.length != 0;
    }

    public Component getCustomEditor() {
        if (this.editable) {
            return new StringArrayCustomEditor(this);
        }
        return new JScrollPane(new JList<String>(this.getStringArray()));
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public Node storeToXML(Document document) {
        Element element = document.createElement(XML_STRING_ARRAY);
        int n = this.strings != null ? this.strings.length : 0;
        element.setAttribute(ATTR_COUNT, Integer.toString(n));
        for (int i = 0; i < n; ++i) {
            Element element2 = document.createElement(XML_STRING_ITEM);
            element2.setAttribute(ATTR_INDEX, Integer.toString(i));
            element2.setAttribute(ATTR_VALUE, this.strings[i]);
            element.appendChild(element2);
        }
        return element;
    }

    public void readFromXML(Node node) throws IOException {
        String[] stringArray;
        if (!XML_STRING_ARRAY.equals(node.getNodeName())) {
            throw new IOException();
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = null;
        int n = 0;
        node2 = namedNodeMap.getNamedItem(ATTR_COUNT);
        if (node2 != null && (n = Integer.parseInt(node2.getNodeValue())) > 0) {
            stringArray = new String[n];
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                int n2;
                Element element;
                if (nodeList.item(i).getNodeType() != 1 || !(element = (Element)nodeList.item(i)).getNodeName().equals(XML_STRING_ITEM)) continue;
                String string = element.getAttribute(ATTR_INDEX);
                String string2 = element.getAttribute(ATTR_VALUE);
                if (string == null || string2 == null || (n2 = Integer.parseInt(string)) < 0 || n2 >= n) continue;
                stringArray[n2] = string2;
            }
        } else {
            stringArray = new String[]{};
        }
        this.setValue(stringArray);
    }

    public void attachEnv(PropertyEnv propertyEnv) {
        FeatureDescriptor featureDescriptor = propertyEnv.getFeatureDescriptor();
        this.readEnv(propertyEnv.getFeatureDescriptor());
    }

    final void readEnv(FeatureDescriptor featureDescriptor) {
        this.editable = featureDescriptor instanceof Node.Property ? ((Node.Property)featureDescriptor).canWrite() : (featureDescriptor instanceof PropertyDescriptor ? ((PropertyDescriptor)featureDescriptor).getWriteMethod() != null : true);
        Object object = featureDescriptor.getValue("item.separator");
        if (object instanceof String) {
            this.separator = (String)object;
        }
    }
}

