/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JSplitPane;
import javax.swing.border.EmptyBorder;
import org.netbeans.beaninfo.ExplorerPanel;
import org.openide.ErrorManager;
import org.openide.ServiceType;
import org.openide.explorer.propertysheet.PropertySheetView;
import org.openide.explorer.view.ListView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.BeanNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ServiceTypePanel
extends ExplorerPanel {
    private int width_components = 0;
    private int width_leftcomponent = 0;
    private Class clazz;
    private List services;
    private ServiceType none;
    private boolean createNew = false;
    static final long serialVersionUID = 861345226525021334L;
    private JSplitPane jSplitPane1;
    private JLabel label;
    private ListView listView1;
    private PropertySheetView propertySheetView1;

    public ServiceTypePanel(Class clazz, String string, ServiceType serviceType, boolean bl) {
        this.clazz = clazz;
        this.none = serviceType;
        this.createNew = bl;
        this.update();
        this.initComponents();
        this.handleDividerLocation();
        this.label.setText(string);
        this.listView1.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)ServiceTypePanel.class).getString("ACSD_ServiceTypeList"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)ServiceTypePanel.class).getString("ACSD_ServiceTypePanel"));
        this.getExplorerManager().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName() == "selectedNodes") {
                    ServiceTypePanel.this.firePropertyChange("helpCtx", null, null);
                }
                ServiceTypePanel.this.firePropertyChange();
            }
        });
        if (string.length() > 0) {
            this.label.setDisplayedMnemonic(string.charAt(0));
        }
    }

    private void handleDividerLocation() {
        int n = this.listView1.getPreferredSize().width;
        int n2 = this.propertySheetView1.getPreferredSize().width;
        int n3 = this.jSplitPane1.getPreferredSize().width;
        int n4 = (int)((float)n / (float)(n + n2) * (float)n3);
        if (n4 > 0) {
            this.jSplitPane1.setDividerLocation(n4);
        }
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public void setServiceType(ServiceType serviceType) {
        Node[] nodeArray;
        if (serviceType == null) {
            return;
        }
        int n = -1;
        for (int i = 0; i < this.services.size(); ++i) {
            if (!((ServiceType)this.services.get(i)).getName().equals(serviceType.getName())) continue;
            n = i;
        }
        if (n < 0) {
            ServiceType serviceType2 = this.none;
            this.none = serviceType;
            this.update();
            this.none = serviceType2;
            n = this.services.indexOf(serviceType);
        }
        if (n < 0) {
            ErrorManager.getDefault().log(1, "ServiceTypePanel: Unable to add service " + serviceType.getName());
            n = 0;
        }
        if (n >= (nodeArray = this.getExplorerManager().getRootContext().getChildren().getNodes()).length) {
            return;
        }
        try {
            this.getExplorerManager().setSelectedNodes(new Node[]{nodeArray[n]});
        }
        catch (PropertyVetoException propertyVetoException) {
            ErrorManager.getDefault().notify(1, (Throwable)propertyVetoException);
        }
        this.firePropertyChange();
    }

    public ServiceType getServiceType() {
        Node[] nodeArray = this.getExplorerManager().getSelectedNodes();
        if (nodeArray.length > 0) {
            return ((MN)nodeArray[0]).getServiceType();
        }
        return null;
    }

    void firePropertyChange() {
        this.firePropertyChange("serviceType", null, null);
    }

    private void update() {
        Children.Array array = new Children.Array();
        AbstractNode abstractNode = new AbstractNode((Children)array);
        array.add(this.nodes().toArray(new Node[0]));
        this.getExplorerManager().setRootContext((Node)abstractNode);
        this.setActivatedNodes(new Node[0]);
    }

    private List nodes() {
        this.services = new ArrayList(20);
        LinkedList<MN> linkedList = new LinkedList<MN>();
        ServiceType.Registry registry = (ServiceType.Registry)Lookup.getDefault().lookup(ServiceType.Registry.class);
        Enumeration enumeration = registry.services(this.clazz);
        while (enumeration.hasMoreElements()) {
            try {
                Object e = enumeration.nextElement();
                if (this.createNew) {
                    Object obj = e.getClass().newInstance();
                    linkedList.add(new MN((ServiceType)obj));
                    this.services.add(obj);
                    continue;
                }
                linkedList.add(new MN((ServiceType)e));
                this.services.add(e);
            }
            catch (IntrospectionException introspectionException) {
                ErrorManager.getDefault().notify(1, (Throwable)introspectionException);
            }
            catch (InstantiationException instantiationException) {
                ErrorManager.getDefault().notify(1, (Throwable)instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                ErrorManager.getDefault().notify(1, (Throwable)illegalAccessException);
            }
        }
        try {
            if (this.none != null) {
                linkedList.add(new MN(this.none));
                this.services.add(this.none);
            }
        }
        catch (IntrospectionException introspectionException) {
            ErrorManager.getDefault().notify(1, (Throwable)introspectionException);
        }
        return linkedList;
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.listView1 = new ListView();
        this.propertySheetView1 = new PropertySheetView();
        this.label = new JLabel();
        this.setLayout(new BorderLayout(0, 2));
        this.setBorder(new EmptyBorder(new Insets(12, 12, 0, 11)));
        this.jSplitPane1.setDividerSize(5);
        this.jSplitPane1.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                ServiceTypePanel.this.jSplitPane1ComponentResized(componentEvent);
            }
        });
        this.listView1.setDefaultProcessor(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        this.listView1.setPopupAllowed(false);
        this.listView1.setSelectionMode(1);
        this.listView1.setTraversalAllowed(false);
        this.listView1.addComponentListener((ComponentListener)new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                ServiceTypePanel.this.listView1ComponentResized(componentEvent);
            }
        });
        this.jSplitPane1.setLeftComponent((Component)this.listView1);
        this.jSplitPane1.setRightComponent((Component)this.propertySheetView1);
        this.add(this.jSplitPane1, "Center");
        this.label.setLabelFor((Component)this.listView1);
        this.add(this.label, "North");
    }

    private void listView1ComponentResized(ComponentEvent componentEvent) {
        this.width_leftcomponent = this.listView1.getWidth();
    }

    private void jSplitPane1ComponentResized(ComponentEvent componentEvent) {
        if (this.width_components > 0 && this.width_leftcomponent > 0) {
            int n = this.listView1.getWidth() + this.propertySheetView1.getWidth();
            int n2 = n * this.width_leftcomponent / this.width_components;
            this.jSplitPane1.setDividerLocation(n2);
            this.width_leftcomponent = n2;
            this.width_components = n;
        } else {
            this.width_leftcomponent = this.listView1.getWidth();
            this.width_components = this.width_leftcomponent + this.propertySheetView1.getWidth();
        }
    }

    private void removeButtonPressed(ActionEvent actionEvent) {
    }

    private void addButtonPressed(ActionEvent actionEvent) {
    }

    private final class MN
    extends BeanNode {
        public MN(ServiceType serviceType) throws IntrospectionException {
            super((Object)serviceType);
        }

        public ServiceType getServiceType() {
            return (ServiceType)this.getBean();
        }

        public Node.PropertySet[] getPropertySets() {
            final Node.PropertySet[] propertySetArray = super.getPropertySets();
            if (ServiceTypePanel.this.createNew) {
                return propertySetArray;
            }
            Node.PropertySet[] propertySetArray2 = new Node.PropertySet[propertySetArray.length];
            for (int i = 0; i < propertySetArray.length; ++i) {
                final int n = i;
                propertySetArray2[i] = new Node.PropertySet(){
                    {
                        this.setName(propertySetArray[n].getName());
                        this.setDisplayName(propertySetArray[n].getDisplayName());
                        this.setShortDescription(propertySetArray[n].getShortDescription());
                    }

                    public Node.Property[] getProperties() {
                        Node.Property[] propertyArray = propertySetArray[n].getProperties();
                        ArrayList<Node.Property> arrayList = new ArrayList<Node.Property>();
                        for (int i = 0; i < propertyArray.length; ++i) {
                            if (propertyArray[i].getName().equals("name")) continue;
                            arrayList.add(propertyArray[i]);
                        }
                        return arrayList.toArray(new Node.Property[arrayList.size()]);
                    }
                };
            }
            return propertySetArray2;
        }
    }
}

