/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.awt.Component;
import java.awt.Point;
import java.util.Date;
import org.netbeans.beaninfo.editors.ArrayOfIntSupport;
import org.netbeans.beaninfo.editors.DimensionEditor;
import org.netbeans.beaninfo.editors.PointCustomEditor;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public class PointEditor
extends ArrayOfIntSupport {
    public PointEditor() {
        super("java.awt.Point", 2);
    }

    int[] getValues() {
        Point point = (Point)this.getValue();
        return new int[]{point.x, point.y};
    }

    void setValues(int[] nArray) {
        if (nArray[0] < 0 || nArray[1] < 0) {
            String string = NbBundle.getMessage((Class)DimensionEditor.class, (String)"CTL_NegativeSize");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Negative value");
            ErrorManager.getDefault().annotate((Throwable)illegalArgumentException, 256, illegalArgumentException.getMessage(), string, null, new Date());
            throw illegalArgumentException;
        }
        this.setValue(new Point(nArray[0], nArray[1]));
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        return new PointCustomEditor(this);
    }

    String getHintFormat() {
        return NbBundle.getMessage((Class)PointEditor.class, (String)"CTL_HintFormatPE");
    }

    protected String getXMLValueTag() {
        return "Point";
    }
}

