/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.util.Arrays;
import java.util.Date;
import org.netbeans.beaninfo.editors.ExPropertyEditorSupport;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.util.NbBundle;

public class IntEditor
extends ExPropertyEditorSupport {
    public static final String KEYS = "stringKeys";
    public static final String VALS = "intValues";
    public static final String CODE_VALS = "codeValues";
    String[] keys = null;
    String[] code = null;
    int[] values = null;

    protected void attachEnvImpl(PropertyEnv propertyEnv) {
        this.keys = (String[])propertyEnv.getFeatureDescriptor().getValue(KEYS);
        this.values = (int[])propertyEnv.getFeatureDescriptor().getValue(VALS);
        this.code = (String[])propertyEnv.getFeatureDescriptor().getValue(CODE_VALS);
    }

    protected void validateEnv(PropertyEnv propertyEnv) {
        boolean bl;
        boolean bl2 = bl = this.keys == null && this.values == null && this.code == null;
        if (!bl) {
            boolean bl3 = bl = this.keys != null && this.values != null;
            if (!bl) {
                throw new ExPropertyEditorSupport.EnvException("You must specify both an array of keys and an array of values if you specify one. Keys=" + IntEditor.arrToStr(this.keys) + " Values=" + IntEditor.arrToStr(this.values));
            }
            boolean bl4 = bl = this.keys.length == this.values.length;
            if (bl) {
                boolean bl5 = bl = this.keys.length > 0 && this.values.length > 0;
            }
            if (!bl) {
                throw new ExPropertyEditorSupport.EnvException("The arrays of keys and values must have the same length and the length must be > 0. keys.length =" + this.keys.length + " values.length=" + this.values.length + " Keys=" + IntEditor.arrToStr(this.keys) + " Values=" + IntEditor.arrToStr(this.values));
            }
            if (this.code != null) {
                boolean bl6 = bl = this.code.length == this.keys.length;
                if (bl) {
                    boolean bl7 = bl = this.code.length > 0;
                }
                if (!bl) {
                    throw new ExPropertyEditorSupport.EnvException("The arrays of keys and values and codes must all have the same length, > 0. keys.length =" + this.keys.length + " values.length=" + this.values.length + " Code.length=" + this.code.length + " Keys=" + IntEditor.arrToStr(this.keys) + " Values=" + IntEditor.arrToStr(this.values) + " Code=" + IntEditor.arrToStr(this.code));
                }
            }
        }
    }

    private static final String arrToStr(int[] nArray) {
        if (nArray == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer(nArray.length * 3);
        for (int i = 0; i < nArray.length; ++i) {
            stringBuffer.append(nArray[i]);
            if (i == nArray.length - 1) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    private String getStringRep(int n) {
        if (this.keys != null) {
            try {
                return this.keys[n];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new IllegalArgumentException("This property editor uses a set of keyed values, and the value " + n + " is out of range.");
            }
        }
        return Integer.toString(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getAsText() {
        Integer n = (Integer)this.getValue();
        if (n == null) return NbBundle.getMessage((Class)IntEditor.class, (String)"NULL");
        if (this.keys == null) return this.getValue().toString();
        int n2 = n;
        int n3 = -1;
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] != n2) continue;
            n3 = i;
            break;
        }
        if (n3 == -1) throw new IllegalArgumentException("This property editor uses a set of keyed values, and the current value, " + n + ", is not specified.");
        return this.keys[(Integer)super.getValue()];
    }

    private void doSetAsText(String string) {
        try {
            this.setValue(new Integer(Integer.parseInt(string)));
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = NbBundle.getMessage((Class)IntEditor.class, (String)"EXC_ILLEGAL_VALUE_TEXT") + string;
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string2);
            ErrorManager.getDefault().annotate((Throwable)illegalArgumentException, 256, string2, string2, (Throwable)numberFormatException, new Date());
            throw illegalArgumentException;
        }
    }

    public void setAsText(String string) {
        string = string.trim();
        if (this.keys == null) {
            this.doSetAsText(string);
        } else {
            int n = Arrays.asList(this.keys).indexOf(string);
            if (n == -1 || n > this.values.length - 1) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(NbBundle.getMessage((Class)IntEditor.class, (String)"EXC_ILLEGAL_STRING_TEXT_FIRST"));
                stringBuffer.append(string);
                stringBuffer.append(NbBundle.getMessage((Class)IntEditor.class, (String)"EXC_ILLEGAL_STRING_TEXT_SECOND"));
                stringBuffer.append(IntEditor.arrToStr(this.keys));
                String string2 = stringBuffer.toString();
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string2);
                ErrorManager.getDefault().annotate((Throwable)illegalArgumentException, 256, string2, string2, (Throwable)illegalArgumentException, new Date());
                throw illegalArgumentException;
            }
            this.setValue(new Integer(n));
        }
    }

    public Object getValue() {
        Integer n = (Integer)super.getValue();
        if (this.values != null) {
            n = new Integer(this.values[n]);
        }
        return n;
    }

    public void setValue(Object object) {
        if (!(object instanceof Integer) && object != null) {
            throw new IllegalArgumentException("Argument to IntEditor.setValue() must be Integer, but was " + object.getClass().getName() + "(=" + object.toString() + ")");
        }
        super.setValue(object);
    }

    public String[] getTags() {
        return this.keys;
    }

    public String getJavaInitializationString() {
        String string = this.code == null ? this.getValue().toString() : this.code[(Integer)this.getValue()];
        return string;
    }
}

