/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.HashMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.netbeans.beaninfo.editors.InsetsEditor;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.util.NbBundle;

public class InsetsCustomEditor
extends JPanel
implements EnhancedCustomPropertyEditor,
KeyListener {
    static final long serialVersionUID = -1472891501739636852L;
    private HashMap labelMap = new HashMap();
    private PropertyEnv env;
    private JPanel jPanel2;
    private JLabel xLabel;
    private JTextField xField;
    private JLabel yLabel;
    private JTextField yField;
    private JLabel widthLabel;
    private JTextField widthField;
    private JLabel heightLabel;
    private JTextField heightField;
    private InsetsEditor editor;

    public InsetsCustomEditor(InsetsEditor insetsEditor, PropertyEnv propertyEnv) {
        this.env = propertyEnv;
        this.initComponents();
        this.editor = insetsEditor;
        Insets insets = (Insets)insetsEditor.getValue();
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        this.xField.setText(Integer.toString(insets.top));
        this.yField.setText(Integer.toString(insets.left));
        this.widthField.setText(Integer.toString(insets.bottom));
        this.heightField.setText(Integer.toString(insets.right));
        this.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        this.jPanel2.setBorder(new CompoundBorder(new TitledBorder(new EtchedBorder(), " " + NbBundle.getMessage((Class)InsetsCustomEditor.class, (String)"CTL_Insets") + " "), new EmptyBorder(new Insets(5, 5, 5, 5))));
        this.xLabel.setText(NbBundle.getMessage((Class)InsetsCustomEditor.class, (String)"CTL_Top"));
        this.yLabel.setText(NbBundle.getMessage((Class)InsetsCustomEditor.class, (String)"CTL_Left"));
        this.widthLabel.setText(NbBundle.getMessage((Class)InsetsCustomEditor.class, (String)"CTL_Bottom"));
        this.heightLabel.setText(NbBundle.getMessage((Class)InsetsCustomEditor.class, (String)"CTL_Right"));
        this.xLabel.setLabelFor(this.xField);
        this.yLabel.setLabelFor(this.yField);
        this.widthLabel.setLabelFor(this.widthField);
        this.heightLabel.setLabelFor(this.heightField);
        this.xLabel.setDisplayedMnemonic(NbBundle.getMessage((Class)InsetsCustomEditor.class, (String)"CTL_Top_Mnemonic").charAt(0));
        this.yLabel.setDisplayedMnemonic(NbBundle.getMessage((Class)InsetsCustomEditor.class, (String)"CTL_Left_Mnemonic").charAt(0));
        this.widthLabel.setDisplayedMnemonic(NbBundle.getMessage((Class)InsetsCustomEditor.class, (String)"CTL_Bottom_Mnemonic").charAt(0));
        this.heightLabel.setDisplayedMnemonic(NbBundle.getMessage((Class)InsetsCustomEditor.class, (String)"CTL_Right_Mnemonic").charAt(0));
        this.xField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)InsetsCustomEditor.class, (String)"ACSD_CTL_Top"));
        this.yField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)InsetsCustomEditor.class, (String)"ACSD_CTL_Left"));
        this.widthField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)InsetsCustomEditor.class, (String)"ACSD_CTL_Bottom"));
        this.heightField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)InsetsCustomEditor.class, (String)"ACSD_CTL_Right"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)InsetsCustomEditor.class, (String)"ACSD_CustomRectangleEditor"));
        this.labelMap.put(this.widthField, this.widthLabel);
        this.labelMap.put(this.xField, this.xLabel);
        this.labelMap.put(this.yField, this.yLabel);
        this.labelMap.put(this.heightField, this.heightLabel);
    }

    public Dimension getPreferredSize() {
        return new Dimension(280, 160);
    }

    public Object getPropertyValue() throws IllegalStateException {
        try {
            int n = Integer.parseInt(this.xField.getText());
            int n2 = Integer.parseInt(this.yField.getText());
            int n3 = Integer.parseInt(this.widthField.getText());
            int n4 = Integer.parseInt(this.heightField.getText());
            if (n < 0 || n2 < 0 || n3 < 0 || n4 < 0) {
                IllegalStateException illegalStateException = new IllegalStateException();
                ErrorManager.getDefault().annotate((Throwable)illegalStateException, 256, null, NbBundle.getMessage((Class)InsetsCustomEditor.class, (String)"CTL_NegativeSize"), null, null);
                throw illegalStateException;
            }
            return new Insets(n, n2, n3, n4);
        }
        catch (NumberFormatException numberFormatException) {
            IllegalStateException illegalStateException = new IllegalStateException();
            ErrorManager.getDefault().annotate((Throwable)illegalStateException, 256, null, NbBundle.getMessage((Class)InsetsCustomEditor.class, (String)"CTL_InvalidValue"), null, null);
            throw illegalStateException;
        }
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.jPanel2 = new JPanel();
        this.jPanel2.setLayout(new GridBagLayout());
        this.xLabel = new JLabel();
        this.xLabel.setText(null);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.xLabel, gridBagConstraints);
        this.xField = new JTextField();
        this.xField.addKeyListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 8, 4, 0);
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.xField, gridBagConstraints);
        this.yLabel = new JLabel();
        this.yLabel.setText(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.yLabel, gridBagConstraints);
        this.yField = new JTextField();
        this.yField.addKeyListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 8, 4, 0);
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.yField, gridBagConstraints);
        this.widthLabel = new JLabel();
        this.widthLabel.setText(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.widthLabel, gridBagConstraints);
        this.widthField = new JTextField();
        this.widthField.addKeyListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 8, 4, 0);
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.widthField, gridBagConstraints);
        this.heightLabel = new JLabel();
        this.heightLabel.setText(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.heightLabel, gridBagConstraints);
        this.heightField = new JTextField();
        this.heightField.addKeyListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 8, 4, 0);
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.heightField, gridBagConstraints);
        this.add((Component)this.jPanel2, "Center");
    }

    private void updateRectangle() {
        try {
            int n = Integer.parseInt(this.xField.getText());
            int n2 = Integer.parseInt(this.yField.getText());
            int n3 = Integer.parseInt(this.widthField.getText());
            int n4 = Integer.parseInt(this.heightField.getText());
            this.editor.setValue(new Rectangle(n, n2, n3, n4));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (this.checkValues()) {
            this.updateRectangle();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    private boolean checkValues() {
        Component[] componentArray = this.jPanel2.getComponents();
        boolean bl = true;
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof JTextField)) continue;
            bl &= this.validFor((JTextField)componentArray[i]);
        }
        if (this.env != null) {
            this.env.setState(bl ? PropertyEnv.STATE_VALID : PropertyEnv.STATE_INVALID);
        }
        return bl;
    }

    private boolean validFor(JTextField jTextField) {
        String string = jTextField.getText().trim();
        try {
            Integer.parseInt(string);
            this.handleValid(jTextField);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            this.handleInvalid(jTextField);
            return false;
        }
    }

    private void handleInvalid(JTextField jTextField) {
        jTextField.setForeground(this.getErrorColor());
        this.findLabelFor(jTextField).setForeground(this.getErrorColor());
    }

    private void handleValid(JTextField jTextField) {
        jTextField.setForeground(this.getForeground());
        this.findLabelFor(jTextField).setForeground(this.getForeground());
    }

    private Color getErrorColor() {
        Color color = UIManager.getColor("nb.errorForeground");
        if (color == null) {
            color = Color.RED;
        }
        return color;
    }

    private JLabel findLabelFor(JTextField jTextField) {
        return (JLabel)this.labelMap.get(jTextField);
    }
}

