/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.beaninfo.ExplorerPanel;
import org.netbeans.core.ActionsPoolNode;
import org.openide.ErrorManager;
import org.openide.awt.Actions;
import org.openide.cookies.InstanceCookie;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class LoaderActionsPanel
extends JPanel
implements EnhancedCustomPropertyEditor,
ListCellRenderer {
    private DefaultListModel model;
    private ExplorerManager mgr;
    private JButton addButton;
    private BeanTreeView beanTreeView2;
    private JButton downButton;
    private ExplorerPanel explorerPanel;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JList list;
    private JButton removeButton;
    private JButton separatorButton;
    private JSplitPane splitPane;
    private JButton upButton;
    static final /* synthetic */ boolean $assertionsDisabled;

    public LoaderActionsPanel(PropertyEditor propertyEditor) {
        this.initComponents();
        this.model = new DefaultListModel();
        SystemAction[] systemActionArray = (SystemAction[])propertyEditor.getValue();
        if (systemActionArray == null) {
            systemActionArray = new SystemAction[]{};
        }
        for (int i = 0; i < systemActionArray.length; ++i) {
            this.model.addElement(systemActionArray[i]);
        }
        this.list.setModel(this.model);
        this.mgr = this.explorerPanel.getExplorerManager();
        this.mgr.setRootContext((Node)new ActionsPoolNode());
        this.mgr.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
                    SystemAction systemAction = LoaderActionsPanel.findAction(LoaderActionsPanel.this.mgr.getSelectedNodes());
                    LoaderActionsPanel.this.addButton.setEnabled(systemAction != null);
                }
            }
        });
        this.splitPane.setDividerLocation(300);
        ResourceBundle resourceBundle = NbBundle.getBundle((Class)LoaderActionsPanel.class);
        this.addButton.setMnemonic(resourceBundle.getString("LoaderActionsPanel.jButton1.mnemonic").charAt(0));
        this.separatorButton.setMnemonic(resourceBundle.getString("LoaderActionsPanel.jButton2.mnemonic").charAt(0));
        this.removeButton.setMnemonic(resourceBundle.getString("LoaderActionsPanel.jButton3.mnemonic").charAt(0));
        this.upButton.setMnemonic(resourceBundle.getString("LoaderActionsPanel.jButton4.mnemonic").charAt(0));
        this.downButton.setMnemonic(resourceBundle.getString("LoaderActionsPanel.jButton5.mnemonic").charAt(0));
        this.beanTreeView2.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACS_LoaderActionsPanel.beanTreeView"));
        this.beanTreeView2.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_LoaderActionsPanel.beanTreeView"));
        this.list.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACS_LoaderActionsPanel.list"));
        this.list.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_LoaderActionsPanel.list"));
        this.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_LoaderActionsPanel"));
    }

    private void initComponents() {
        this.splitPane = new JSplitPane();
        this.explorerPanel = new ExplorerPanel();
        this.beanTreeView2 = new BeanTreeView();
        this.jScrollPane1 = new JScrollPane();
        this.list = new JList();
        this.jPanel2 = new JPanel();
        this.jPanel1 = new JPanel();
        this.addButton = new JButton();
        this.separatorButton = new JButton();
        this.removeButton = new JButton();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.setLayout(new BorderLayout(11, 0));
        this.setBorder(new EmptyBorder(new Insets(12, 12, 0, 11)));
        this.setPreferredSize(new Dimension(600, 500));
        this.splitPane.setLastDividerLocation(300);
        this.beanTreeView2.setDefaultActionAllowed(false);
        this.beanTreeView2.setPopupAllowed(false);
        this.explorerPanel.add((Component)this.beanTreeView2, "Center");
        this.splitPane.setLeftComponent((Component)((Object)this.explorerPanel));
        this.list.setSelectionMode(0);
        this.list.setCellRenderer(this);
        this.list.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                LoaderActionsPanel.this.listFocusGained(focusEvent);
            }
        });
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                LoaderActionsPanel.this.listValueChanged(listSelectionEvent);
            }
        });
        this.jScrollPane1.setViewportView(this.list);
        this.splitPane.setRightComponent(this.jScrollPane1);
        this.add((Component)this.splitPane, "Center");
        this.jPanel2.setLayout(new FlowLayout(1, 0, 0));
        this.jPanel1.setLayout(new GridBagLayout());
        this.addButton.setToolTipText(ResourceBundle.getBundle("org/netbeans/beaninfo/Bundle").getString("LoaderActionsPanel.jButton1.toolTipText"));
        this.addButton.setText(ResourceBundle.getBundle("org/netbeans/beaninfo/Bundle").getString("LoaderActionsPanel.jButton1.text"));
        this.addButton.setEnabled(false);
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LoaderActionsPanel.this.addButtonActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel1.add((Component)this.addButton, gridBagConstraints);
        this.separatorButton.setToolTipText(ResourceBundle.getBundle("org/netbeans/beaninfo/Bundle").getString("LoaderActionsPanel.jButton2.toolTipText"));
        this.separatorButton.setText(ResourceBundle.getBundle("org/netbeans/beaninfo/Bundle").getString("LoaderActionsPanel.jButton2.text"));
        this.separatorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LoaderActionsPanel.this.separatorButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel1.add((Component)this.separatorButton, gridBagConstraints);
        this.removeButton.setToolTipText(ResourceBundle.getBundle("org/netbeans/beaninfo/Bundle").getString("LoaderActionsPanel.jButton3.toolTipText"));
        this.removeButton.setText(ResourceBundle.getBundle("org/netbeans/beaninfo/Bundle").getString("LoaderActionsPanel.jButton3.text"));
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LoaderActionsPanel.this.removeButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.jPanel1.add((Component)this.removeButton, gridBagConstraints);
        this.upButton.setToolTipText(ResourceBundle.getBundle("org/netbeans/beaninfo/Bundle").getString("LoaderActionsPanel.jButton4.toolTipText"));
        this.upButton.setText(ResourceBundle.getBundle("org/netbeans/beaninfo/Bundle").getString("LoaderActionsPanel.jButton4.text"));
        this.upButton.setEnabled(false);
        this.upButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LoaderActionsPanel.this.upButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel1.add((Component)this.upButton, gridBagConstraints);
        this.downButton.setToolTipText(ResourceBundle.getBundle("org/netbeans/beaninfo/Bundle").getString("LoaderActionsPanel.jButton5.toolTipText"));
        this.downButton.setText(ResourceBundle.getBundle("org/netbeans/beaninfo/Bundle").getString("LoaderActionsPanel.jButton5.text"));
        this.downButton.setEnabled(false);
        this.downButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LoaderActionsPanel.this.downButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        this.jPanel1.add((Component)this.downButton, gridBagConstraints);
        this.jPanel2.add(this.jPanel1);
        this.add((Component)this.jPanel2, "East");
    }

    private void listFocusGained(FocusEvent focusEvent) {
        if (this.list.getSelectedIndex() == -1 && this.list.getModel().getSize() > 0) {
            this.list.setSelectedIndex(0);
        }
    }

    private void listValueChanged(ListSelectionEvent listSelectionEvent) {
        int n = this.list.getSelectedIndex();
        if (n == -1) {
            this.downButton.setEnabled(false);
            this.upButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        } else {
            this.removeButton.setEnabled(true);
            this.downButton.setEnabled(n != this.model.getSize() - 1);
            this.upButton.setEnabled(n != 0);
        }
    }

    private void downButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.list.getSelectedIndex();
        if (n == -1 || n == this.model.getSize() - 1) {
            return;
        }
        Object e = this.model.elementAt(n);
        this.model.setElementAt(this.model.elementAt(n + 1), n);
        this.model.setElementAt(e, n + 1);
        this.list.setSelectedIndex(n + 1);
    }

    private void upButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.list.getSelectedIndex();
        if (n == -1 || n == 0) {
            return;
        }
        Object e = this.model.elementAt(n);
        this.model.setElementAt(this.model.elementAt(n - 1), n);
        this.model.setElementAt(e, n - 1);
        this.list.setSelectedIndex(n - 1);
    }

    private void removeButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.list.getSelectedIndex();
        if (n == -1) {
            return;
        }
        this.model.remove(n);
        if (this.model.getSize() == 0) {
            this.list.setSelectedIndices(new int[0]);
        } else {
            this.list.setSelectedIndex(Math.min(n, this.model.getSize() - 1));
        }
    }

    private void separatorButtonActionPerformed(ActionEvent actionEvent) {
        this.model.addElement(null);
        this.list.setSelectedIndex(this.model.getSize() - 1);
    }

    private void addButtonActionPerformed(ActionEvent actionEvent) {
        Node[] nodeArray = this.mgr.getSelectedNodes();
        SystemAction systemAction = LoaderActionsPanel.findAction(nodeArray);
        if (systemAction != null) {
            this.model.addElement(systemAction);
        }
        this.list.setSelectedIndex(this.model.getSize() - 1);
    }

    private static SystemAction findAction(Node[] nodeArray) {
        if (nodeArray == null || nodeArray.length == 0 || nodeArray.length > 1) {
            return null;
        }
        InstanceCookie instanceCookie = (InstanceCookie)nodeArray[0].getCookie(InstanceCookie.class);
        if (instanceCookie == null) {
            return null;
        }
        try {
            Class clazz = instanceCookie.instanceClass();
            if (!SystemAction.class.isAssignableFrom(clazz)) {
                return null;
            }
            return (SystemAction)instanceCookie.instanceCreate();
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, (Throwable)exception);
            return null;
        }
    }

    public Object getPropertyValue() throws IllegalStateException {
        Object[] objectArray = new SystemAction[this.model.getSize()];
        this.model.copyInto(objectArray);
        return objectArray;
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        JLabel jLabel;
        block10: {
            jLabel = new JLabel();
            if (object != null) {
                SystemAction systemAction = (SystemAction)object;
                try {
                    String string = systemAction.getName();
                    if (string == null) {
                        string = NbBundle.getBundle((Class)LoaderActionsPanel.class).getString("LBL_no_system_action_name");
                    }
                    jLabel.setText(Actions.cutAmpersand((String)string));
                    Icon icon = systemAction.getIcon();
                    if (icon != null) {
                        jLabel.setIcon(icon);
                    }
                }
                catch (RuntimeException runtimeException) {
                    ErrorManager.getDefault().notify(1, (Throwable)runtimeException);
                }
            } else {
                jLabel.setText(NbBundle.getBundle((Class)LoaderActionsPanel.class).getString("LBL_separator_rather_than_action"));
                try {
                    jLabel.setIcon(new ImageIcon(new URL("nbresloc:/org/openide/resources/actions/empty.gif")));
                }
                catch (MalformedURLException malformedURLException) {
                    if ($assertionsDisabled) break block10;
                    throw new AssertionError((Object)malformedURLException);
                }
            }
        }
        if (bl) {
            jLabel.setBackground(jList.getSelectionBackground());
            jLabel.setForeground(jList.getSelectionForeground());
        } else {
            jLabel.setBackground(jList.getBackground());
            jLabel.setForeground(jList.getForeground());
        }
        jLabel.setEnabled(jList.isEnabled());
        jLabel.setFont(jList.getFont());
        jLabel.setOpaque(true);
        return jLabel;
    }

    static {
        $assertionsDisabled = !LoaderActionsPanel.class.desiredAssertionStatus();
    }
}

