/*
 * Decompiled with CFR 0.152.
 */
package tr.view.projects;

import java.awt.BorderLayout;
import java.awt.EventQueue;
import java.io.Serializable;
import java.util.Collection;
import java.util.logging.Logger;
import javax.swing.ActionMap;
import javax.swing.JScrollPane;
import org.openide.ErrorManager;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.TreeView;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import tr.model.Data;
import tr.model.DataLookup;
import tr.model.Item.Item;
import tr.model.action.Action;
import tr.model.project.Project;
import tr.view.Window;
import tr.view.projects.ActionNode;
import tr.view.projects.EditorTopComponent;
import tr.view.projects.ProjectNode;
import tr.view.projects.ProjectRootNode;
import tr.view.projects.Resources;

public class ProjectsTreeTopComponent
extends Window
implements ExplorerManager.Provider,
LookupListener {
    private static final Logger LOG = Logger.getLogger("tr.view.projects");
    private static final String PREFERRED_ID = "ProjectsTopComponent";
    private static ProjectsTreeTopComponent instance;
    private final transient ExplorerManager manager = new ExplorerManager();
    private transient boolean initialised;
    private transient Lookup.Result dataResult;
    private transient Lookup.Result itemResult;
    private JScrollPane projectsPane;

    protected ProjectsTreeTopComponent() {
        this.setName(this.getText("CTL_ProjectsTopComponent"));
        this.setToolTipText(this.getText("TTT_ProjectsTopComponent"));
        this.setIcon(Resources.ICON_PROJECTS.getImage());
        this.initComponents();
        this.initialise();
    }

    private void initComponents() {
        this.projectsPane = new BeanTreeView();
        this.setLayout(new BorderLayout());
        this.add(this.projectsPane, "Center");
    }

    private void initialise() {
        Data data;
        if (this.initialised) {
            return;
        }
        if (this.dataResult == null) {
            this.dataResult = DataLookup.instance().lookup(new Lookup.Template(Data.class));
            this.dataResult.addLookupListener(new LookupListener(){

                public void resultChanged(LookupEvent lookupEvent) {
                    ProjectsTreeTopComponent.this.initialised = false;
                }
            });
        }
        if ((data = (Data)DataLookup.instance().lookup(Data.class)) == null) {
            return;
        }
        this.manager.setRootContext((Node)new ProjectRootNode(data.getRootProjects(), false));
        this.manager.getRootContext().setDisplayName(this.getText("CTL_ProjectsNode"));
        ActionMap map = this.getActionMap();
        map.put("copy-to-clipboard", ExplorerUtils.actionCopy((ExplorerManager)this.manager));
        map.put("cut-to-clipboard", ExplorerUtils.actionCut((ExplorerManager)this.manager));
        map.put("paste-from-clipboard", ExplorerUtils.actionPaste((ExplorerManager)this.manager));
        map.put("delete", ExplorerUtils.actionDelete((ExplorerManager)this.manager, (boolean)true));
        try {
            this.associateLookup(ExplorerUtils.createLookup((ExplorerManager)this.manager, (ActionMap)map));
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.initialised = true;
    }

    public void componentOpened() {
        super.componentOpened();
        this.initialise();
    }

    private void addItemListener() {
        this.itemResult = this.getLookup().lookup(new Lookup.Template(Item.class));
        this.itemResult.addLookupListener((LookupListener)this);
        this.itemResult.allInstances();
    }

    private void removeItemListener() {
        if (this.itemResult != null) {
            this.itemResult.removeLookupListener((LookupListener)this);
            this.itemResult = null;
        }
    }

    public void componentActivated() {
        super.componentActivated();
        this.initialise();
        this.addItemListener();
        Node[] selectedNodes = this.manager.getSelectedNodes();
        if (selectedNodes == null || selectedNodes.length == 0) {
            try {
                this.manager.setSelectedNodes(new Node[]{this.manager.getRootContext()});
            }
            catch (Exception ex) {}
        } else if (selectedNodes[0] instanceof ProjectNode) {
            final Project project = ((ProjectNode)selectedNodes[0]).project;
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    EditorTopComponent.findInstance().view(project);
                }
            });
        } else if (selectedNodes[0] instanceof ActionNode) {
            final Action action = ((ActionNode)selectedNodes[0]).action;
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    EditorTopComponent.findInstance().view(action);
                }
            });
        }
    }

    protected void componentDeactivated() {
        super.componentDeactivated();
        this.removeItemListener();
    }

    public void resultChanged(LookupEvent lookupEvent) {
        if (this.itemResult == null) {
            return;
        }
        Collection instances = this.itemResult.allInstances();
        if (instances == null || instances.isEmpty()) {
            return;
        }
        final Object item = instances.iterator().next();
        if (item instanceof Action) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    EditorTopComponent.findInstance().view((Action)item);
                }
            });
        } else if (item instanceof Project) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    EditorTopComponent.findInstance().view((Project)item);
                }
            });
        }
    }

    public void clearSelection() {
        try {
            this.manager.setSelectedNodes(new Node[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getText(String key) {
        return NbBundle.getMessage(ProjectsTreeTopComponent.class, (String)key);
    }

    public TreeView getTreeView() {
        return (TreeView)this.projectsPane;
    }

    public static synchronized ProjectsTreeTopComponent getDefault() {
        if (instance == null) {
            instance = new ProjectsTreeTopComponent();
        }
        return instance;
    }

    public static synchronized ProjectsTreeTopComponent findInstance() {
        TopComponent tc = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (tc == null) {
            ErrorManager.getDefault().log(16, "Cannot find Projects component. It will not be located properly in the window system.");
            return ProjectsTreeTopComponent.getDefault();
        }
        if (tc instanceof ProjectsTreeTopComponent) {
            return (ProjectsTreeTopComponent)tc;
        }
        ErrorManager.getDefault().log(16, "There seem to be multiple components with the 'ProjectsTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return ProjectsTreeTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("tr.view.projects.projects");
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    public void setShowDone(boolean b) {
        ProjectRootNode rootNode = (ProjectRootNode)this.manager.getRootContext();
        rootNode.setShowDone(b);
    }

    public synchronized void select(Action action) {
        if (!this.isOpened()) {
            return;
        }
        if (action.isSingleAction()) {
            return;
        }
        ProjectNode rootNode = (ProjectNode)this.manager.getRootContext();
        Node node = rootNode.find(action);
        if (node == null) {
            return;
        }
        this.requestVisible();
        try {
            this.manager.setSelectedNodes(new Node[]{node});
        }
        catch (Exception ex) {
            LOG.severe("Action node could not be selected in the tree.");
        }
    }

    public synchronized void select(Project project) {
        if (!this.isOpened()) {
            return;
        }
        ProjectNode rootNode = (ProjectNode)this.manager.getRootContext();
        Node node = rootNode.find(project);
        if (node == null) {
            return;
        }
        this.requestVisible();
        try {
            this.manager.setSelectedNodes(new Node[]{node});
        }
        catch (Exception ex) {
            LOG.severe("Project node could not be selected in the tree.");
        }
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return ProjectsTreeTopComponent.getDefault();
        }
    }
}

