/*
 * Decompiled with CFR 0.152.
 */
package tr.view.projects;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.commons.lang.StringEscapeUtils;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.DeleteAction;
import org.openide.actions.MoveDownAction;
import org.openide.actions.MoveUpAction;
import org.openide.actions.PasteAction;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.TreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.Lookups;
import tr.model.Data;
import tr.model.DataLookup;
import tr.model.IDGenerator;
import tr.model.Item.Item;
import tr.model.action.Action;
import tr.model.action.ActionState;
import tr.model.action.ActionStateASAP;
import tr.model.action.ActionStateInactive;
import tr.model.action.ActionStateScheduled;
import tr.model.project.Project;
import tr.model.project.Sequencing;
import tr.model.topic.Topic;
import tr.model.topic.TopicChangeCookie;
import tr.prefs.projects.ProjectsPrefs;
import tr.util.HTML;
import tr.util.Observable;
import tr.util.Observer;
import tr.view.projects.AddActionAction;
import tr.view.projects.AddActionCookie;
import tr.view.projects.AddProjectAction;
import tr.view.projects.AddProjectCookie;
import tr.view.projects.CollapseAllAction;
import tr.view.projects.CollapseAllCookie;
import tr.view.projects.EditAction;
import tr.view.projects.EditCookie;
import tr.view.projects.EditorTopComponent;
import tr.view.projects.ExpandAllAction;
import tr.view.projects.ExpandAllCookie;
import tr.view.projects.HideDoneAction;
import tr.view.projects.HideDoneCookie;
import tr.view.projects.ProjectChildren;
import tr.view.projects.ProjectsTreeLookup;
import tr.view.projects.Resources;
import tr.view.projects.SearchableNode;
import tr.view.projects.ShowDoneAction;
import tr.view.projects.ShowDoneCookie;
import tr.view.projects.TransferNode;
import tr.view.topic.TopicChangeAction;

public class ProjectNode
extends AbstractNode
implements Observer,
EditCookie,
SearchableNode,
ShowDoneCookie,
HideDoneCookie,
CollapseAllCookie,
ExpandAllCookie,
TransferNode,
AddActionCookie,
AddProjectCookie {
    private static final Logger LOG = Logger.getLogger("tr.view.projects");
    public final Project project;
    protected boolean showDone;
    public static final int MASK_ANY = 7;
    private int transferType;

    public ProjectNode(Project project, boolean showDone) {
        this(new ProjectChildren(project, showDone));
    }

    public ProjectNode(ProjectChildren projectChildren) {
        super((Children)projectChildren, Lookups.singleton((Object)projectChildren.project));
        this.showDone = projectChildren.showDone;
        this.project = projectChildren.project;
        this.project.addObserver((Observer)this);
    }

    public String getName() {
        return this.project.getDescription();
    }

    public void setName(String name) {
        super.setName(name);
    }

    private String escapeHTML(String str) {
        str = StringEscapeUtils.escapeXml((String)str);
        return str.replace("&apos;", "'");
    }

    public String getHtmlDisplayName() {
        String name = this.escapeHTML(this.getName());
        String color = HTML.format((Color)this.project.getTopic().getForeground());
        if (this.project.isDone()) {
            return "<s><font color='" + color + "'>" + name + "</font></s>";
        }
        return "<font color='" + color + "'>" + name + "</font>";
    }

    private Image getIcon(int type, boolean opened) {
        Icon icon = this.project.getIcon(opened);
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage();
        }
        return super.getIcon(type);
    }

    public Image getIcon(int type) {
        return this.getIcon(type, false);
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type, true);
    }

    public PasteType getDropType(Transferable t, int type, int index) {
        Node dropNode = NodeTransfer.node((Transferable)t, (int)7);
        if (dropNode != null && dropNode instanceof TransferNode) {
            Project p;
            final TransferNode transferNode = (TransferNode)dropNode;
            final boolean isMove = this.isMoveTransfer(type) || transferNode.isMoveTransfer();
            Action dropAction = (Action)dropNode.getLookup().lookup(Action.class);
            if (dropAction != null) {
                Action transferAction;
                Action action = transferAction = isMove ? dropAction : (Action)dropAction.copy((IDGenerator)this.getData());
                if (transferAction != null && this.project.canAdd((Item)transferAction)) {
                    return new PasteType(){

                        public Transferable paste() throws IOException {
                            if (isMove) {
                                ProjectNode.this.move(transferAction, transferNode);
                            } else {
                                transferAction.setThought(null);
                                ProjectNode.this.project.add((Item)transferAction);
                            }
                            return null;
                        }
                    };
                }
            }
            if ((p = (Project)dropNode.getLookup().lookup(Project.class)) != null) {
                Project transferProject;
                Project project = transferProject = isMove ? p : (Project)p.copy((IDGenerator)this.getData());
                if (transferProject != null && this.project.canAdd((Item)transferProject)) {
                    return new PasteType(){

                        public Transferable paste() throws IOException {
                            if (isMove) {
                                ProjectNode.this.move(transferProject, transferNode);
                            } else {
                                transferProject.setThought(null);
                                ProjectNode.this.project.add((Item)transferProject);
                            }
                            return null;
                        }
                    };
                }
            }
        }
        return null;
    }

    protected void move(final Action transferAction, final TransferNode transferNode) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                transferAction.removeFromParent();
                ProjectNode.this.project.add((Item)transferAction);
                transferNode.setTransferType(1);
                ProjectNode.this.select(transferAction);
            }
        });
    }

    protected void move(final Project transferProject, final TransferNode transferNode) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                transferProject.removeFromParent();
                ProjectNode.this.project.add((Item)transferProject);
                transferNode.setTransferType(1);
                ProjectNode.this.select(transferProject);
            }
        });
    }

    private void select(Object object) {
        try {
            this.getExplorerManager().setSelectedNodes(new Node[0]);
        }
        catch (Exception ex) {
            // empty catch block
        }
        Node node = this.find(object);
        if (node == null) {
            return;
        }
        try {
            this.getExplorerManager().setSelectedNodes(new Node[]{node});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void createPasteTypes(Transferable t, List s) {
        super.createPasteTypes(t, s);
        PasteType paste = this.getDropType(t, 1, -1);
        if (paste != null) {
            s.add(paste);
        }
    }

    public Node.Cookie getCookie(Class clazz) {
        if (clazz == Index.class) {
            return ((ProjectChildren)this.getChildren()).getIndex();
        }
        if (clazz == EditCookie.class) {
            return this;
        }
        if (clazz == ExpandAllCookie.class) {
            return this;
        }
        if (clazz == CollapseAllCookie.class) {
            return this;
        }
        if (clazz == ShowDoneCookie.class) {
            return this;
        }
        if (clazz == HideDoneCookie.class) {
            return this;
        }
        if (clazz == AddActionCookie.class) {
            return this;
        }
        if (clazz == AddProjectCookie.class) {
            return this;
        }
        if (clazz == TopicChangeCookie.class) {
            return this.project;
        }
        Children ch = this.getChildren();
        if (clazz.isInstance(ch)) {
            return (Node.Cookie)ch;
        }
        return super.getCookie(clazz);
    }

    public javax.swing.Action[] getActions(boolean popup) {
        return new javax.swing.Action[]{SystemAction.get(EditAction.class), null, SystemAction.get(ExpandAllAction.class), SystemAction.get(CollapseAllAction.class), null, SystemAction.get(ShowDoneAction.class), SystemAction.get(HideDoneAction.class), null, SystemAction.get(AddActionAction.class), SystemAction.get(AddProjectAction.class), null, SystemAction.get(CopyAction.class), SystemAction.get(CutAction.class), SystemAction.get(PasteAction.class), null, SystemAction.get(DeleteAction.class), null, SystemAction.get(MoveUpAction.class), SystemAction.get(MoveDownAction.class), null, SystemAction.get(TopicChangeAction.class)};
    }

    public javax.swing.Action getPreferredAction() {
        return SystemAction.get(EditAction.class);
    }

    public boolean canCopy() {
        return true;
    }

    public boolean canCut() {
        return true;
    }

    public boolean canDestroy() {
        return true;
    }

    public void destroy() throws IOException {
        this.project.removeFromParent();
    }

    public boolean canRename() {
        return false;
    }

    public synchronized void update(Observable observable, Object object) {
        if (this.project.equals((Object)observable) && object == null) {
            this.setName(this.project.getDescription());
        }
        this.fireIconChange();
        this.fireOpenedIconChange();
    }

    public Node find(Object o) {
        Node node;
        if (this.project.equals(o)) {
            return this;
        }
        Node result = null;
        Node[] arr$ = this.getChildren().getNodes();
        int len$ = arr$.length;
        for (int i$ = 0; !(i$ >= len$ || (node = arr$[i$]) instanceof SearchableNode && (result = ((SearchableNode)node).find(o)) != null); ++i$) {
        }
        return result;
    }

    public boolean isShowDone() {
        return this.showDone;
    }

    public synchronized void setShowDone(boolean showDone) {
        this.showDone = showDone;
        try {
            this.setChildren((Children)new ProjectChildren(this.project, showDone));
        }
        catch (Exception ex) {
            LOG.warning(ex.getMessage());
        }
        this.fireCookieChange();
        this.getTreeView().expandNode((Node)this);
    }

    public TreeView getTreeView() {
        return ProjectsTreeLookup.lookup().getTreeView();
    }

    public ExplorerManager getExplorerManager() {
        return ProjectsTreeLookup.lookup().getExplorerManager();
    }

    public Transferable clipboardCut() throws IOException {
        this.setTransferType(2);
        return super.clipboardCut();
    }

    public Transferable clipboardCopy() throws IOException {
        this.setTransferType(1);
        return super.clipboardCopy();
    }

    public void setTransferType(int type) {
        this.transferType = type;
    }

    public boolean isMoveTransfer() {
        return (this.transferType & 2) != 0;
    }

    protected boolean isMoveTransfer(int type) {
        return (type & 2) != 0;
    }

    public boolean isCopyTransfer() {
        return (this.transferType & 1) != 0;
    }

    protected Data getData() {
        return (Data)DataLookup.instance().lookup(Data.class);
    }

    public void addAction() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ProjectNode.this.addNewAction();
            }
        });
    }

    private void addNewAction() {
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        if (data == null) {
            return;
        }
        Action newAction = new Action((IDGenerator)data);
        newAction.setDescription(Resources.getText("NewActionDescr"));
        newAction.setTopic(this.project.getTopic());
        ProjectsPrefs.ActionState defState = ProjectsPrefs.getNewActionState();
        switch (defState) {
            case INACTIVE: {
                newAction.setState((ActionState)new ActionStateInactive());
                break;
            }
            case DOASAP: {
                newAction.setState((ActionState)new ActionStateASAP());
                break;
            }
            case SCHEDULED: {
                newAction.setState((ActionState)new ActionStateScheduled());
                break;
            }
            case DELEGATED: {
                newAction.setState((ActionState)new ActionStateScheduled());
            }
        }
        this.project.add((Item)newAction);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        Node node = this.find(newAction);
        if (node == null) {
            return;
        }
        try {
            this.getExplorerManager().setSelectedNodes(new Node[]{node});
        }
        catch (PropertyVetoException ex) {
            // empty catch block
        }
        this.getTreeView().requestFocus();
        this.edit(newAction);
    }

    public void addProject() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ProjectNode.this.addNewProject();
            }
        });
    }

    private void addNewProject() {
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        if (data == null) {
            return;
        }
        Project newProject = new Project((IDGenerator)data);
        newProject.setDescription(Resources.getText("NewProjectDescr"));
        newProject.setTopic(this.project.getTopic());
        if (this.project.isRoot()) {
            if (ProjectsPrefs.isSequencing()) {
                newProject.setSequencing(true);
                newProject.setSequenceType(Sequencing.INTO_SUBPROJECTS);
            }
        } else {
            newProject.setSequencing(this.project.isSequencing());
            newProject.setSequenceType(this.project.getSequenceType());
        }
        this.project.add((Item)newProject);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        Node node = this.find(newProject);
        if (node == null) {
            return;
        }
        try {
            this.getExplorerManager().setSelectedNodes(new Node[]{node});
        }
        catch (PropertyVetoException ex) {
            // empty catch block
        }
        this.getTreeView().requestFocus();
        this.edit(newProject);
    }

    public void edit() {
        EditorTopComponent.findInstance().edit(this.project);
    }

    public void edit(Action action) {
        EditorTopComponent.findInstance().edit(action);
    }

    public void edit(Project project) {
        EditorTopComponent.findInstance().edit(project);
    }

    public void changeTopic(Topic topic) {
        this.project.setTopic(topic);
    }
}

