/*
 * Decompiled with CFR 0.152.
 */
package tr.view.projects;

import java.beans.PropertyVetoException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Children;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.util.WeakListeners;
import tr.model.Item.Doable;
import tr.model.Item.Item;
import tr.model.action.Action;
import tr.model.project.Project;
import tr.util.Observable;
import tr.util.Observer;
import tr.view.projects.ActionNode;
import tr.view.projects.ProjectNode;
import tr.view.projects.ProjectsTreeLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectChildren
extends Children.Keys
implements Observer,
ChangeListener {
    private static final Logger LOG = Logger.getLogger("tr.view.projects");
    public final Project project;
    public final boolean showDone;
    private Index index;

    public ProjectChildren(Project project, boolean showDone) {
        this.project = project;
        this.showDone = showDone;
    }

    private Collection<Item> getItems() {
        if (this.project == null) {
            return Collections.EMPTY_SET;
        }
        Vector<Item> items = new Vector<Item>();
        Iterator i = this.project.iterator(Item.class);
        while (i.hasNext()) {
            Item item = (Item)i.next();
            if (!this.showDone && item instanceof Doable && ((Doable)item).isDone()) continue;
            items.add(item);
        }
        return items;
    }

    protected Node[] createNodes(Object key) {
        if (key instanceof Project) {
            return new Node[]{new ProjectNode((Project)key, this.showDone)};
        }
        if (key instanceof Action) {
            return new Node[]{new ActionNode((Action)key)};
        }
        return new Node[0];
    }

    protected void addNotify() {
        this.setKeys(this.getItems());
        if (this.project != null) {
            this.project.addObserver((Observer)this);
        }
        super.addNotify();
    }

    protected void removeNotify() {
        this.setKeys(Collections.EMPTY_SET);
        if (this.project != null) {
            this.project.removeObserver((Observer)this);
        }
        super.removeNotify();
    }

    public void update(Observable observable, Object arg) {
        if (arg != null && this.project.equals((Object)observable)) {
            this.setKeys(this.getItems());
        }
    }

    public Index getIndex() {
        if (this.index == null) {
            this.index = new IndexImpl(this);
            this.index.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)this.index));
        }
        return this.index;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.setKeys(this.getItems());
    }

    protected ExplorerManager getExplorerManager() {
        return ProjectsTreeLookup.lookup().getExplorerManager();
    }

    private class IndexImpl
    extends Index.Support {
        private final ProjectChildren children;

        public IndexImpl(ProjectChildren children) {
            this.children = children;
        }

        public Node[] getNodes() {
            return this.children.getNodes();
        }

        public int getNodesCount() {
            return this.children.getNodesCount();
        }

        public synchronized void reorder(int[] perm) {
            ExplorerManager explorerManager = ProjectChildren.this.getExplorerManager();
            Node[] selectedNodes = explorerManager.getSelectedNodes();
            Node[] nodes = this.getNodes();
            if (nodes.length != perm.length) {
                LOG.info("Error number of nodes different in permutation.");
                return;
            }
            Item[] srcItems = new Item[perm.length];
            for (int i = 0; i < perm.length; ++i) {
                if (nodes[i] instanceof ProjectNode) {
                    srcItems[i] = ((ProjectNode)nodes[i]).project;
                } else if (nodes[i] instanceof ActionNode) {
                    srcItems[i] = ((ActionNode)nodes[i]).action;
                }
                if (srcItems[i] != null) continue;
                LOG.info("Source item is null error.");
                return;
            }
            Item[] dstItems = new Item[perm.length];
            for (int i = 0; i < perm.length; ++i) {
                if (nodes[perm[i]] instanceof ProjectNode) {
                    dstItems[i] = ((ProjectNode)nodes[perm[i]]).project;
                } else if (nodes[perm[i]] instanceof ActionNode) {
                    dstItems[i] = ((ActionNode)nodes[perm[i]]).action;
                }
                if (dstItems[i] != null) continue;
                LOG.info("Destination item is null error.");
                return;
            }
            ProjectChildren.this.project.reorder(srcItems, dstItems);
            this.fireChangeEvent(new ChangeEvent((Object)this));
            try {
                explorerManager.setSelectedNodes(selectedNodes);
            }
            catch (PropertyVetoException ex) {
                LOG.info("Node selection failed. " + ex.getMessage());
            }
        }
    }
}

