/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.layers;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.netbeans.core.startup.layers.LayerCacheManager;
import org.openide.filesystems.FileSystem;
import org.openide.util.NotImplementedException;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public abstract class ParsingLayerCacheManager
extends LayerCacheManager
implements ContentHandler,
ErrorHandler,
EntityResolver {
    private static final String[] ATTR_TYPES = new String[]{"boolvalue", "bytevalue", "charvalue", "doublevalue", "floatvalue", "intvalue", "longvalue", "methodvalue", "newvalue", "serialvalue", "shortvalue", "stringvalue", "urlvalue"};
    private static final String DTD_1_0 = "-//NetBeans//DTD Filesystem 1.0//EN";
    private static final String DTD_1_1 = "-//NetBeans//DTD Filesystem 1.1//EN";
    private Locator locator;
    private MemFolder root;
    private Stack curr;
    private URL base;
    private StringBuffer buf = new StringBuffer();
    private int fileCount;
    private int folderCount;
    private int attrCount;
    private Set oneLayerFiles;
    private boolean checkingForDuplicates;
    private String currPath;

    protected ParsingLayerCacheManager(File file) throws IOException {
        super(file);
    }

    public final void store(FileSystem fileSystem, List list) throws IOException {
        this.store(fileSystem, this.createRoot(list));
    }

    public final FileSystem store(List list) throws IOException {
        return this.store(this.createRoot(list));
    }

    private MemFolder createRoot(List arrayList) throws IOException {
        this.root = new MemFolder(null);
        this.curr = new Stack();
        this.curr.push(this.root);
        try {
            XMLReader xMLReader = XMLUtil.createXMLReader();
            xMLReader.setFeature("http://xml.org/sax/features/validation", false);
            xMLReader.setFeature("http://xml.org/sax/features/namespaces", false);
            xMLReader.setFeature("http://xml.org/sax/features/string-interning", true);
            xMLReader.setContentHandler(this);
            xMLReader.setErrorHandler(this);
            xMLReader.setEntityResolver(this);
            Exception exception = null;
            arrayList = new ArrayList(arrayList);
            Collections.reverse(arrayList);
            this.checkingForDuplicates = LayerCacheManager.err.isLoggable(16);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                this.base = (URL)iterator.next();
                if (this.checkingForDuplicates) {
                    this.oneLayerFiles = new HashSet(100);
                    this.currPath = null;
                }
                LayerCacheManager.err.log("Parsing: " + this.base);
                try {
                    xMLReader.parse(this.base.toExternalForm());
                }
                catch (Exception exception2) {
                    this.curr.clear();
                    this.curr.push(this.root);
                    LayerCacheManager.err.log("Caught " + exception2 + " while parsing: " + this.base);
                    if (exception == null) {
                        exception = exception2;
                        continue;
                    }
                    LayerCacheManager.err.annotate((Throwable)exception, (Throwable)exception2);
                }
            }
            if (exception != null) {
                throw exception;
            }
            LayerCacheManager.err.log("Finished layer parsing; " + this.fileCount + " files, " + this.folderCount + " folders, " + this.attrCount + " attributes");
            MemFolder memFolder = this.root;
            return memFolder;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            IOException iOException = new IOException(exception.toString());
            LayerCacheManager.err.annotate((Throwable)iOException, (Throwable)exception);
            throw iOException;
        }
        finally {
            this.attrCount = 0;
            this.folderCount = 0;
            this.fileCount = 0;
            this.base = null;
            this.locator = null;
            this.curr = null;
            this.root = null;
            this.oneLayerFiles = null;
            this.currPath = null;
        }
    }

    protected void store(FileSystem fileSystem, MemFolder memFolder) throws IOException {
        throw new NotImplementedException();
    }

    protected FileSystem store(MemFolder memFolder) throws IOException {
        throw new NotImplementedException();
    }

    protected abstract boolean openURLs();

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string3 == "filesystem") {
            return;
        }
        if (string3 == "folder") {
            this.fileOrFolder(string3, attributes);
        } else if (string3 == "file") {
            MemFile memFile = (MemFile)this.fileOrFolder(string3, attributes);
            memFile.contents = null;
            String string4 = attributes.getValue("url");
            if (string4 != null) {
                try {
                    memFile.ref = new URL(this.base, string4);
                }
                catch (MalformedURLException malformedURLException) {
                    SAXException sAXException = new SAXException(malformedURLException.toString());
                    LayerCacheManager.err.annotate((Throwable)sAXException, (Throwable)malformedURLException);
                    throw sAXException;
                }
            } else {
                memFile.ref = null;
            }
        } else if (string3 == "attr") {
            Object object;
            ++this.attrCount;
            MemAttr memAttr = new MemAttr();
            for (int i = 0; i < attributes.getLength(); ++i) {
                object = attributes.getQName(i);
                if ("name".equals(object)) {
                    memAttr.name = attributes.getValue(i);
                } else {
                    int n = Arrays.binarySearch(ATTR_TYPES, object);
                    if (n >= 0) {
                        memAttr.type = ATTR_TYPES[n];
                        memAttr.data = attributes.getValue(i);
                    }
                }
                if (memAttr.name != null && memAttr.data != null) break;
            }
            if (memAttr.type == null) {
                throw new SAXParseException("unknown <attr> value type for " + memAttr.name, this.locator);
            }
            MemFileOrFolder memFileOrFolder = (MemFileOrFolder)this.curr.peek();
            if (memFileOrFolder.attrs == null) {
                memFileOrFolder.attrs = new LinkedList();
            }
            object = memFileOrFolder.attrs.iterator();
            while (object.hasNext()) {
                if (!((MemAttr)object.next()).name.equals(memAttr.name)) continue;
                --this.attrCount;
                object.remove();
            }
            memFileOrFolder.attrs.add(memAttr);
            if (this.checkingForDuplicates && !this.oneLayerFiles.add(this.currPath + "//" + memAttr.name)) {
                LayerCacheManager.err.log(16, "Warning: layer " + this.base + " contains duplicate attributes " + memAttr.name + " for " + this.currPath);
            }
        } else {
            throw new SAXException(string3);
        }
    }

    private MemFileOrFolder fileOrFolder(String string, Attributes attributes) {
        String string2 = attributes.getValue("name");
        if (string2 == null) {
            throw new NullPointerException("No name");
        }
        if (!(this.curr.peek() instanceof MemFolder)) {
            throw new ClassCastException("Stack: " + this.curr);
        }
        MemFolder memFolder = (MemFolder)this.curr.peek();
        MemFileOrFolder memFileOrFolder = null;
        if (memFolder.children == null) {
            memFolder.children = new LinkedList();
        } else {
            Iterator iterator = memFolder.children.iterator();
            while (iterator.hasNext()) {
                MemFileOrFolder memFileOrFolder2 = (MemFileOrFolder)iterator.next();
                if (!memFileOrFolder2.name.equals(string2)) continue;
                memFileOrFolder = memFileOrFolder2;
                break;
            }
        }
        if (memFileOrFolder == null) {
            if (string == "folder") {
                memFileOrFolder = new MemFolder(this.base);
                ++this.folderCount;
            } else {
                memFileOrFolder = new MemFile(this.base);
                ++this.fileCount;
            }
            memFileOrFolder.name = string2;
            memFolder.children.add(memFileOrFolder);
        }
        this.curr.push(memFileOrFolder);
        if (this.checkingForDuplicates) {
            this.currPath = this.currPath == null ? string2 : this.currPath + "/" + string2;
            if (!this.oneLayerFiles.add(this.currPath)) {
                LayerCacheManager.err.log(16, "Warning: layer " + this.base + " contains duplicate " + string + "s named " + this.currPath);
            }
        }
        return memFileOrFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endElement(String string, String string2, String string3) throws SAXException {
        Object object;
        Object object2;
        if (string3 == "file" && this.buf.length() > 0) {
            object2 = this.buf.toString().trim();
            if (((String)object2).length() > 0) {
                object = (MemFile)this.curr.peek();
                if (((MemFile)object).ref != null) {
                    throw new SAXParseException("CDATA plus url= in <file>", this.locator);
                }
                LayerCacheManager.err.log(16, "Warning: use of inline CDATA text contents in <file name=\"" + ((MemFile)object).name + "\"> deprecated for performance and charset safety at " + this.locator.getSystemId() + ":" + this.locator.getLineNumber() + ". Please use the 'url' attribute instead, or the file attribute 'originalFile' on *.shadow files (with IDE/1 > 2.23).");
                ((MemFile)object).contents = ((String)object2).getBytes();
            }
            this.buf.setLength(0);
        }
        if (string3 == "file" && this.openURLs()) {
            object2 = (MemFile)this.curr.peek();
            if (((MemFile)object2).ref != null && ((MemFile)object2).ref.toExternalForm().startsWith("jar:file:")) {
                try {
                    object = ((MemFile)object2).ref.openConnection();
                    ((URLConnection)object).connect();
                    byte[] byArray = new byte[((URLConnection)object).getContentLength()];
                    InputStream inputStream = ((URLConnection)object).getInputStream();
                    try {
                        int n;
                        for (int i = 0; i < byArray.length; i += n) {
                            n = inputStream.read(byArray, i, byArray.length - i);
                            if (n >= 1) continue;
                            throw new IOException("Premature EOF on " + ((MemFile)object2).ref.toExternalForm());
                        }
                        if (inputStream.read() != -1) {
                            throw new IOException("Delayed EOF on " + ((MemFile)object2).ref.toExternalForm());
                        }
                    }
                    finally {
                        inputStream.close();
                    }
                    ((MemFile)object2).contents = byArray;
                    ((MemFile)object2).ref = null;
                }
                catch (IOException iOException) {
                    throw new SAXException(iOException);
                }
            }
        }
        if (string3 == "file" || string3 == "folder") {
            this.curr.pop();
            if (this.checkingForDuplicates) {
                int n = this.currPath.lastIndexOf(47);
                this.currPath = n == -1 ? null : this.currPath.substring(0, n);
            }
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        Object e = this.curr.peek();
        if (!(e instanceof MemFile)) {
            return;
        }
        this.buf.append(cArray, n, n2);
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        LayerCacheManager.err.notify(1, (Throwable)sAXParseException);
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
        if (string != null && (string.equals(DTD_1_0) || string.equals(DTD_1_1))) {
            return new InputSource(new ByteArrayInputStream(new byte[0]));
        }
        return null;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void endDocument() throws SAXException {
        if (this.curr.size() != 1) {
            throw new SAXException("Wrong stack: " + this.curr);
        }
    }

    public void startDocument() throws SAXException {
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
    }

    public void skippedEntity(String string) throws SAXException {
    }

    public void processingInstruction(String string, String string2) throws SAXException {
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    public void endPrefixMapping(String string) throws SAXException {
    }

    protected static final class MemAttr {
        public String name;
        public String type;
        public String data;

        protected MemAttr() {
        }

        public String toString() {
            return "MemAttr[" + this.name + "," + this.type + "," + this.data + "]";
        }
    }

    protected static final class MemFile
    extends MemFileOrFolder {
        public byte[] contents = null;
        public URL ref = null;

        public MemFile(URL uRL) {
            super(uRL);
        }

        public String toString() {
            return "MemFile[" + this.name + "]";
        }
    }

    protected static abstract class MemFileOrFolder {
        public String name;
        public List attrs = null;
        public final URL base;

        public MemFileOrFolder(URL uRL) {
            this.base = uRL;
        }
    }

    protected static final class MemFolder
    extends MemFileOrFolder {
        public List children = null;

        public MemFolder(URL uRL) {
            super(uRL);
        }

        public String toString() {
            return "MemFolder[" + this.name + "]";
        }
    }
}

