/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.layers;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.LocalFileSystem;
import org.openide.filesystems.Repository;

public final class LocalFileSystemEx
extends LocalFileSystem {
    private static HashMap allLocks = new HashMap(7);
    private static HashSet pLocks = new HashSet(7);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getLocks() {
        HashMap hashMap = allLocks;
        synchronized (hashMap) {
            LocalFileSystemEx.removeInvalid(pLocks);
            LinkedList linkedList = new LinkedList();
            linkedList.addAll(allLocks.keySet());
            linkedList.addAll(pLocks);
            return linkedList.toArray(new String[linkedList.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasLocks() {
        HashMap hashMap = allLocks;
        synchronized (hashMap) {
            LocalFileSystemEx.removeInvalid(pLocks);
            return !allLocks.isEmpty() || !pLocks.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void potentialLock(String string) {
        HashMap hashMap = allLocks;
        synchronized (hashMap) {
            pLocks.add(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void potentialLock(String string, String string2) {
        HashMap hashMap = allLocks;
        synchronized (hashMap) {
            if (pLocks.remove(string)) {
                pLocks.add(string2);
            }
        }
    }

    private static void removeInvalid(Set set) {
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (null != fileSystem.findResource(string)) continue;
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lock(String string) throws IOException {
        super.lock(string);
        HashMap hashMap = allLocks;
        synchronized (hashMap) {
            FileObject fileObject = this.findResource(string);
            allLocks.put(string, fileObject);
            pLocks.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unlock(String string) {
        HashMap hashMap = allLocks;
        synchronized (hashMap) {
            if (allLocks.containsKey(string)) {
                allLocks.remove(string);
            } else {
                FileObject fileObject = this.findResource(string);
                if (fileObject != null) {
                    Iterator iterator = allLocks.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        if (!fileObject.equals(entry.getValue())) continue;
                        allLocks.remove(entry.getKey());
                        break;
                    }
                } else {
                    ErrorManager.getDefault().notify(1, new Throwable("Can't unlock file " + string + ", it's lock was not found or it wasn't locked."));
                }
            }
        }
        super.unlock(string);
    }
}

