/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import org.netbeans.core.startup.CLIOptions;
import org.openide.ErrorManager;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class TopLogging {
    public static final String LOG_FILE_NAME = "messages.log";
    private static final boolean disabledConsole = !Boolean.getBoolean("netbeans.logger.console");
    private PrintStream logPrintStream;
    private static TopLogging topLogging;
    private static final long LOG_MAX_SIZE;
    private static final int LOG_COUNT;

    TopLogging(String string) throws IOException {
        topLogging = this;
        DateFormat dateFormat = DateFormat.getDateTimeInstance(0, 0, Locale.US);
        Date date = new Date();
        if (string == null) {
            this.logPrintStream = System.err;
            this.logPrintStream.println("-------------------------------------------------------------------------------");
            this.logPrintStream.println(">Log Session: " + dateFormat.format(date));
            this.logPrintStream.println(">System Info: ");
            try {
                TopLogging.printSystemInfo(this.logPrintStream);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                this.logPrintStream.flush();
            }
            this.logPrintStream.println("-------------------------------------------------------------------------------");
            this.logPrintStream = new PrintStream(new OutputStream(){

                public void write(int n) {
                }
            });
            return;
        }
        BufferedOutputStream bufferedOutputStream = null;
        File file = new File(string);
        if (!file.exists() && !file.mkdirs()) {
            throw new IOException("Cannot make directory to contain log file");
        }
        File file2 = TopLogging.createLogFile(file, LOG_FILE_NAME);
        if (file2.exists() && !file2.canWrite() || file2.isDirectory()) {
            throw new IOException("Cannot write to file");
        }
        bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2.getAbsolutePath(), true));
        PrintStream printStream = System.err;
        this.logPrintStream = new PrintStream((OutputStream)new StreamDemultiplexor(printStream, bufferedOutputStream), false, "UTF-8");
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                TopLogging.this.logPrintStream.flush();
                TopLogging.this.logPrintStream.close();
            }
        });
        this.logPrintStream.println("-------------------------------------------------------------------------------");
        this.logPrintStream.println(">Log Session: " + dateFormat.format(date));
        this.logPrintStream.println(">System Info: ");
        TopLogging.printSystemInfo(this.logPrintStream);
        this.logPrintStream.println("-------------------------------------------------------------------------------");
        System.setErr(this.logPrintStream);
    }

    private static TopLogging getDefault() {
        if (topLogging == null) {
            try {
                new TopLogging(CLIOptions.getLogDir());
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
        return topLogging;
    }

    private static File createLogFile(File file, String string) {
        long l = 0L;
        File file2 = null;
        File file3 = new File(file, string);
        if (!file3.exists() || file3.length() < LOG_MAX_SIZE) {
            return file3;
        }
        for (int i = 1; i < LOG_COUNT; ++i) {
            String string2 = string + "." + i;
            File file4 = new File(file, string2);
            if (!file4.exists()) {
                file2 = file4;
                break;
            }
            long l2 = file4.lastModified();
            if (l != 0L && l2 >= l || l2 <= 0L) continue;
            l = l2;
            file2 = file4;
        }
        if (file2 != null) {
            if (file2.exists()) {
                file2.delete();
            }
            file3.renameTo(file2);
        }
        return file3;
    }

    public static void printSystemInfo(PrintStream printStream) {
        String string = System.getProperty("netbeans.buildnumber");
        String string2 = NbBundle.getMessage((Class)TopLogging.class, (String)"currentVersion", (Object)string);
        printStream.println("  Product Version         = " + string2);
        printStream.println("  Operating System        = " + System.getProperty("os.name", "unknown") + " version " + System.getProperty("os.version", "unknown") + " running on " + System.getProperty("os.arch", "unknown"));
        printStream.println("  Java; VM; Vendor; Home  = " + System.getProperty("java.version", "unknown") + "; " + System.getProperty("java.vm.name", "unknown") + " " + System.getProperty("java.vm.version", "") + "; " + System.getProperty("java.vendor", "unknown") + "; " + System.getProperty("java.home", "unknown"));
        printStream.print("  System Locale; Encoding = " + Locale.getDefault());
        String string3 = NbBundle.getBranding();
        if (string3 != null) {
            printStream.print(" (" + string3 + ")");
        }
        printStream.println("; " + System.getProperty("file.encoding", "unknown"));
        printStream.println("  Home Dir.; Current Dir. = " + System.getProperty("user.home", "unknown") + "; " + System.getProperty("user.dir", "unknown"));
        printStream.print("  Installation; User Dir. = ");
        String string4 = System.getProperty("netbeans.dirs");
        if (string4 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string4, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                printStream.print(FileUtil.normalizeFile((File)new File(stringTokenizer.nextToken())));
                printStream.print(File.pathSeparatorChar);
            }
        }
        printStream.println(CLIOptions.getHomeDir() + "; " + CLIOptions.getUserDir());
        printStream.println("  Boot & Ext. Classpath   = " + TopLogging.createBootClassPath());
        printStream.println("  Application Classpath   = " + System.getProperty("java.class.path", "unknown"));
        printStream.println("  Startup Classpath       = " + System.getProperty("netbeans.dynamic.classpath", "unknown"));
    }

    private static String createBootClassPath() {
        String string = System.getProperty("sun.boot.class.path");
        StringBuffer stringBuffer = string != null ? new StringBuffer(string) : new StringBuffer();
        TopLogging.findBootJars(System.getProperty("java.ext.dirs"), stringBuffer);
        TopLogging.findBootJars(System.getProperty("java.endorsed.dirs"), stringBuffer);
        return stringBuffer.toString();
    }

    private static void findBootJars(String string, StringBuffer stringBuffer) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                File file = new File(stringTokenizer.nextToken());
                File[] fileArray = file.listFiles();
                if (fileArray == null) continue;
                for (int i = 0; i < fileArray.length; ++i) {
                    String string2 = fileArray[i].getName().toLowerCase(Locale.US);
                    if (!string2.endsWith(".zip") && !string2.endsWith(".jar")) continue;
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(File.pathSeparatorChar);
                    }
                    stringBuffer.append(fileArray[i].getPath());
                }
            }
        }
    }

    protected void finalize() throws Throwable {
        this.logPrintStream.flush();
        this.logPrintStream.close();
    }

    public static PrintStream getLogOutputStream() {
        if (System.getProperty("netbeans.user") == null) {
            return System.err;
        }
        return TopLogging.getDefault().logPrintStream;
    }

    static {
        LOG_MAX_SIZE = Long.getLong("org.netbeans.core.TopLogging.LOG_MAX_SIZE", 262144L);
        LOG_COUNT = Integer.getInteger("org.netbeans.core.TopLogging.LOG_COUNT", 3);
    }

    private static final class StreamDemultiplexor
    extends OutputStream
    implements Runnable {
        private RequestProcessor.Task logFlushTask;
        private static final RequestProcessor RP = new RequestProcessor("Flush ide.log");
        private static final Object FLUSH_LOCK = new String("org.netbeans.core.TopLogging.StreamDemultiplexor.FLUSH_LOCK");
        private static final int FLUSH_DELAY = Integer.getInteger("netbeans.logger.flush.delay", 15000);
        private final OutputStream stderr;
        private OutputStream log;

        StreamDemultiplexor(PrintStream printStream, OutputStream outputStream) {
            this.stderr = printStream;
            this.log = outputStream;
        }

        public void write(int n) throws IOException {
            this.log.write(n);
            if (!disabledConsole) {
                this.stderr.write(n);
            }
            this.flushLog();
        }

        public void write(byte[] byArray) throws IOException {
            this.log.write(byArray);
            if (!disabledConsole) {
                this.stderr.write(byArray);
            }
            this.flushLog();
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.log.write(byArray, n, n2);
            if (!disabledConsole) {
                this.stderr.write(byArray, n, n2);
            }
            this.flushLog();
        }

        public void flush() throws IOException {
            this.log.flush();
            this.stderr.flush();
        }

        public void close() throws IOException {
            this.log.close();
            this.stderr.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void flushLog() {
            Object object = FLUSH_LOCK;
            synchronized (object) {
                if (this.logFlushTask == null) {
                    this.logFlushTask = RP.create((Runnable)this);
                    this.logFlushTask.schedule(FLUSH_DELAY);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = FLUSH_LOCK;
            synchronized (object) {
                try {
                    this.flush();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                this.logFlushTask = null;
            }
        }
    }
}

