/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.text.Collator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.netbeans.InvalidException;
import org.netbeans.Module;
import org.netbeans.Util;
import org.openide.modules.Dependency;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;

public final class NbProblemDisplayer {
    private NbProblemDisplayer() {
    }

    public static String messageForProblem(Module module, Object object) {
        if (object instanceof InvalidException) {
            return Util.findLocalizedMessage((Throwable)((InvalidException)((Object)object)), (boolean)true);
        }
        Dependency dependency = (Dependency)object;
        switch (dependency.getType()) {
            case 1: {
                Module module2;
                String string = (String)module.getLocalizedAttribute("OpenIDE-Module-Module-Dependency-Message");
                if (string != null) {
                    return string;
                }
                String string2 = dependency.getName();
                int n = string2.lastIndexOf(47);
                if (n != -1) {
                    string2 = string2.substring(0, n);
                }
                if ((module2 = module.getManager().get(string2)) != null && module2.getCodeName().equals(dependency.getName())) {
                    switch (dependency.getComparison()) {
                        case 3: {
                            return NbBundle.getMessage((Class)NbProblemDisplayer.class, (String)"MSG_problem_other_disabled", (Object)module2.getDisplayName());
                        }
                        case 2: {
                            String string3;
                            String string4 = dependency.getVersion();
                            String string5 = module2.getImplementationVersion() != null ? module2.getImplementationVersion() : (string3 = NbBundle.getMessage((Class)NbProblemDisplayer.class, (String)"LBL_no_impl_version"));
                            if (string4.equals(string3)) {
                                return NbBundle.getMessage((Class)NbProblemDisplayer.class, (String)"MSG_problem_other_disabled", (Object)module2.getDisplayName());
                            }
                            return NbBundle.getMessage((Class)NbProblemDisplayer.class, (String)"MSG_problem_other_wrong_version", (Object)module2.getDisplayName(), (Object)string4, (Object)string3);
                        }
                        case 1: {
                            SpecificationVersion specificationVersion;
                            SpecificationVersion specificationVersion2 = new SpecificationVersion(dependency.getVersion());
                            SpecificationVersion specificationVersion3 = specificationVersion = module2.getSpecificationVersion() != null ? module2.getSpecificationVersion() : new SpecificationVersion("0");
                            if (specificationVersion.compareTo((Object)specificationVersion2) >= 0) {
                                return NbBundle.getMessage((Class)NbProblemDisplayer.class, (String)"MSG_problem_other_disabled", (Object)module2.getDisplayName());
                            }
                            return NbBundle.getMessage((Class)NbProblemDisplayer.class, (String)"MSG_problem_other_too_old", (Object)module2.getDisplayName(), (Object)specificationVersion2, (Object)specificationVersion);
                        }
                    }
                    throw new IllegalStateException();
                }
                return NbBundle.getMessage((Class)NbProblemDisplayer.class, (String)"MSG_problem_other_needed_not_found", (Object)dependency.getName());
            }
            case 5: {
                String string = (String)module.getLocalizedAttribute("OpenIDE-Module-Requires-Message");
                if (string != null) {
                    return string;
                }
                Set set = module.getManager().getModules();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    Module module3 = (Module)iterator.next();
                    if (!module3.provides(dependency.getName())) continue;
                    return NbBundle.getMessage((Class)NbProblemDisplayer.class, (String)"MSG_problem_require_disabled", (Object)dependency.getName());
                }
                return NbBundle.getMessage((Class)NbProblemDisplayer.class, (String)"MSG_problem_require_not_found", (Object)dependency.getName());
            }
            case 2: {
                String string = (String)module.getLocalizedAttribute("OpenIDE-Module-Package-Dependency-Message");
                if (string != null) {
                    return string;
                }
                String string6 = dependency.getName();
                int n = string6.lastIndexOf(91);
                if (n == 0) {
                    return NbBundle.getMessage((Class)NbProblemDisplayer.class, (String)"MSG_problem_class_not_loaded", (Object)string6.substring(1, string6.length() - 1));
                }
                if (n != -1) {
                    return NbBundle.getMessage((Class)NbProblemDisplayer.class, (String)"MSG_problem_package_not_loaded_or_old", (Object)string6.substring(0, n));
                }
                return NbBundle.getMessage((Class)NbProblemDisplayer.class, (String)"MSG_problem_package_not_loaded_or_old", (Object)string6);
            }
            case 3: {
                if (dependency.getName().equals("Java") && dependency.getComparison() == 1) {
                    return NbBundle.getMessage((Class)NbProblemDisplayer.class, (String)"MSG_problem_java_too_old", (Object)dependency.getVersion(), (Object)Dependency.JAVA_SPEC);
                }
                return dependency.toString();
            }
        }
        throw new IllegalArgumentException(dependency.toString());
    }

    static void problemMessagesForModules(StringBuffer stringBuffer, Set set, boolean bl) {
        Object object;
        HashSet<String> hashSet = new HashSet<String>();
        Object object2 = set.iterator();
        while (object2.hasNext()) {
            object = (Module)object2.next();
            hashSet.add(object.getCodeName());
        }
        object2 = new HashSet();
        object = set.iterator();
        while (object.hasNext()) {
            String string;
            Object object3;
            Module module = (Module)object.next();
            TreeSet<Object> treeSet = new TreeSet<Object>(Collator.getInstance());
            Iterator iterator = module.getProblems().iterator();
            if (iterator.hasNext()) {
                while (iterator.hasNext()) {
                    object3 = iterator.next();
                    if (object3 instanceof Dependency && bl && (string = (Dependency)object3).getType() == 1 && hashSet.contains(string.getName())) {
                        ((HashSet)object2).add(module.getCodeName());
                        continue;
                    }
                    treeSet.add(module.getDisplayName() + " - " + NbProblemDisplayer.messageForProblem(module, object3));
                }
            } else {
                throw new IllegalStateException("Module " + module + " could not be installed but had no problems");
            }
            object3 = treeSet.iterator();
            while (object3.hasNext()) {
                string = (String)object3.next();
                stringBuffer.append("\n\t").append(string);
            }
        }
        if (!((HashSet)object2).isEmpty()) {
            stringBuffer.append("\n\t").append(NbBundle.getMessage((Class)NbProblemDisplayer.class, (String)"MSG_also_dep_modules", (Object)new Integer(((HashSet)object2).size())));
        }
    }
}

