/*
 * Decompiled with CFR 0.152.
 */
package tr.view.process.panels;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jdesktop.layout.GroupLayout;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import tr.global.Constants;
import tr.model.Data;
import tr.model.DataLookup;
import tr.model.action.Action;
import tr.model.action.ActionState;
import tr.model.action.ActionStateASAP;
import tr.model.action.ActionStateDelegated;
import tr.model.action.ActionStateInactive;
import tr.model.action.ActionStateScheduled;
import tr.model.action.Recurrence;
import tr.model.action.RecurrenceRemover;
import tr.model.context.Context;
import tr.model.criteria.Criterion;
import tr.model.criteria.Value;
import tr.model.project.Project;
import tr.model.thought.Thought;
import tr.model.topic.Topic;
import tr.runtime.Email;
import tr.runtime.Open;
import tr.swing.editorpane.HyperEditorPane;
import tr.swing.time.HourSpinner;
import tr.swing.time.MinuteSpinner;
import tr.util.DateButton;
import tr.util.Observable;
import tr.util.Observer;
import tr.util.Utils;
import tr.view.action.RecurrenceDialog;
import tr.view.action.StatusComboBoxModel;
import tr.view.action.StatusEnum;
import tr.view.action.prefs.ActionPrefs;
import tr.view.context.ContextsComboBox;
import tr.view.context.ContextsComboBoxModel;
import tr.view.criteria.CriterionComboBoxModel;

public class PanelAction
extends JPanel
implements Observer {
    private static final Logger LOG = Logger.getLogger("tr.view.action");
    private DocumentListener docListenerDescription;
    private DocumentListener docListenerDelegatedTo;
    private DocumentListener docListenerNotes;
    private FocusAdapter focusAdapterDescription;
    private ActionListener actionListenerTopic;
    private ActionListener actionListenerContext;
    private ActionListener actionListenerRecurrence;
    private ActionListener actionListenerEmail;
    private ActionListener actionListenerDoneCheckBox;
    private ActionListener actionListenerStatusCombo;
    private ActionListener actionListenerPriorityCombo;
    private ActionListener actionListenerEnergyCombo;
    private ActionListener actionListenerTimeCombo;
    private ChangeListener changeListenerScheduledHour;
    private ChangeListener changeListenerScheduledMinute;
    private ChangeListener changeListenerDurationHour;
    private ChangeListener changeListenerDurationMinute;
    private PropertyChangeListener propChangeListenerScheduledDate;
    private PropertyChangeListener propChangeListenerFollowupDate;
    private PropertyChangeListener propChangeListenerCreatedDate;
    private PropertyChangeListener propChangeListenerStartDate;
    private PropertyChangeListener propChangeListenerDueDate;
    private PropertyChangeListener propChangeListenerDoneDate;
    private HyperlinkListener hyperlinkListener;
    private Observer observerCriterion;
    private JLabel contextLabel;
    private JComboBox contextsCombo;
    private DateButton createdDateButton;
    private JLabel createdDateLabel;
    private JPanel criterionPanel;
    private JPanel delegatedPanel;
    private JLabel delegatedToLabel;
    private JTextField delegatedToText;
    private JLabel descriptionLabel;
    private JTextField descriptionText;
    private JCheckBox doneCheckBox;
    private DateButton doneDateButton;
    private DateButton dueDateButton;
    private JLabel dueDateLabel;
    private HourSpinner durationHourSpinner;
    private JLabel durationLabel;
    private MinuteSpinner durationMinuteSpinner;
    private JButton emailButton;
    private JComboBox energyCombo;
    private JLabel energyLabel;
    private DateButton followupDateButton;
    private JLabel followupLabel;
    private HyperEditorPane notesEditorPane;
    private JLabel notesLabel;
    private JComboBox priorityCombo;
    private JLabel priorityLabel;
    private JButton recurrenceButton;
    private JLabel recurrenceLabel;
    private DateButton scheduledDateButton;
    private HourSpinner scheduledHourSpinner;
    private JLabel scheduledLabel;
    private MinuteSpinner scheduledMinuteSpinner;
    private JPanel scheduledPanel;
    private DateButton startDateButton;
    private JLabel startDateLabel;
    private JComboBox statusCombo;
    private JLabel statusLabel;
    private JComboBox timeCombo;
    private JLabel timeLabel;
    public static final String DEFAULT_DESCRIPTION = PanelAction.getText("new.action");
    private Data data = (Data)DataLookup.instance().lookup(Data.class);
    private Action action;
    private ActionStateInactive stateInactive;
    private ActionStateASAP stateASAP;
    private ActionStateDelegated stateDelegated;
    private ActionStateScheduled stateScheduled;
    private ComboBoxModel topicsModel;
    private ComboBoxModel contextsModel;
    private boolean updating;

    public PanelAction() {
        this.initComponents();
        this.initModel(null);
    }

    public void addNotify() {
        super.addNotify();
        this.addListeners();
    }

    public void removeNotify() {
        this.removeListeners();
        super.removeNotify();
    }

    public void edit() {
        this.descriptionText.requestFocusInWindow();
    }

    public void initModel(Action action) {
        this.data = (Data)DataLookup.instance().lookup(Data.class);
        if (this.action != null) {
            this.action.removeObserver((Observer)this);
        }
        this.action = action;
        this.stateInactive = null;
        this.stateASAP = null;
        this.stateScheduled = null;
        this.stateDelegated = null;
        this.storeActionState();
        if (this.action != null) {
            this.action.addObserver((Observer)this);
        }
        this.initView();
    }

    private void initView() {
        this.updating = true;
        if (this.action == null) {
            this.descriptionText.setText("");
            this.createdDateButton.setDate(null);
            this.startDateButton.setDate(null);
            this.dueDateButton.setDate(null);
            this.doneCheckBox.setSelected(false);
            this.doneDateButton.setDate(null);
            this.contextsCombo.setSelectedItem(null);
            this.statusCombo.setSelectedItem(null);
            this.followupDateButton.setDate(null);
            this.scheduledDateButton.setDate(null);
            this.scheduledHourSpinner.setVal(0);
            this.scheduledMinuteSpinner.setVal(0);
            this.durationHourSpinner.setVal(0);
            this.durationMinuteSpinner.setVal(0);
            this.timeCombo.setSelectedItem(null);
            this.energyCombo.setSelectedItem(null);
            this.priorityCombo.setSelectedItem(null);
            this.notesEditorPane.setText("");
            this.setEnabled(false);
        } else {
            ActionStateASAP state;
            this.descriptionText.setText(this.action.getDescription());
            Thought thought = this.action.getThought();
            this.contextsCombo.setSelectedItem(this.action.getContext());
            this.statusCombo.setSelectedItem(null);
            if (this.action.isStateInactive()) {
                this.statusCombo.setSelectedItem(StatusEnum.INACTIVE);
            } else if (this.action.isStateASAP()) {
                this.statusCombo.setSelectedItem(StatusEnum.DO_ASAP);
                state = (ActionStateASAP)this.action.getState();
            }
            if (this.action.isStateDelegated()) {
                this.statusCombo.setSelectedItem(StatusEnum.DELEGATED);
                state = (ActionStateDelegated)this.action.getState();
                this.delegatedToText.setText(state.getTo());
                this.followupDateButton.setDate(state.getDate());
            } else {
                this.delegatedToText.setText("");
                this.followupDateButton.setDate(null);
            }
            if (this.action.isStateScheduled()) {
                this.statusCombo.setSelectedItem(StatusEnum.SCHEDULED);
                state = (ActionStateScheduled)this.action.getState();
                this.scheduledDateButton.setDate(state.getDate());
                if (state.getDate() == null) {
                    this.scheduledHourSpinner.setValue((Object)new Integer(0));
                    this.scheduledMinuteSpinner.setValue((Object)new Integer(0));
                    this.durationHourSpinner.setValue((Object)new Integer(0));
                    this.durationMinuteSpinner.setValue((Object)new Integer(0));
                } else {
                    Calendar c = Calendar.getInstance();
                    c.setTime(state.getDate());
                    this.scheduledHourSpinner.setVal(c.get(11));
                    this.scheduledMinuteSpinner.setVal(c.get(12));
                    this.durationHourSpinner.setVal(state.getDurationHours());
                    this.durationMinuteSpinner.setVal(state.getDurationMinutes());
                }
            } else {
                this.scheduledDateButton.setDate(null);
                this.scheduledHourSpinner.setValue((Object)new Integer(0));
                this.scheduledMinuteSpinner.setValue((Object)new Integer(0));
                this.durationHourSpinner.setValue((Object)new Integer(0));
                this.durationMinuteSpinner.setValue((Object)new Integer(0));
            }
            this.timeCombo.setSelectedItem(this.action.getTime());
            this.energyCombo.setSelectedItem(this.action.getEnergy());
            this.priorityCombo.setSelectedItem(this.action.getPriority());
            this.notesEditorPane.setText(this.action.getNotes());
            this.createdDateButton.setDate(this.action.getCreated());
            this.startDateButton.setDate(this.action.getStartDate());
            this.dueDateButton.setDate(this.action.getDueDate());
            this.doneCheckBox.setSelected(this.action.isDone());
            this.doneDateButton.setDate(this.action.getDoneDate());
            this.setEnabled(true);
        }
        this.updating = false;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.descriptionLabel.setEnabled(enabled);
        this.descriptionText.setEnabled(enabled);
        this.contextsCombo.setEnabled(enabled);
        this.contextLabel.setEnabled(enabled);
        this.statusLabel.setEnabled(enabled);
        this.statusCombo.setEnabled(enabled);
        this.delegatedPanel.setVisible(enabled && this.action.isStateDelegated());
        this.delegatedPanel.setEnabled(enabled);
        this.delegatedToLabel.setEnabled(enabled);
        this.delegatedToText.setEnabled(enabled);
        this.emailButton.setEnabled(enabled);
        this.followupDateButton.setEnabled(enabled);
        this.followupLabel.setEnabled(enabled);
        this.scheduledLabel.setEnabled(enabled);
        this.scheduledDateButton.setEnabled(enabled);
        this.scheduledHourSpinner.setEnabled(enabled && this.scheduledDateButton.getDate() != null);
        this.scheduledMinuteSpinner.setEnabled(enabled && this.scheduledDateButton.getDate() != null);
        this.durationLabel.setEnabled(enabled && this.scheduledDateButton.getDate() != null);
        this.durationHourSpinner.setEnabled(enabled && this.scheduledDateButton.getDate() != null);
        this.durationMinuteSpinner.setEnabled(enabled && this.scheduledDateButton.getDate() != null);
        this.scheduledPanel.setEnabled(enabled);
        this.scheduledPanel.setVisible(enabled && this.action.isStateScheduled());
        if (this.scheduledPanel.isVisible()) {
            this.recurrenceLabel.setEnabled(false);
            this.recurrenceButton.setEnabled(false);
            ActionStateScheduled state = (ActionStateScheduled)this.action.getState();
            if (state.getRecurrence() == null) {
                this.recurrenceButton.setText(PanelAction.getText("recurrence.create"));
            } else {
                this.recurrenceButton.setText(PanelAction.getText("recurrence.modify"));
            }
            this.startDateLabel.setVisible(false);
            this.startDateButton.setVisible(false);
            this.dueDateLabel.setVisible(false);
            this.dueDateButton.setVisible(false);
        } else {
            this.startDateLabel.setVisible(ActionPrefs.isShowStartDate());
            this.startDateButton.setVisible(ActionPrefs.isShowStartDate());
            this.dueDateLabel.setVisible(ActionPrefs.isShowDueDate());
            this.dueDateButton.setVisible(ActionPrefs.isShowDueDate());
        }
        this.timeLabel.setEnabled(enabled);
        this.timeCombo.setEnabled(enabled);
        this.energyLabel.setEnabled(enabled);
        this.energyCombo.setEnabled(enabled);
        this.priorityLabel.setEnabled(enabled);
        this.priorityCombo.setEnabled(enabled);
        this.notesLabel.setEnabled(enabled);
        this.notesEditorPane.setEnabled(enabled);
        this.notesEditorPane.setEditable(false);
        this.createdDateLabel.setEnabled(enabled);
        this.createdDateButton.setEnabled(enabled && ActionPrefs.isEditCreateDate());
        this.startDateLabel.setEnabled(enabled);
        this.startDateButton.setEnabled(enabled);
        this.dueDateLabel.setEnabled(enabled);
        this.dueDateButton.setEnabled(enabled);
        this.doneCheckBox.setEnabled(enabled);
        this.doneDateButton.setEnabled(enabled && this.action.canSetDone(true));
        this.showHideCriteria();
    }

    private void showHideCriteria() {
        this.criterionPanel.setVisible(this.data.getTimeCriterion().use || this.data.getEnergyCriterion().use || this.data.getPriorityCriterion().use);
        if (this.criterionPanel.isVisible()) {
            this.timeLabel.setVisible(this.data.getTimeCriterion().use);
            this.timeCombo.setVisible(this.data.getTimeCriterion().use);
            this.energyLabel.setVisible(this.data.getEnergyCriterion().use);
            this.energyCombo.setVisible(this.data.getEnergyCriterion().use);
            this.priorityLabel.setVisible(this.data.getPriorityCriterion().use);
            this.priorityCombo.setVisible(this.data.getPriorityCriterion().use);
        }
    }

    public void focus() {
        this.descriptionText.requestFocusInWindow();
    }

    public void refresh() {
        this.setEnabled(this.action != null);
    }

    private void initComponents() {
        this.descriptionLabel = new JLabel();
        this.descriptionText = new JTextField();
        this.contextLabel = new JLabel();
        this.contextsModel = new ContextsComboBoxModel(false);
        this.contextsCombo = new ContextsComboBox(this.contextsModel);
        this.statusLabel = new JLabel();
        this.scheduledPanel = new JPanel();
        this.scheduledLabel = new JLabel();
        this.scheduledDateButton = new DateButton();
        this.scheduledHourSpinner = new HourSpinner();
        this.scheduledMinuteSpinner = new MinuteSpinner();
        this.durationLabel = new JLabel();
        this.durationHourSpinner = new HourSpinner();
        this.durationMinuteSpinner = new MinuteSpinner();
        this.recurrenceLabel = new JLabel();
        this.recurrenceButton = new JButton();
        this.delegatedPanel = new JPanel();
        this.delegatedToLabel = new JLabel();
        this.delegatedToText = new JTextField();
        this.emailButton = new JButton();
        this.followupLabel = new JLabel();
        this.followupDateButton = new DateButton();
        this.notesLabel = new JLabel();
        this.createdDateLabel = new JLabel();
        this.createdDateButton = new DateButton();
        this.doneCheckBox = new JCheckBox();
        this.doneDateButton = new DateButton();
        this.statusCombo = new JComboBox();
        this.criterionPanel = new JPanel();
        this.priorityLabel = new JLabel();
        this.priorityCombo = new JComboBox();
        this.energyLabel = new JLabel();
        this.energyCombo = new JComboBox();
        this.timeLabel = new JLabel();
        this.timeCombo = new JComboBox();
        this.startDateLabel = new JLabel();
        this.startDateButton = new DateButton();
        this.dueDateLabel = new JLabel();
        this.dueDateButton = new DateButton();
        this.notesEditorPane = new HyperEditorPane();
        this.descriptionLabel.setHorizontalAlignment(11);
        this.descriptionLabel.setText(NbBundle.getMessage(PanelAction.class, (String)"PanelAction.description"));
        this.contextLabel.setHorizontalAlignment(11);
        this.contextLabel.setText(NbBundle.getMessage(PanelAction.class, (String)"PanelAction.context"));
        this.contextsCombo.setMaximumRowCount(30);
        this.statusLabel.setHorizontalAlignment(11);
        this.statusLabel.setText(NbBundle.getMessage(PanelAction.class, (String)"PanelAction.status"));
        this.scheduledLabel.setHorizontalAlignment(11);
        this.scheduledLabel.setText(NbBundle.getMessage(PanelAction.class, (String)"PaanelAction.scheduledFor"));
        this.scheduledDateButton.setNoSelectionText("Select a date");
        this.durationLabel.setText(NbBundle.getMessage(PanelAction.class, (String)"PanelAction.duration"));
        this.durationHourSpinner.setFont(new Font("Dialog", 0, 12));
        this.durationMinuteSpinner.setFont(new Font("Dialog", 0, 12));
        this.recurrenceLabel.setText(NbBundle.getMessage(PanelAction.class, (String)"PanelAction.recurrence"));
        this.recurrenceButton.setMaximumSize(new Dimension(90, 29));
        this.recurrenceButton.setMinimumSize(new Dimension(90, 29));
        GroupLayout scheduledPanelLayout = new GroupLayout((Container)this.scheduledPanel);
        this.scheduledPanel.setLayout((LayoutManager)scheduledPanelLayout);
        scheduledPanelLayout.setHorizontalGroup((GroupLayout.Group)scheduledPanelLayout.createParallelGroup(1).add((GroupLayout.Group)scheduledPanelLayout.createSequentialGroup().add((Component)this.scheduledLabel, -2, 94, -2).addPreferredGap(0).add((Component)this.scheduledDateButton, -2, 150, -2).add(0, 0, 0).add((Component)this.scheduledHourSpinner, -2, 38, -2).add(0, 0, 0).add((Component)this.scheduledMinuteSpinner, -2, 38, -2).addPreferredGap(0).add((Component)this.durationLabel).addPreferredGap(0).add((Component)this.durationHourSpinner, -2, 38, -2).add(1, 1, 1).add((Component)this.durationMinuteSpinner, -2, 38, -2).addPreferredGap(0).add((Component)this.recurrenceLabel).addPreferredGap(0).add((Component)this.recurrenceButton, -2, 90, -2).addContainerGap(151, Short.MAX_VALUE)));
        scheduledPanelLayout.setVerticalGroup((GroupLayout.Group)scheduledPanelLayout.createParallelGroup(1).add((GroupLayout.Group)scheduledPanelLayout.createParallelGroup(3).add((Component)this.scheduledDateButton, -2, -1, -2).add((Component)this.scheduledLabel).add((Component)this.scheduledHourSpinner, -2, 22, -2).add((Component)this.scheduledMinuteSpinner, -2, 22, -2).add((Component)this.durationLabel).add((Component)this.durationHourSpinner, -2, 22, -2).add((Component)this.durationMinuteSpinner, -2, 22, -2).add((Component)this.recurrenceLabel).add((Component)this.recurrenceButton, -2, -1, -2)));
        this.delegatedToLabel.setHorizontalAlignment(11);
        this.delegatedToLabel.setText(NbBundle.getMessage(PanelAction.class, (String)"PanelAction.delegatedTo"));
        this.emailButton.setText(NbBundle.getMessage(PanelAction.class, (String)"PanelAction.email"));
        this.followupLabel.setText(NbBundle.getMessage(PanelAction.class, (String)"PanelAction.followUp"));
        this.followupDateButton.setNoSelectionText("Never");
        GroupLayout delegatedPanelLayout = new GroupLayout((Container)this.delegatedPanel);
        this.delegatedPanel.setLayout((LayoutManager)delegatedPanelLayout);
        delegatedPanelLayout.setHorizontalGroup((GroupLayout.Group)delegatedPanelLayout.createParallelGroup(1).add((GroupLayout.Group)delegatedPanelLayout.createSequentialGroup().add((Component)this.delegatedToLabel, -2, 94, -2).addPreferredGap(0).add((Component)this.delegatedToText, -2, 209, -2).addPreferredGap(0).add((Component)this.emailButton).addPreferredGap(0).add((Component)this.followupLabel, -2, 73, -2).add(1, 1, 1).add((Component)this.followupDateButton, -2, 150, -2).addContainerGap(195, Short.MAX_VALUE)));
        delegatedPanelLayout.setVerticalGroup((GroupLayout.Group)delegatedPanelLayout.createParallelGroup(1).add((GroupLayout.Group)delegatedPanelLayout.createParallelGroup(3).add((Component)this.delegatedToLabel).add((Component)this.emailButton).add((Component)this.followupLabel).add((Component)this.followupDateButton, -2, -1, -2).add((Component)this.delegatedToText, -2, 22, -2)));
        this.notesLabel.setHorizontalAlignment(11);
        this.notesLabel.setText(NbBundle.getMessage(PanelAction.class, (String)"PanelAction.notes"));
        this.createdDateLabel.setHorizontalAlignment(11);
        this.createdDateLabel.setText(NbBundle.getMessage(PanelAction.class, (String)"PanelAction.created"));
        this.createdDateButton.setNoSelectionText("Select a date");
        this.doneCheckBox.setText(NbBundle.getMessage(PanelAction.class, (String)"PanelAction.done"));
        this.doneCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.doneCheckBox.setHorizontalTextPosition(10);
        this.doneCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.doneDateButton.setNoSelectionText("Select a date");
        this.statusCombo.setModel(new StatusComboBoxModel());
        this.priorityLabel.setHorizontalAlignment(11);
        this.priorityLabel.setText(NbBundle.getMessage(PanelAction.class, (String)"PanelAction.priority"));
        this.priorityLabel.setFocusable(false);
        this.priorityLabel.setPreferredSize(new Dimension(96, 16));
        this.priorityCombo.setModel(this.getPriorityComboBoxModel());
        this.energyLabel.setHorizontalAlignment(11);
        this.energyLabel.setText(NbBundle.getMessage(PanelAction.class, (String)"PanelAction.energy"));
        this.energyLabel.setFocusable(false);
        this.energyLabel.setPreferredSize(new Dimension(96, 16));
        this.energyCombo.setModel(this.getEnergyComboBoxModel());
        this.timeLabel.setHorizontalAlignment(11);
        this.timeLabel.setText(NbBundle.getMessage(PanelAction.class, (String)"PanelAction.time"));
        this.timeLabel.setFocusable(false);
        this.timeLabel.setPreferredSize(new Dimension(96, 16));
        this.timeCombo.setModel(this.getTimeComboBoxModel());
        GroupLayout criterionPanelLayout = new GroupLayout((Container)this.criterionPanel);
        this.criterionPanel.setLayout((LayoutManager)criterionPanelLayout);
        criterionPanelLayout.setHorizontalGroup((GroupLayout.Group)criterionPanelLayout.createParallelGroup(1).add((GroupLayout.Group)criterionPanelLayout.createSequentialGroup().add((Component)this.timeLabel, -2, 94, -2).addPreferredGap(0).add((Component)this.timeCombo, -2, 150, -2).add(0, 0, 0).add((Component)this.energyLabel, -2, 94, -2).addPreferredGap(0).add((Component)this.energyCombo, -2, 150, -2).add(0, 0, 0).add((Component)this.priorityLabel, -2, 94, -2).addPreferredGap(0).add((Component)this.priorityCombo, -2, 150, -2).addContainerGap(-1, Short.MAX_VALUE)));
        criterionPanelLayout.linkSize(new Component[]{this.energyLabel, this.priorityLabel, this.timeLabel}, 1);
        criterionPanelLayout.linkSize(new Component[]{this.energyCombo, this.priorityCombo, this.timeCombo}, 1);
        criterionPanelLayout.setVerticalGroup((GroupLayout.Group)criterionPanelLayout.createParallelGroup(1).add((GroupLayout.Group)criterionPanelLayout.createParallelGroup(3).add((Component)this.timeCombo, -2, -1, -2).add((Component)this.energyCombo, -2, -1, -2).add((Component)this.priorityCombo, -2, -1, -2).add((Component)this.timeLabel, -2, 32, -2).add((Component)this.energyLabel, -2, 24, -2).add((Component)this.priorityLabel, -2, 24, -2)));
        this.startDateLabel.setText(NbBundle.getMessage(PanelAction.class, (String)"PanelAction.startDateLabel.text"));
        this.startDateButton.setNoSelectionText("Select a date");
        this.dueDateLabel.setText(NbBundle.getMessage(PanelAction.class, (String)"PanelAction.dueDateLabel.text"));
        this.dueDateButton.setNoSelectionText("Select a date");
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2, false).add((Component)this.notesLabel, -1, 94, Short.MAX_VALUE).add((Component)this.createdDateLabel, -1, 94, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.createdDateButton, -2, 144, -2).addPreferredGap(0).add((Component)this.startDateLabel).addPreferredGap(0).add((Component)this.startDateButton, -2, 144, -2).addPreferredGap(0).add((Component)this.dueDateLabel).addPreferredGap(0).add((Component)this.dueDateButton, -2, 144, -2).addPreferredGap(0).add((Component)this.doneCheckBox).addPreferredGap(0).add((Component)this.doneDateButton, -2, 144, -2).add(8, 8, 8)).add((Component)this.notesEditorPane, -1, 748, Short.MAX_VALUE))).add((GroupLayout.Group)layout.createParallelGroup(2, false).add(1, (Component)this.scheduledPanel, -1, -1, Short.MAX_VALUE).add(1, (Component)this.delegatedPanel, -1, -1, Short.MAX_VALUE).add(1, (Component)this.criterionPanel, -2, -1, -2)).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.contextLabel, -1, 94, Short.MAX_VALUE).add((Component)this.statusLabel, -1, 94, Short.MAX_VALUE)).addPreferredGap(0)).add((Component)this.descriptionLabel, -1, 94, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.contextsCombo, -2, 250, -2).add((Component)this.statusCombo, -2, 150, -2).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.descriptionText, -1, 748, Short.MAX_VALUE).addPreferredGap(0))).addPreferredGap(0))).addContainerGap()));
        layout.linkSize(new Component[]{this.contextLabel, this.descriptionLabel, this.statusLabel}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.descriptionLabel).add((Component)this.descriptionText, -2, 22, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.contextLabel).add((Component)this.contextsCombo, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.statusLabel).add((Component)this.statusCombo, -2, -1, -2)).addPreferredGap(0).add((Component)this.scheduledPanel, -2, 30, -2).addPreferredGap(0).add((Component)this.delegatedPanel, -2, 30, -2).addPreferredGap(0).add((Component)this.criterionPanel, -2, -1, -2).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(36, 36, 36).add((Component)this.notesLabel)).add((GroupLayout.Group)layout.createSequentialGroup().addPreferredGap(0).add((Component)this.notesEditorPane, -1, 48, Short.MAX_VALUE))).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.createdDateButton, -2, -1, -2).add((Component)this.doneDateButton, -2, -1, -2).add((Component)this.startDateLabel).add((Component)this.doneCheckBox).add((Component)this.startDateButton, -2, -1, -2).add((Component)this.dueDateLabel).add((Component)this.dueDateButton, -2, -1, -2).add((Component)this.createdDateLabel)).addContainerGap()));
        layout.linkSize(new Component[]{this.delegatedPanel, this.scheduledPanel}, 2);
        layout.linkSize(new Component[]{this.contextLabel, this.contextsCombo, this.statusCombo, this.statusLabel}, 2);
        layout.linkSize(new Component[]{this.descriptionLabel, this.descriptionText}, 2);
    }

    private void addToNotes(String text) {
        String notes = this.notesEditorPane.getText().trim();
        if (notes.contains(text)) {
            return;
        }
        if (notes.length() == 0) {
            this.notesEditorPane.setText(text);
        } else {
            this.notesEditorPane.setText(notes + "\n" + text);
        }
    }

    private void storeActionState() {
        if (this.action == null) {
            return;
        }
        if (this.action.isStateInactive()) {
            this.stateInactive = (ActionStateInactive)this.action.getState();
        } else if (this.action.isStateASAP()) {
            this.stateASAP = (ActionStateASAP)this.action.getState();
        } else if (this.action.isStateScheduled()) {
            this.stateScheduled = (ActionStateScheduled)this.action.getState();
        } else if (this.action.isStateDelegated()) {
            this.stateDelegated = (ActionStateDelegated)this.action.getState();
        }
    }

    private void hyperlink(HyperlinkEvent evt) {
        URL url = evt.getURL();
        if (url == null) {
            return;
        }
        if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            Open.open((URL)url);
        }
    }

    private void recurrenceActionPerformed(ActionEvent evt) {
        if (this.updating || this.action == null) {
            return;
        }
        if (!this.action.isStateScheduled()) {
            return;
        }
        this.stateScheduled = (ActionStateScheduled)this.action.getState();
        Recurrence recurrence = this.stateScheduled.getRecurrence();
        if (recurrence == null) {
            recurrence = new Recurrence(this.data.getNextID(), (Project)this.action.getParent());
            recurrence.setDescription(this.action.getDescription());
            recurrence.setTopic(this.action.getTopic());
            recurrence.setContext(this.action.getContext());
            recurrence.setTime(this.action.getTime());
            recurrence.setEnergy(this.action.getEnergy());
            recurrence.setPriority(this.action.getPriority());
            Date schdDate = this.stateScheduled.getDate();
            if (schdDate != null) {
                recurrence.setStartDate(schdDate);
                Calendar cal = Calendar.getInstance();
                cal.setTime(schdDate);
                recurrence.setScheduleHours(cal.get(11));
                recurrence.setScheduleMins(cal.get(12));
            }
            recurrence.setDurationHours(this.stateScheduled.getDurationHours());
            recurrence.setDurationMins(this.stateScheduled.getDurationMinutes());
            recurrence.setFrequency(1);
        }
        String pDescription = recurrence.getDescription();
        Topic pTopic = recurrence.getTopic();
        Context pContext = recurrence.getContext();
        Value pTime = recurrence.getTime();
        Value pEnergy = recurrence.getEnergy();
        Value pPriority = recurrence.getPriority();
        int pScheduleHours = recurrence.getScheduleHours();
        int pScheduleMins = recurrence.getScheduleMins();
        int pDurationHours = recurrence.getDurationHours();
        int pDurationMins = recurrence.getDurationMins();
        Recurrence.Basis pBasis = recurrence.getBasis();
        Date pStartDate = recurrence.getStartDate();
        Recurrence.Period pPeriod = recurrence.getPeriod();
        int pFrequency = recurrence.getFrequency();
        int pAdvance = recurrence.getAdvanceNbr();
        Integer pEndNbr = recurrence.getEndNbr();
        Date pEndDate = recurrence.getEndDate();
        RecurrenceDialog dialog = new RecurrenceDialog((Component)this.recurrenceButton, this.stateScheduled.getDate(), pDescription, pTopic, pContext, pTime, pEnergy, pPriority, pScheduleHours, pScheduleMins, pDurationHours, pDurationMins, pBasis, pStartDate, pPeriod, pFrequency, pAdvance, pEndNbr, pEndDate);
        dialog.setVisible(true);
        if (dialog.cancel) {
            return;
        }
        if (dialog.delete) {
            this.stateScheduled.setRecurrence(null);
            this.recurrenceButton.setText(PanelAction.getText("recurrence.create"));
            RecurrenceRemover.remove((Data)this.data, (int)recurrence.getID());
            return;
        }
        if (this.stateScheduled.getRecurrence() == null) {
            this.stateScheduled.setRecurrence(recurrence);
        }
        recurrence.setDescription(dialog.getDescription());
        recurrence.setTopic(dialog.getTopic());
        recurrence.setContext(dialog.getContext());
        recurrence.setTime(dialog.getTime());
        recurrence.setEnergy(dialog.getEnergy());
        recurrence.setPriority(dialog.getPriority());
        recurrence.setScheduleHours(dialog.getScheduleHours());
        recurrence.setScheduleMins(dialog.getScheduleMins());
        recurrence.setDurationHours(dialog.getDurationHours());
        recurrence.setDurationMins(dialog.getDurationMins());
        recurrence.setBasis(dialog.getBasis());
        recurrence.setStartDate(dialog.getStartDate());
        recurrence.setPeriod(dialog.getPeriod());
        recurrence.setFrequency(dialog.getFrequencyNbr());
        recurrence.setAdvanceNbr(dialog.getAdvance());
        recurrence.setEndNbr(dialog.getEndNbr());
        recurrence.setEndDate(dialog.getEndDate());
        if (this.stateScheduled.getRecurrence() == null) {
            this.stateScheduled.setRecurrence(recurrence);
        }
        if (recurrence.getGeneratedToDate() == null) {
            if (recurrence.getBasis() == Recurrence.Basis.START_DATE) {
                recurrence.generateOccurrencesFromStartDate();
            }
        } else if (!Utils.equal((Object)recurrence.getBasis(), (Object)pBasis)) {
            if (recurrence.getBasis() == Recurrence.Basis.START_DATE) {
                recurrence.generateOccurrencesFromStartDate();
            } else {
                recurrence.removeOccurrencesAfterStartDate();
            }
        } else if (recurrence.getBasis() == Recurrence.Basis.START_DATE) {
            Date schdDate;
            if (!(Utils.equal((Object)recurrence.getDescription(), (Object)pDescription) && Utils.equal((Object)recurrence.getTopic(), (Object)pTopic) && Utils.equal((Object)recurrence.getContext(), (Object)pContext) && Utils.equal((Object)recurrence.getTime(), (Object)pTime) && Utils.equal((Object)recurrence.getEnergy(), (Object)pEnergy) && Utils.equal((Object)recurrence.getPriority(), (Object)pPriority) && Utils.equal((Object)recurrence.getScheduleHours(), (Object)pScheduleHours) && Utils.equal((Object)recurrence.getScheduleMins(), (Object)pScheduleMins) && Utils.equal((Object)recurrence.getDurationHours(), (Object)pDurationHours) && Utils.equal((Object)recurrence.getDurationMins(), (Object)pDurationMins) || (schdDate = this.stateScheduled.getDate()) == null)) {
                recurrence.updateRecurrenceActions(schdDate);
            }
            if (!(Utils.equal((Object)recurrence.getStartDate(), (Object)pStartDate) && Utils.equal((Object)recurrence.getPeriod(), (Object)pPeriod) && Utils.equal((Object)recurrence.getFrequency(), (Object)pFrequency))) {
                recurrence.removeOccurrencesAfterStartDate();
                recurrence.generateOccurrencesFromStartDate();
            } else if (!(Utils.equal((Object)recurrence.getAdvanceNbr(), (Object)pAdvance) && Utils.equal((Object)recurrence.getEndNbr(), (Object)pEndNbr) && Utils.equal((Object)recurrence.getEndDate(), (Object)pEndDate))) {
                recurrence.updateTermination();
            }
        }
        this.recurrenceButton.setText(PanelAction.getText("recurrence.modify"));
    }

    private void durationMinutesStateChanged(ChangeEvent evt) {
        if (this.updating || this.action == null) {
            return;
        }
        if (!this.action.isStateScheduled()) {
            return;
        }
        this.stateScheduled = (ActionStateScheduled)this.action.getState();
        if (this.stateScheduled.getDate() == null) {
            this.durationMinuteSpinner.setVal(0);
        } else {
            this.stateScheduled.setDurationMins(this.durationMinuteSpinner.getVal());
        }
    }

    private void durationHoursStateChanged(ChangeEvent evt) {
        if (this.updating || this.action == null) {
            return;
        }
        if (!this.action.isStateScheduled()) {
            return;
        }
        this.stateScheduled = (ActionStateScheduled)this.action.getState();
        if (this.stateScheduled.getDate() == null) {
            this.durationHourSpinner.setVal(0);
        } else {
            this.stateScheduled.setDurationHours(this.durationHourSpinner.getVal());
        }
    }

    private void scheduledDateButtonPropertyChange(PropertyChangeEvent evt) {
        if (this.updating || this.action == null) {
            return;
        }
        if (!this.action.isStateScheduled()) {
            return;
        }
        this.stateScheduled = (ActionStateScheduled)this.action.getState();
        this.stateScheduled.setDate(this.scheduledDateButton.getDate());
        if (this.stateScheduled.getDate() == null) {
            this.scheduledHourSpinner.setVal(0);
            this.scheduledMinuteSpinner.setVal(0);
            this.scheduledHourSpinner.setEnabled(false);
            this.scheduledMinuteSpinner.setEnabled(false);
            this.durationHourSpinner.setVal(0);
            this.durationMinuteSpinner.setVal(0);
            this.durationHourSpinner.setEnabled(false);
            this.durationMinuteSpinner.setEnabled(false);
            this.durationLabel.setEnabled(false);
            this.recurrenceLabel.setEnabled(false);
            this.recurrenceButton.setEnabled(false);
        } else {
            this.scheduledHourSpinner.setEnabled(true);
            this.scheduledMinuteSpinner.setEnabled(true);
            this.durationHourSpinner.setEnabled(true);
            this.durationMinuteSpinner.setEnabled(true);
            this.durationLabel.setEnabled(true);
        }
    }

    private void followupDateButtonPropertyChange(PropertyChangeEvent evt) {
        if (this.updating || this.action == null) {
            return;
        }
        if (this.action.isStateDelegated()) {
            this.stateDelegated = (ActionStateDelegated)this.action.getState();
            this.stateDelegated.setDate(this.followupDateButton.getDate());
        }
    }

    private void priorityComboActionPerformed(ActionEvent evt) {
        if (this.updating || this.action == null) {
            return;
        }
        this.action.setPriority((Value)this.priorityCombo.getSelectedItem());
    }

    private void timeComboActionPerformed(ActionEvent evt) {
        if (this.updating || this.action == null) {
            return;
        }
        this.action.setTime((Value)this.timeCombo.getSelectedItem());
    }

    private void energyComboActionPerformed(ActionEvent evt) {
        if (this.updating || this.action == null) {
            return;
        }
        this.action.setEnergy((Value)this.energyCombo.getSelectedItem());
    }

    private void statusComboActionPerformed(ActionEvent evt) {
        if (this.updating || this.action == null) {
            return;
        }
        StatusEnum status = (StatusEnum)this.statusCombo.getSelectedItem();
        switch (status) {
            case INACTIVE: {
                this.action.setState((ActionState)this.getStateInactive());
                break;
            }
            case DO_ASAP: {
                this.action.setState((ActionState)this.getStateASAP());
                break;
            }
            case SCHEDULED: {
                this.action.setState((ActionState)this.getStateScheduled());
                break;
            }
            case DELEGATED: {
                this.action.setState((ActionState)this.getStateDelegated());
            }
        }
        this.setEnabled(true);
    }

    private void scheduledMinuteStateChanged(ChangeEvent evt) {
        if (this.updating || this.action == null) {
            return;
        }
        if (!this.action.isStateScheduled()) {
            return;
        }
        this.stateScheduled = (ActionStateScheduled)this.action.getState();
        if (this.stateScheduled.getDate() == null) {
            this.scheduledMinuteSpinner.setVal(0);
        } else {
            Calendar c = Calendar.getInstance();
            c.setTime(this.stateScheduled.getDate());
            c.set(12, this.scheduledMinuteSpinner.getVal());
            c.set(13, 0);
            this.stateScheduled.setDate(c.getTime());
            this.scheduledDateButton.setDate(c.getTime());
        }
    }

    private void emailActionPerformed(ActionEvent evt) {
        String to = this.delegatedToText.getText();
        if (Utilities.getOperatingSystem() == 16 && to.indexOf("@") == -1) {
            JOptionPane.showMessageDialog(null, PanelAction.getText("ERR_EmailRequired"), "", 1);
            return;
        }
        String subject = this.descriptionText.getText();
        String body = this.notesEditorPane.getText();
        Email.email((String)to, (String)subject, (String)body);
        Date today = Calendar.getInstance().getTime();
        if (ActionPrefs.isNoteDelegateEmail()) {
            this.addToNotes(PanelAction.getText("MSG_EmailSent") + " " + Constants.DATE_FORMAT_FIXED.format(today));
        }
    }

    private void scheduledHourStateChanged(ChangeEvent evt) {
        if (this.updating || this.action == null) {
            return;
        }
        if (!this.action.isStateScheduled()) {
            return;
        }
        this.stateScheduled = (ActionStateScheduled)this.action.getState();
        if (this.stateScheduled.getDate() == null) {
            this.scheduledHourSpinner.setVal(0);
        } else {
            Calendar c = Calendar.getInstance();
            c.setTime(this.stateScheduled.getDate());
            c.set(11, this.scheduledHourSpinner.getVal());
            c.set(13, 0);
            this.stateScheduled.setDate(c.getTime());
            this.scheduledDateButton.setDate(c.getTime());
        }
    }

    private void doneDateButtonPropertyChange(PropertyChangeEvent evt) {
        if (this.updating || this.action == null) {
            return;
        }
        this.action.setDoneDate(this.doneDateButton.getDate());
    }

    private void doneCheckBoxActionPerformed(ActionEvent evt) {
        if (this.updating || this.action == null) {
            return;
        }
        if (this.action.canSetDone(this.doneCheckBox.isSelected())) {
            this.action.setDone(this.doneCheckBox.isSelected());
            this.doneDateButton.setDate(this.action.getDoneDate());
            this.doneDateButton.setEnabled(this.action.canSetDone(true));
        }
    }

    private void createdDateButtonPropertyChange(PropertyChangeEvent evt) {
        if (this.updating || this.action == null) {
            return;
        }
        this.action.setCreated(this.createdDateButton.getDate());
    }

    private void startDateButtonPropertyChange(PropertyChangeEvent evt) {
        if (this.updating || this.action == null) {
            return;
        }
        this.action.setStartDate(this.startDateButton.getDate());
    }

    private void dueDateButtonPropertyChange(PropertyChangeEvent evt) {
        if (this.updating || this.action == null) {
            return;
        }
        this.action.setDueDate(this.dueDateButton.getDate());
    }

    private void contextsComboActionPerformed(ActionEvent evt) {
        if (this.updating || this.action == null) {
            return;
        }
        JComboBox combo = (JComboBox)evt.getSource();
        this.action.setContext((Context)combo.getSelectedItem());
    }

    private void topicComboActionPerformed(ActionEvent evt) {
        if (this.updating || this.action == null) {
            return;
        }
        JComboBox combo = (JComboBox)evt.getSource();
        this.action.setTopic((Topic)combo.getSelectedItem());
    }

    private void descriptionTextFocusGained(FocusEvent evt) {
        if (this.descriptionText.getText().equals(DEFAULT_DESCRIPTION)) {
            this.descriptionText.setSelectionStart(0);
            this.descriptionText.setSelectionEnd(DEFAULT_DESCRIPTION.length());
        }
    }

    private ActionStateInactive getStateInactive() {
        if (this.stateInactive == null) {
            this.stateInactive = this.action.isStateInactive() ? (ActionStateInactive)this.action.getState() : new ActionStateInactive();
        }
        return this.stateInactive;
    }

    private ActionStateASAP getStateASAP() {
        if (this.stateASAP == null) {
            this.stateASAP = this.action.isStateASAP() ? (ActionStateASAP)this.action.getState() : new ActionStateASAP();
        }
        return this.stateASAP;
    }

    private ActionStateDelegated getStateDelegated() {
        if (this.stateDelegated == null) {
            this.stateDelegated = this.action.isStateDelegated() ? (ActionStateDelegated)this.action.getState() : new ActionStateDelegated();
        }
        return this.stateDelegated;
    }

    private ActionStateScheduled getStateScheduled() {
        if (this.stateScheduled == null) {
            this.stateScheduled = this.action.isStateScheduled() ? (ActionStateScheduled)this.action.getState() : new ActionStateScheduled();
        }
        return this.stateScheduled;
    }

    private void changedDescription() {
        LOG.fine("Start");
        if (this.updating || this.action == null) {
            return;
        }
        LOG.fine("Changing");
        this.action.setDescription(this.descriptionText.getText());
    }

    private void changedDelegatedTo() {
        if (this.updating || this.action == null) {
            return;
        }
        if (this.action.isStateDelegated()) {
            this.stateDelegated = (ActionStateDelegated)this.action.getState();
            this.stateDelegated.setTo(this.delegatedToText.getText());
        }
    }

    private void changedNotes() {
        if (this.updating || this.action == null) {
            return;
        }
        this.action.setNotes(this.notesEditorPane.getText());
    }

    private static String getText(String key) {
        return NbBundle.getMessage(PanelAction.class, (String)key);
    }

    private ComboBoxModel getTimeComboBoxModel() {
        Criterion criterion;
        if (this.data != null && (criterion = this.data.getTimeCriterion()) != null) {
            return new CriterionComboBoxModel(criterion);
        }
        return new DefaultComboBoxModel();
    }

    private ComboBoxModel getEnergyComboBoxModel() {
        Criterion criterion;
        if (this.data != null && (criterion = this.data.getEnergyCriterion()) != null) {
            return new CriterionComboBoxModel(criterion);
        }
        return new DefaultComboBoxModel();
    }

    private ComboBoxModel getPriorityComboBoxModel() {
        Criterion criterion;
        if (this.data != null && (criterion = this.data.getPriorityCriterion()) != null) {
            return new CriterionComboBoxModel(criterion);
        }
        return new DefaultComboBoxModel();
    }

    public void update(Observable observable, Object arg) {
        if (this.action == null) {
            return;
        }
        if (!this.descriptionText.getText().equals(this.action.getDescription())) {
            this.descriptionText.setText(this.action.getDescription());
        }
        if (!Utils.equal((Object)this.action.getContext(), (Object)this.contextsCombo.getSelectedItem())) {
            this.contextsCombo.setSelectedItem(this.action.getContext());
        }
        if (this.doneCheckBox.isSelected() != this.action.isDone()) {
            this.doneCheckBox.setSelected(this.action.isDone());
            this.doneDateButton.setDate(this.action.getDoneDate());
            this.doneDateButton.setEnabled(this.action.canSetDone(true));
        }
        if (this.action.isStateScheduled()) {
            ActionStateScheduled ass = (ActionStateScheduled)this.action.getState();
            this.scheduledDateButton.setDate(ass.getDate());
            if (ass.getDate() == null) {
                this.scheduledHourSpinner.setValue((Object)new Integer(0));
                this.scheduledMinuteSpinner.setValue((Object)new Integer(0));
                this.durationHourSpinner.setValue((Object)new Integer(0));
                this.durationMinuteSpinner.setValue((Object)new Integer(0));
            } else {
                Calendar c = Calendar.getInstance();
                c.setTime(ass.getDate());
                this.scheduledHourSpinner.setVal(c.get(11));
                this.scheduledMinuteSpinner.setVal(c.get(12));
                this.durationHourSpinner.setVal(ass.getDurationHours());
                this.durationMinuteSpinner.setVal(ass.getDurationMinutes());
            }
        }
    }

    private void addListeners() {
        this.docListenerDescription = new DocumentListener(){

            public void changedUpdate(DocumentEvent arg0) {
                PanelAction.this.changedDescription();
            }

            public void insertUpdate(DocumentEvent arg0) {
                PanelAction.this.changedDescription();
            }

            public void removeUpdate(DocumentEvent arg0) {
                PanelAction.this.changedDescription();
            }
        };
        this.descriptionText.getDocument().addDocumentListener(this.docListenerDescription);
        this.docListenerDelegatedTo = new DocumentListener(){

            public void changedUpdate(DocumentEvent arg0) {
                PanelAction.this.changedDelegatedTo();
            }

            public void insertUpdate(DocumentEvent arg0) {
                PanelAction.this.changedDelegatedTo();
            }

            public void removeUpdate(DocumentEvent arg0) {
                PanelAction.this.changedDelegatedTo();
            }
        };
        this.delegatedToText.getDocument().addDocumentListener(this.docListenerDelegatedTo);
        this.docListenerNotes = new DocumentListener(){

            public void changedUpdate(DocumentEvent arg0) {
                PanelAction.this.changedNotes();
            }

            public void insertUpdate(DocumentEvent arg0) {
                PanelAction.this.changedNotes();
            }

            public void removeUpdate(DocumentEvent arg0) {
                PanelAction.this.changedNotes();
            }
        };
        this.notesEditorPane.addDocumentListener(this.docListenerNotes);
        this.focusAdapterDescription = new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                PanelAction.this.descriptionTextFocusGained(evt);
            }
        };
        this.descriptionText.addFocusListener(this.focusAdapterDescription);
        this.actionListenerContext = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelAction.this.contextsComboActionPerformed(evt);
            }
        };
        this.contextsCombo.addActionListener(this.actionListenerContext);
        this.propChangeListenerScheduledDate = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                PanelAction.this.scheduledDateButtonPropertyChange(evt);
            }
        };
        this.scheduledDateButton.addPropertyChangeListener(this.propChangeListenerScheduledDate);
        this.changeListenerScheduledHour = new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                PanelAction.this.scheduledHourStateChanged(evt);
            }
        };
        this.scheduledHourSpinner.addChangeListener(this.changeListenerScheduledHour);
        this.changeListenerScheduledMinute = new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                PanelAction.this.scheduledMinuteStateChanged(evt);
            }
        };
        this.scheduledMinuteSpinner.addChangeListener(this.changeListenerScheduledMinute);
        this.changeListenerDurationHour = new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                PanelAction.this.durationHoursStateChanged(evt);
            }
        };
        this.durationHourSpinner.addChangeListener(this.changeListenerDurationHour);
        this.changeListenerDurationMinute = new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                PanelAction.this.durationMinutesStateChanged(evt);
            }
        };
        this.durationMinuteSpinner.addChangeListener(this.changeListenerDurationMinute);
        this.actionListenerRecurrence = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelAction.this.recurrenceActionPerformed(evt);
            }
        };
        this.recurrenceButton.addActionListener(this.actionListenerRecurrence);
        this.actionListenerEmail = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelAction.this.emailActionPerformed(evt);
            }
        };
        this.emailButton.addActionListener(this.actionListenerEmail);
        this.actionListenerDoneCheckBox = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelAction.this.doneCheckBoxActionPerformed(evt);
            }
        };
        this.doneCheckBox.addActionListener(this.actionListenerDoneCheckBox);
        this.actionListenerStatusCombo = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelAction.this.statusComboActionPerformed(evt);
            }
        };
        this.statusCombo.addActionListener(this.actionListenerStatusCombo);
        this.actionListenerPriorityCombo = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelAction.this.priorityComboActionPerformed(evt);
            }
        };
        this.priorityCombo.addActionListener(this.actionListenerPriorityCombo);
        this.actionListenerEnergyCombo = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelAction.this.energyComboActionPerformed(evt);
            }
        };
        this.energyCombo.addActionListener(this.actionListenerEnergyCombo);
        this.actionListenerTimeCombo = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelAction.this.timeComboActionPerformed(evt);
            }
        };
        this.timeCombo.addActionListener(this.actionListenerTimeCombo);
        this.propChangeListenerFollowupDate = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                PanelAction.this.followupDateButtonPropertyChange(evt);
            }
        };
        this.followupDateButton.addPropertyChangeListener(this.propChangeListenerFollowupDate);
        this.propChangeListenerDoneDate = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                PanelAction.this.doneDateButtonPropertyChange(evt);
            }
        };
        this.doneDateButton.addPropertyChangeListener(this.propChangeListenerDoneDate);
        this.propChangeListenerCreatedDate = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                PanelAction.this.createdDateButtonPropertyChange(evt);
            }
        };
        this.createdDateButton.addPropertyChangeListener(this.propChangeListenerCreatedDate);
        this.propChangeListenerStartDate = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                PanelAction.this.startDateButtonPropertyChange(evt);
            }
        };
        this.startDateButton.addPropertyChangeListener(this.propChangeListenerStartDate);
        this.propChangeListenerDueDate = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                PanelAction.this.dueDateButtonPropertyChange(evt);
            }
        };
        this.dueDateButton.addPropertyChangeListener(this.propChangeListenerDueDate);
        this.hyperlinkListener = new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent evt) {
                PanelAction.this.hyperlink(evt);
            }
        };
        this.notesEditorPane.addHyperlinkListener(this.hyperlinkListener);
        this.observerCriterion = new Observer(){

            public void update(Observable observable, Object arguement) {
                PanelAction.this.showHideCriteria();
            }
        };
        this.data.getTimeCriterion().addObserver(this.observerCriterion);
        this.data.getEnergyCriterion().addObserver(this.observerCriterion);
        this.data.getPriorityCriterion().addObserver(this.observerCriterion);
    }

    private void removeListeners() {
        this.descriptionText.getDocument().removeDocumentListener(this.docListenerDescription);
        this.delegatedToText.getDocument().removeDocumentListener(this.docListenerDelegatedTo);
        this.notesEditorPane.removeDocumentListener(this.docListenerNotes);
        this.descriptionText.removeFocusListener(this.focusAdapterDescription);
        this.contextsCombo.removeActionListener(this.actionListenerContext);
        this.scheduledDateButton.removePropertyChangeListener(this.propChangeListenerScheduledDate);
        this.scheduledHourSpinner.removeChangeListener(this.changeListenerScheduledHour);
        this.scheduledMinuteSpinner.removeChangeListener(this.changeListenerScheduledMinute);
        this.durationHourSpinner.removeChangeListener(this.changeListenerDurationHour);
        this.durationMinuteSpinner.removeChangeListener(this.changeListenerDurationMinute);
        this.recurrenceButton.removeActionListener(this.actionListenerRecurrence);
        this.emailButton.removeActionListener(this.actionListenerEmail);
        this.doneCheckBox.removeActionListener(this.actionListenerDoneCheckBox);
        this.statusCombo.removeActionListener(this.actionListenerStatusCombo);
        this.priorityCombo.removeActionListener(this.actionListenerPriorityCombo);
        this.energyCombo.removeActionListener(this.actionListenerEnergyCombo);
        this.timeCombo.removeActionListener(this.actionListenerTimeCombo);
        this.followupDateButton.removePropertyChangeListener(this.propChangeListenerFollowupDate);
        this.doneDateButton.removePropertyChangeListener(this.propChangeListenerDoneDate);
        this.startDateButton.removePropertyChangeListener(this.propChangeListenerStartDate);
        this.dueDateButton.removePropertyChangeListener(this.propChangeListenerDueDate);
        this.notesEditorPane.removeHyperlinkListener(this.hyperlinkListener);
        this.data.getTimeCriterion().removeObserver(this.observerCriterion);
        this.data.getEnergyCriterion().removeObserver(this.observerCriterion);
        this.data.getPriorityCriterion().removeObserver(this.observerCriterion);
        this.docListenerDescription = null;
        this.docListenerDelegatedTo = null;
        this.docListenerNotes = null;
        this.focusAdapterDescription = null;
        this.actionListenerTopic = null;
        this.actionListenerContext = null;
        this.actionListenerRecurrence = null;
        this.actionListenerEmail = null;
        this.actionListenerDoneCheckBox = null;
        this.actionListenerStatusCombo = null;
        this.actionListenerPriorityCombo = null;
        this.actionListenerEnergyCombo = null;
        this.actionListenerTimeCombo = null;
        this.changeListenerScheduledHour = null;
        this.changeListenerScheduledMinute = null;
        this.changeListenerDurationHour = null;
        this.changeListenerDurationMinute = null;
        this.propChangeListenerScheduledDate = null;
        this.propChangeListenerFollowupDate = null;
        this.propChangeListenerStartDate = null;
        this.propChangeListenerDueDate = null;
        this.propChangeListenerDoneDate = null;
        this.hyperlinkListener = null;
        this.observerCriterion = null;
    }
}

